/*
 * Decompiled with CFR 0.152.
 */
package datadog.appsec.api.blocking;

import datadog.appsec.api.blocking.BlockingContentType;
import datadog.appsec.api.blocking.BlockingDetails;
import datadog.appsec.api.blocking.BlockingException;
import datadog.appsec.api.blocking.BlockingService;
import java.util.Collections;
import java.util.Map;

public class Blocking {
    private static volatile BlockingService SERVICE = BlockingService.NOOP;

    private Blocking() {
    }

    public static UserBlockingSpec forUser(String userId) {
        if (userId == null) {
            throw new NullPointerException("userId cannot be null");
        }
        if (SERVICE == null) {
            throw new IllegalStateException("Blocking service is not available. Is AppSec disabled?");
        }
        return new UserBlockingSpec(userId);
    }

    public static boolean tryCommitBlockingResponse(int statusCode, BlockingContentType contentType, Map<String, String> extraHeaders) {
        try {
            return SERVICE.tryCommitBlockingResponse(statusCode, contentType, extraHeaders);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean tryCommitBlockingResponse(int statusCode, BlockingContentType contentType) {
        try {
            return SERVICE.tryCommitBlockingResponse(statusCode, BlockingContentType.NONE, Collections.emptyMap());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setBlockingService(BlockingService service) {
        SERVICE = service;
    }

    public static class UserBlockingSpec {
        private final String userId;

        private UserBlockingSpec(String userId) {
            this.userId = userId;
        }

        public BlockingDetails shouldBlock() {
            return SERVICE.shouldBlockUser(this.userId);
        }

        public void blockIfMatch() {
            BlockingDetails blockingDetails = this.shouldBlock();
            if (blockingDetails == null) {
                return;
            }
            SERVICE.tryCommitBlockingResponse(blockingDetails.statusCode, blockingDetails.blockingContentType, blockingDetails.extraHeaders);
            throw new BlockingException("Blocking user with id '" + this.userId + "'");
        }
    }
}

