/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DatadogHttpCodec {
    private static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String TRACE_ID_KEY = "x-datadog-trace-id";
    private static final String SPAN_ID_KEY = "x-datadog-parent-id";
    private static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";
    private static final String ORIGIN_KEY = "x-datadog-origin";

    private DatadogHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> baggage = Collections.emptyMap();
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                String origin = null;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (DatadogHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        traceId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (DatadogHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (DatadogHttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = Integer.parseInt(value);
                    } else if (DatadogHttpCodec.ORIGIN_KEY.equalsIgnoreCase(key)) {
                        origin = value;
                    } else if (key.startsWith(DatadogHttpCodec.OT_BAGGAGE_PREFIX)) {
                        if (baggage.isEmpty()) {
                            baggage = new HashMap<String, String>();
                        }
                        baggage.put(key.replace(DatadogHttpCodec.OT_BAGGAGE_PREFIX, ""), HttpCodec.decode(value));
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, origin, baggage, tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (origin != null || !tags.isEmpty()) {
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            carrier.put(DatadogHttpCodec.TRACE_ID_KEY, context.getTraceId().toString());
            carrier.put(DatadogHttpCodec.SPAN_ID_KEY, context.getSpanId().toString());
            String origin = context.getOrigin();
            if (origin != null) {
                carrier.put(DatadogHttpCodec.ORIGIN_KEY, origin);
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                carrier.put(DatadogHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            carrier.put(DatadogHttpCodec.SAMPLING_PRIORITY_KEY, "1");
        }
    }
}

