/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.decorators;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.decorators.AbstractDecorator;

public class ServletContextDecorator
extends AbstractDecorator {
    public ServletContextDecorator() {
        this.setMatchingTag("servlet.context");
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        String contextName = String.valueOf(value).trim();
        if (contextName.equals("/") || !context.getServiceName().equals("unnamed-java-app") && !context.getServiceName().isEmpty()) {
            return true;
        }
        if (contextName.startsWith("/") && contextName.length() > 1) {
            contextName = contextName.substring(1);
        }
        if (!contextName.isEmpty()) {
            context.setServiceName(contextName);
        }
        return true;
    }
}

