/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.WebViewRumEventMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0017J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "Lcom/google/gson/JsonObject;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "dataWriter", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "webViewRumEventMapper", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper;", "contextProvider", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/v2/core/internal/storage/DataWriter;Lcom/datadog/android/webview/internal/rum/WebViewRumEventMapper;Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;)V", "offsets", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "getOffsets$dd_sdk_android_release", "()Ljava/util/LinkedHashMap;", "consume", "", "event", "getOffset", "viewId", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "map", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "purgeOffsets", "Companion", "dd-sdk-android_release"})
public final class WebViewRumEventConsumer
implements WebViewEventConsumer<JsonObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final DataWriter<Object> dataWriter;
    @NotNull
    private final WebViewRumEventMapper webViewRumEventMapper;
    @NotNull
    private final WebViewRumEventContextProvider contextProvider;
    @NotNull
    private final LinkedHashMap<String, Long> offsets;
    public static final int MAX_VIEW_TIME_OFFSETS_RETAIN = 3;
    @NotNull
    public static final String VIEW_EVENT_TYPE = "view";
    @NotNull
    public static final String ACTION_EVENT_TYPE = "action";
    @NotNull
    public static final String RESOURCE_EVENT_TYPE = "resource";
    @NotNull
    public static final String ERROR_EVENT_TYPE = "error";
    @NotNull
    public static final String LONG_TASK_EVENT_TYPE = "long_task";
    @NotNull
    public static final String RUM_EVENT_TYPE = "rum";
    @NotNull
    public static final String VIEW_KEY_NAME = "view";
    @NotNull
    public static final String VIEW_ID_KEY_NAME = "id";
    @NotNull
    public static final String JSON_PARSING_ERROR_MESSAGE = "The bundled web RUM event could not be deserialized";
    @NotNull
    private static final Set<String> RUM_EVENT_TYPES;

    public WebViewRumEventConsumer(@NotNull SdkCore sdkCore, @NotNull DataWriter<Object> dataWriter, @NotNull WebViewRumEventMapper webViewRumEventMapper, @NotNull WebViewRumEventContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)webViewRumEventMapper, (String)"webViewRumEventMapper");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.sdkCore = sdkCore;
        this.dataWriter = dataWriter;
        this.webViewRumEventMapper = webViewRumEventMapper;
        this.contextProvider = contextProvider;
        this.offsets = new LinkedHashMap();
    }

    public /* synthetic */ WebViewRumEventConsumer(SdkCore sdkCore, DataWriter dataWriter, WebViewRumEventMapper webViewRumEventMapper, WebViewRumEventContextProvider webViewRumEventContextProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            webViewRumEventMapper = new WebViewRumEventMapper();
        }
        if ((n & 8) != 0) {
            webViewRumEventContextProvider = new WebViewRumEventContextProvider();
        }
        this(sdkCore, dataWriter, webViewRumEventMapper, webViewRumEventContextProvider);
    }

    @NotNull
    public final LinkedHashMap<String, Long> getOffsets$dd_sdk_android_release() {
        return this.offsets;
    }

    @Override
    @WorkerThread
    public void consume(@NotNull JsonObject event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GlobalRum.INSTANCE.notifyIngestedWebViewEvent$dd_sdk_android_release();
        FeatureScope featureScope = this.sdkCore.getFeature("web-rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event){
                final /* synthetic */ WebViewRumEventConsumer this$0;
                final /* synthetic */ JsonObject $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    RumContext rumContext = WebViewRumEventConsumer.access$getContextProvider$p(this.this$0).getRumContext(datadogContext);
                    JsonObject mappedEvent = WebViewRumEventConsumer.access$map(this.this$0, this.$event, datadogContext, rumContext);
                    WebViewRumEventConsumer.access$getDataWriter$p(this.this$0).write(eventBatchWriter, mappedEvent);
                }
            }, 1, null);
        }
    }

    private final JsonObject map(JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        try {
            long l;
            JsonElement jsonElement = event.get("view");
            if (jsonElement == null) {
                l = 0L;
            } else {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject == null) {
                    l = 0L;
                } else {
                    JsonElement jsonElement2 = jsonObject.get(VIEW_ID_KEY_NAME);
                    if (jsonElement2 == null) {
                        l = 0L;
                    } else {
                        String string = jsonElement2.getAsString();
                        if (string == null) {
                            l = 0L;
                        } else {
                            long l2;
                            String it = string;
                            boolean bl = false;
                            l = l2 = this.getOffset(it, datadogContext);
                        }
                    }
                }
            }
            long timeOffset = l;
            return this.webViewRumEventMapper.mapEvent(event, rumContext, timeOffset);
        }
        catch (ClassCastException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), JSON_PARSING_ERROR_MESSAGE, (Throwable)e);
        }
        catch (NumberFormatException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), JSON_PARSING_ERROR_MESSAGE, (Throwable)e);
        }
        catch (IllegalStateException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), JSON_PARSING_ERROR_MESSAGE, (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), JSON_PARSING_ERROR_MESSAGE, (Throwable)e);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getOffset(String viewId, DatadogContext datadogContext) {
        Long offset = null;
        offset = this.offsets.get(viewId);
        if (offset == null) {
            offset = datadogContext.getTime().getServerTimeOffsetMs();
            LinkedHashMap<String, Long> linkedHashMap = this.offsets;
            synchronized (linkedHashMap) {
                boolean bl = false;
                Map map = this.getOffsets$dd_sdk_android_release();
                Long l = offset;
                map.put(viewId, l);
                Unit unit = Unit.INSTANCE;
            }
        }
        this.purgeOffsets();
        return ((Number)offset).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeOffsets() {
        while (this.offsets.entrySet().size() > 3) {
            Object object;
            try {
                LinkedHashMap<String, Long> linkedHashMap = this.offsets;
                synchronized (linkedHashMap) {
                    boolean bl = false;
                    Set<Map.Entry<String, Long>> set = this.getOffsets$dd_sdk_android_release().entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"offsets.entries");
                    Object object2 = CollectionsKt.first((Iterable)set);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"offsets.entries.first()");
                    Map.Entry viewId = (Map.Entry)object2;
                    object = (Long)this.getOffsets$dd_sdk_android_release().remove(viewId.getKey());
                }
            }
            catch (NoSuchElementException e) {
                object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])object), "Trying to remove from an empty map.", (Throwable)e);
                break;
            }
        }
    }

    public static final /* synthetic */ WebViewRumEventContextProvider access$getContextProvider$p(WebViewRumEventConsumer $this) {
        return $this.contextProvider;
    }

    public static final /* synthetic */ JsonObject access$map(WebViewRumEventConsumer $this, JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        return $this.map(event, datadogContext, rumContext);
    }

    public static final /* synthetic */ DataWriter access$getDataWriter$p(WebViewRumEventConsumer $this) {
        return $this.dataWriter;
    }

    static {
        Object[] objectArray = new String[]{"view", ACTION_EVENT_TYPE, RESOURCE_EVENT_TYPE, LONG_TASK_EVENT_TYPE, ERROR_EVENT_TYPE, RUM_EVENT_TYPE};
        RUM_EVENT_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventConsumer$Companion;", "", "()V", "ACTION_EVENT_TYPE", "", "ERROR_EVENT_TYPE", "JSON_PARSING_ERROR_MESSAGE", "LONG_TASK_EVENT_TYPE", "MAX_VIEW_TIME_OFFSETS_RETAIN", "", "RESOURCE_EVENT_TYPE", "RUM_EVENT_TYPE", "RUM_EVENT_TYPES", "", "getRUM_EVENT_TYPES", "()Ljava/util/Set;", "VIEW_EVENT_TYPE", "VIEW_ID_KEY_NAME", "VIEW_KEY_NAME", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getRUM_EVENT_TYPES() {
            return RUM_EVENT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

