/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.webview.internal.storage;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.SerializerKt;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/v2/webview/internal/storage/WebViewLogsDataWriter;", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "Lcom/google/gson/JsonObject;", "serializer", "Lcom/datadog/android/core/internal/persistence/Serializer;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/Serializer;Lcom/datadog/android/v2/api/InternalLogger;)V", "write", "", "writer", "Lcom/datadog/android/v2/api/EventBatchWriter;", "element", "dd-sdk-android_release"})
public final class WebViewLogsDataWriter
implements DataWriter<JsonObject> {
    @NotNull
    private final Serializer<JsonObject> serializer;
    @NotNull
    private final InternalLogger internalLogger;

    public WebViewLogsDataWriter(@NotNull Serializer<JsonObject> serializer, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.serializer = serializer;
        this.internalLogger = internalLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public boolean write(@NotNull EventBatchWriter writer, @NotNull JsonObject element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        byte[] byArray = SerializerKt.serializeToByteArray(this.serializer, element, this.internalLogger);
        if (byArray == null) {
            return false;
        }
        byte[] serialized = byArray;
        synchronized (this) {
            boolean bl2 = false;
            bl = writer.write(serialized, null);
        }
        return bl;
    }
}

