/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.tracing.internal.net;

import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.v2.api.Request;
import com.datadog.android.v2.api.RequestFactory;
import com.datadog.android.v2.api.context.DatadogContext;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/v2/tracing/internal/net/TracesRequestFactory;", "Lcom/datadog/android/v2/api/RequestFactory;", "endpointUrl", "", "(Ljava/lang/String;)V", "buildHeaders", "", "requestId", "clientToken", "source", "sdkVersion", "create", "Lcom/datadog/android/v2/api/Request;", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "batchData", "", "", "batchMetadata", "Companion", "dd-sdk-android_release"})
public final class TracesRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpointUrl;
    @NotNull
    private static final byte[] PAYLOAD_SEPARATOR;

    public TracesRequestFactory(@NotNull String endpointUrl) {
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        this.endpointUrl = endpointUrl;
    }

    @Override
    @NotNull
    public Request create(@NotNull DatadogContext context, @NotNull List<byte[]> batchData, @Nullable byte[] batchMetadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        string = "%s/api/v2/spans";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.endpointUrl};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        return new Request(requestId, "Traces Request", string2, this.buildHeaders(requestId, context.getClientToken(), context.getSource(), context.getSdkVersion()), ByteArrayExtKt.join$default(batchData, PAYLOAD_SEPARATOR, null, null, 6, null), "text/plain;charset=UTF-8");
    }

    private final Map<String, String> buildHeaders(String requestId, String clientToken, String source, String sdkVersion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)clientToken), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)source), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)sdkVersion), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        byte[] byArray = "\n".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PAYLOAD_SEPARATOR = byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/v2/tracing/internal/net/TracesRequestFactory$Companion;", "", "()V", "PAYLOAD_SEPARATOR", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

