/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.rum.internal.net;

import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.v2.api.Request;
import com.datadog.android.v2.api.RequestFactory;
import com.datadog.android.v2.api.context.DatadogContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J0\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/v2/rum/internal/net/RumRequestFactory;", "Lcom/datadog/android/v2/api/RequestFactory;", "endpointUrl", "", "(Ljava/lang/String;)V", "buildHeaders", "", "requestId", "clientToken", "source", "sdkVersion", "buildTags", "serviceName", "version", "env", "variant", "buildUrl", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "create", "Lcom/datadog/android/v2/api/Request;", "batchData", "", "", "batchMetadata", "Companion", "dd-sdk-android_release"})
public final class RumRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpointUrl;
    @NotNull
    private static final byte[] PAYLOAD_SEPARATOR;

    public RumRequestFactory(@NotNull String endpointUrl) {
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        this.endpointUrl = endpointUrl;
    }

    @Override
    @NotNull
    public Request create(@NotNull DatadogContext context, @NotNull List<byte[]> batchData, @Nullable byte[] batchMetadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        return new Request(requestId, "RUM Request", this.buildUrl(context), this.buildHeaders(requestId, context.getClientToken(), context.getSource(), context.getSdkVersion()), ByteArrayExtKt.join$default(batchData, PAYLOAD_SEPARATOR, null, null, 6, null), "text/plain;charset=UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUrl(DatadogContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ddsource", (Object)context.getSource()), TuplesKt.to((Object)"ddtags", (Object)this.buildTags(context.getService(), context.getVersion(), context.getSdkVersion(), context.getEnv(), context.getVariant()))};
        Map queryParams = MapsKt.mapOf((Pair[])pairArray);
        Object object = "%s/api/v2/rum";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.endpointUrl};
        String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
        String intakeUrl2 = string;
        object = queryParams;
        String string2 = intakeUrl2;
        boolean $i$f$map = false;
        objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return string2 + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }

    private final Map<String, String> buildHeaders(String requestId, String clientToken, String source, String sdkVersion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)clientToken), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)source), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)sdkVersion), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String buildTags(String serviceName, String version, String sdkVersion, String env, String variant) {
        Object[] objectArray = new String[]{"service:" + serviceName, "version:" + version, "sdk_version:" + sdkVersion, "env:" + env};
        List elements = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)variant).length() > 0) {
            elements.add("variant:" + variant);
        }
        return CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        byte[] byArray = "\n".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PAYLOAD_SEPARATOR = byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/v2/rum/internal/net/RumRequestFactory$Companion;", "", "()V", "PAYLOAD_SEPARATOR", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

