/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.storage;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.BatchConfirmation;
import com.datadog.android.v2.core.internal.storage.BatchId;
import com.datadog.android.v2.core.internal.storage.BatchReader;
import com.datadog.android.v2.core.internal.storage.FileEventBatchWriter;
import com.datadog.android.v2.core.internal.storage.NoOpEventBatchWriter;
import com.datadog.android.v2.core.internal.storage.Storage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 22\u00020\u0001:\u000212BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0017J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0014H\u0003J\u001a\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0003J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0003J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001fH\u0003J\b\u0010$\u001a\u00020\u0016H\u0017J0\u0010%\u001a\u00020\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00160)H\u0017J,\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00160\u001aH\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/datadog/android/v2/core/internal/storage/ConsentAwareStorage;", "Lcom/datadog/android/v2/core/internal/storage/Storage;", "executorService", "Ljava/util/concurrent/ExecutorService;", "grantedOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "pendingOrchestrator", "batchEventsReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "batchMetadataReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "(Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FileMover;Lcom/datadog/android/v2/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;)V", "lockedBatches", "", "Lcom/datadog/android/v2/core/internal/storage/ConsentAwareStorage$Batch;", "confirmBatchRead", "", "batchId", "Lcom/datadog/android/v2/core/internal/storage/BatchId;", "callback", "Lkotlin/Function1;", "Lcom/datadog/android/v2/core/internal/storage/BatchConfirmation;", "deleteBatch", "batch", "batchFile", "Ljava/io/File;", "metaFile", "deleteBatchFile", "deleteBatchMetadataFile", "metadataFile", "dropAll", "readNextBatch", "noBatchCallback", "Lkotlin/Function0;", "batchCallback", "Lkotlin/Function2;", "Lcom/datadog/android/v2/core/internal/storage/BatchReader;", "writeCurrentBatch", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "forceNewBatch", "", "Lcom/datadog/android/v2/api/EventBatchWriter;", "Batch", "Companion", "dd-sdk-android_release"})
public final class ConsentAwareStorage
implements Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final FileOrchestrator grantedOrchestrator;
    @NotNull
    private final FileOrchestrator pendingOrchestrator;
    @NotNull
    private final BatchFileReaderWriter batchEventsReaderWriter;
    @NotNull
    private final FileReaderWriter batchMetadataReaderWriter;
    @NotNull
    private final FileMover fileMover;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    private final Set<Batch> lockedBatches;
    @NotNull
    public static final String WARNING_DELETE_FAILED = "Unable to delete file: %s";
    @NotNull
    public static final String ERROR_WRITE_CONTEXT_EXECUTION_REJECTED = "Execution in the write context was rejected.";

    public ConsentAwareStorage(@NotNull ExecutorService executorService, @NotNull FileOrchestrator grantedOrchestrator, @NotNull FileOrchestrator pendingOrchestrator, @NotNull BatchFileReaderWriter batchEventsReaderWriter, @NotNull FileReaderWriter batchMetadataReaderWriter, @NotNull FileMover fileMover, @NotNull InternalLogger internalLogger, @NotNull FilePersistenceConfig filePersistenceConfig) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)grantedOrchestrator, (String)"grantedOrchestrator");
        Intrinsics.checkNotNullParameter((Object)pendingOrchestrator, (String)"pendingOrchestrator");
        Intrinsics.checkNotNullParameter((Object)batchEventsReaderWriter, (String)"batchEventsReaderWriter");
        Intrinsics.checkNotNullParameter((Object)batchMetadataReaderWriter, (String)"batchMetadataReaderWriter");
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        this.executorService = executorService;
        this.grantedOrchestrator = grantedOrchestrator;
        this.pendingOrchestrator = pendingOrchestrator;
        this.batchEventsReaderWriter = batchEventsReaderWriter;
        this.batchMetadataReaderWriter = batchMetadataReaderWriter;
        this.fileMover = fileMover;
        this.internalLogger = internalLogger;
        this.filePersistenceConfig = filePersistenceConfig;
        this.lockedBatches = new LinkedHashSet();
    }

    @Override
    @WorkerThread
    public void writeCurrentBatch(@NotNull DatadogContext datadogContext, boolean forceNewBatch, @NotNull Function1<? super EventBatchWriter, Unit> callback) {
        FileOrchestrator fileOrchestrator;
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        switch (WhenMappings.$EnumSwitchMapping$0[datadogContext.getTrackingConsent().ordinal()]) {
            case 1: {
                fileOrchestrator = this.grantedOrchestrator;
                break;
            }
            case 2: {
                fileOrchestrator = this.pendingOrchestrator;
                break;
            }
            case 3: {
                fileOrchestrator = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FileOrchestrator orchestrator = fileOrchestrator;
        try {
            this.executorService.submit(() -> ConsentAwareStorage.writeCurrentBatch$lambda-0(orchestrator, forceNewBatch, this, callback));
        }
        catch (RejectedExecutionException rje) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, ERROR_WRITE_CONTEXT_EXECUTION_REJECTED, (Throwable)rje);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    public void readNextBatch(@NotNull Function0<Unit> noBatchCallback, @NotNull Function2<? super BatchId, ? super BatchReader, Unit> batchCallback) {
        Pair $i$a$-synchronized-ConsentAwareStorage$readNextBatch$2;
        Intrinsics.checkNotNullParameter(noBatchCallback, (String)"noBatchCallback");
        Intrinsics.checkNotNullParameter(batchCallback, (String)"batchCallback");
        Set<Batch> set = this.lockedBatches;
        synchronized (set) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Iterable iterable = this.lockedBatches;
            FileOrchestrator fileOrchestrator = this.grantedOrchestrator;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Batch batch = (Batch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            File batchFile = fileOrchestrator.getReadableFile(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            if (batchFile == null) {
                noBatchCallback.invoke();
                return;
            }
            File metaFile = this.grantedOrchestrator.getMetadataFile(batchFile);
            this.lockedBatches.add(new Batch(batchFile, metaFile));
            $i$a$-synchronized-ConsentAwareStorage$readNextBatch$2 = TuplesKt.to((Object)batchFile, (Object)metaFile);
        }
        Pair pair = $i$a$-synchronized-ConsentAwareStorage$readNextBatch$2;
        File batchFile = (File)pair.component1();
        File metaFile = (File)pair.component2();
        BatchId batchId = BatchId.Companion.fromFile(batchFile);
        BatchReader reader2 = new BatchReader(metaFile, this, batchFile){
            final /* synthetic */ File $metaFile;
            final /* synthetic */ ConsentAwareStorage this$0;
            final /* synthetic */ File $batchFile;
            {
                this.$metaFile = $metaFile;
                this.this$0 = $receiver;
                this.$batchFile = $batchFile;
            }

            @WorkerThread
            @Nullable
            public byte[] currentMetadata() {
                if (this.$metaFile == null || !FileExtKt.existsSafe(this.$metaFile)) {
                    return null;
                }
                return ConsentAwareStorage.access$getBatchMetadataReaderWriter$p(this.this$0).readData(this.$metaFile);
            }

            @WorkerThread
            @NotNull
            public List<byte[]> read() {
                return ConsentAwareStorage.access$getBatchEventsReaderWriter$p(this.this$0).readData(this.$batchFile);
            }
        };
        batchCallback.invoke((Object)batchId, (Object)reader2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void confirmBatchRead(@NotNull BatchId batchId, @NotNull Function1<? super BatchConfirmation, Unit> callback) {
        Batch batch;
        Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Set<Batch> set = this.lockedBatches;
        synchronized (set) {
            Object v0;
            block5: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.lockedBatches;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Batch it = (Batch)element$iv;
                    boolean bl2 = false;
                    if (!batchId.matchesFile(it.getFile())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            batch = v0;
        }
        Batch batch2 = batch;
        if (batch2 == null) {
            return;
        }
        Batch batch3 = batch2;
        BatchConfirmation confirmation2 = new BatchConfirmation(this, batch3){
            final /* synthetic */ ConsentAwareStorage this$0;
            final /* synthetic */ Batch $batch;
            {
                this.this$0 = $receiver;
                this.$batch = $batch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @WorkerThread
            public void markAsRead(boolean deleteBatch) {
                if (deleteBatch) {
                    ConsentAwareStorage.access$deleteBatch(this.this$0, this.$batch);
                }
                Set set = ConsentAwareStorage.access$getLockedBatches$p(this.this$0);
                ConsentAwareStorage consentAwareStorage = this.this$0;
                Batch batch = this.$batch;
                synchronized (set) {
                    boolean bl = false;
                    boolean bl2 = ConsentAwareStorage.access$getLockedBatches$p(consentAwareStorage).remove(batch);
                }
            }
        };
        callback.invoke((Object)confirmation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    public void dropAll() {
        void $this$forEach$iv;
        FileOrchestrator[] fileOrchestratorArray = this.lockedBatches;
        synchronized (fileOrchestratorArray) {
            boolean $i$a$-synchronized-ConsentAwareStorage$dropAll$22 = false;
            Iterable $this$forEach$iv2 = this.lockedBatches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Batch it = (Batch)element$iv;
                boolean bl = false;
                this.deleteBatch(it);
                this.lockedBatches.remove(it);
            }
            Unit $i$a$-synchronized-ConsentAwareStorage$dropAll$22 = Unit.INSTANCE;
        }
        fileOrchestratorArray = new FileOrchestrator[]{this.pendingOrchestrator, this.grantedOrchestrator};
        boolean $i$f$forEach = false;
        void var3_6 = $this$forEach$iv;
        int n = 0;
        int n2 = ((void)var3_6).length;
        while (n < n2) {
            Object element$iv;
            element$iv = var3_6[n];
            ++n;
            Object orchestrator = element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv3 = orchestrator.getAllFiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                File it = (File)element$iv2;
                boolean bl2 = false;
                File metaFile = orchestrator.getMetadataFile(it);
                this.deleteBatch(it, metaFile);
            }
        }
    }

    @WorkerThread
    private final void deleteBatch(Batch batch) {
        this.deleteBatch(batch.getFile(), batch.getMetaFile());
    }

    @WorkerThread
    private final void deleteBatch(File batchFile, File metaFile) {
        this.deleteBatchFile(batchFile);
        File file = metaFile;
        if (file == null ? false : FileExtKt.existsSafe(file)) {
            this.deleteBatchMetadataFile(metaFile);
        }
    }

    @WorkerThread
    private final void deleteBatchFile(File batchFile) {
        boolean result = this.fileMover.delete(batchFile);
        if (!result) {
            String string = WARNING_DELETE_FAILED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{batchFile.getPath()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, string2, null, 8, null);
        }
    }

    @WorkerThread
    private final void deleteBatchMetadataFile(File metadataFile) {
        boolean result = this.fileMover.delete(metadataFile);
        if (!result) {
            String string = WARNING_DELETE_FAILED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{metadataFile.getPath()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, string2, null, 8, null);
        }
    }

    private static final void writeCurrentBatch$lambda-0(FileOrchestrator $orchestrator, boolean $forceNewBatch, ConsentAwareStorage this$0, Function1 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        FileOrchestrator fileOrchestrator = $orchestrator;
        File batchFile = fileOrchestrator == null ? null : fileOrchestrator.getWritableFile($forceNewBatch);
        File metadataFile = batchFile != null ? $orchestrator.getMetadataFile(batchFile) : (File)null;
        EventBatchWriter writer = $orchestrator == null || batchFile == null ? (EventBatchWriter)new NoOpEventBatchWriter() : (EventBatchWriter)new FileEventBatchWriter(batchFile, metadataFile, this$0.batchEventsReaderWriter, this$0.batchMetadataReaderWriter, this$0.filePersistenceConfig, this$0.internalLogger);
        $callback.invoke((Object)writer);
    }

    public static final /* synthetic */ FileReaderWriter access$getBatchMetadataReaderWriter$p(ConsentAwareStorage $this) {
        return $this.batchMetadataReaderWriter;
    }

    public static final /* synthetic */ BatchFileReaderWriter access$getBatchEventsReaderWriter$p(ConsentAwareStorage $this) {
        return $this.batchEventsReaderWriter;
    }

    public static final /* synthetic */ void access$deleteBatch(ConsentAwareStorage $this, Batch batch) {
        $this.deleteBatch(batch);
    }

    public static final /* synthetic */ Set access$getLockedBatches$p(ConsentAwareStorage $this) {
        return $this.lockedBatches;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/v2/core/internal/storage/ConsentAwareStorage$Batch;", "", "file", "Ljava/io/File;", "metaFile", "(Ljava/io/File;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getMetaFile", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android_release"})
    private static final class Batch {
        @NotNull
        private final File file;
        @Nullable
        private final File metaFile;

        public Batch(@NotNull File file, @Nullable File metaFile) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.metaFile = metaFile;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Nullable
        public final File getMetaFile() {
            return this.metaFile;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        @Nullable
        public final File component2() {
            return this.metaFile;
        }

        @NotNull
        public final Batch copy(@NotNull File file, @Nullable File metaFile) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Batch(file, metaFile);
        }

        public static /* synthetic */ Batch copy$default(Batch batch, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = batch.file;
            }
            if ((n & 2) != 0) {
                file2 = batch.metaFile;
            }
            return batch.copy(file, file2);
        }

        @NotNull
        public String toString() {
            return "Batch(file=" + this.file + ", metaFile=" + this.metaFile + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + (this.metaFile == null ? 0 : this.metaFile.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Batch)) {
                return false;
            }
            Batch batch = (Batch)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)batch.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.metaFile, (Object)batch.metaFile);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/v2/core/internal/storage/ConsentAwareStorage$Companion;", "", "()V", "ERROR_WRITE_CONTEXT_EXECUTION_REJECTED", "", "WARNING_DELETE_FAILED", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackingConsent.values().length];
            nArray[TrackingConsent.GRANTED.ordinal()] = 1;
            nArray[TrackingConsent.PENDING.ordinal()] = 2;
            nArray[TrackingConsent.NOT_GRANTED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

