/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.net;

import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.RequestFactory;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.net.DataUploader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0002J(\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\u00101\u001a\u0004\u0018\u000100H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\u0016\u00a8\u00063"}, d2={"Lcom/datadog/android/v2/core/internal/net/DataOkHttpUploader;", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "requestFactory", "Lcom/datadog/android/v2/api/RequestFactory;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "callFactory", "Lokhttp3/Call$Factory;", "sdkVersion", "", "androidInfoProvider", "Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "(Lcom/datadog/android/v2/api/RequestFactory;Lcom/datadog/android/v2/api/InternalLogger;Lokhttp3/Call$Factory;Ljava/lang/String;Lcom/datadog/android/core/internal/system/AndroidInfoProvider;)V", "getAndroidInfoProvider", "()Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "getCallFactory", "()Lokhttp3/Call$Factory;", "getInternalLogger", "()Lcom/datadog/android/v2/api/InternalLogger;", "getRequestFactory", "()Lcom/datadog/android/v2/api/RequestFactory;", "getSdkVersion", "()Ljava/lang/String;", "userAgent", "getUserAgent", "userAgent$delegate", "Lkotlin/Lazy;", "buildOkHttpRequest", "Lokhttp3/Request;", "request", "Lcom/datadog/android/v2/api/Request;", "executeUploadRequest", "Lcom/datadog/android/core/internal/net/UploadStatus;", "isValidHeaderValue", "", "value", "isValidHeaderValueChar", "c", "", "responseCodeToUploadStatus", "code", "", "sanitizeHeaderValue", "upload", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "batch", "", "", "batchMeta", "Companion", "dd-sdk-android_release"})
public final class DataOkHttpUploader
implements DataUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final AndroidInfoProvider androidInfoProvider;
    @NotNull
    private final Lazy userAgent$delegate;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_UNAVAILABLE = 503;
    @NotNull
    public static final String SYSTEM_UA = "http.agent";
    @NotNull
    public static final String WARNING_USER_AGENT_HEADER_RESERVED = "Ignoring provided User-Agent header, because it is reserved.";
    @NotNull
    public static final String HEADER_USER_AGENT = "User-Agent";

    public DataOkHttpUploader(@NotNull RequestFactory requestFactory, @NotNull InternalLogger internalLogger, @NotNull Call.Factory callFactory, @NotNull String sdkVersion, @NotNull AndroidInfoProvider androidInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)androidInfoProvider, (String)"androidInfoProvider");
        this.requestFactory = requestFactory;
        this.internalLogger = internalLogger;
        this.callFactory = callFactory;
        this.sdkVersion = sdkVersion;
        this.androidInfoProvider = androidInfoProvider;
        this.userAgent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DataOkHttpUploader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                CharSequence charSequence = DataOkHttpUploader.access$sanitizeHeaderValue(this.this$0, System.getProperty("http.agent"));
                DataOkHttpUploader dataOkHttpUploader = this.this$0;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    boolean bl = false;
                    object = "Datadog/" + dataOkHttpUploader.getSdkVersion() + " (Linux; U; Android " + dataOkHttpUploader.getAndroidInfoProvider().getOsVersion() + "; " + dataOkHttpUploader.getAndroidInfoProvider().getDeviceModel() + " Build/" + dataOkHttpUploader.getAndroidInfoProvider().getDeviceBuildId() + ")";
                } else {
                    object = charSequence;
                }
                return (String)object;
            }
        }));
    }

    @NotNull
    public final RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @NotNull
    public final Call.Factory getCallFactory() {
        return this.callFactory;
    }

    @NotNull
    public final String getSdkVersion() {
        return this.sdkVersion;
    }

    @NotNull
    public final AndroidInfoProvider getAndroidInfoProvider() {
        return this.androidInfoProvider;
    }

    @Override
    @NotNull
    public UploadStatus upload(@NotNull DatadogContext context, @NotNull List<byte[]> batch, @Nullable byte[] batchMeta) {
        UploadStatus uploadStatus;
        com.datadog.android.v2.api.Request request;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        try {
            request = this.requestFactory.create(context, batch, batchMeta);
        }
        catch (Exception e) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, "Unable to create the request due to probably bad data format. The batch will be dropped.", (Throwable)e);
            return UploadStatus.REQUEST_CREATION_ERROR;
        }
        com.datadog.android.v2.api.Request request2 = request;
        try {
            uploadStatus = this.executeUploadRequest(request2);
        }
        catch (Throwable e) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unable to upload batch data.", e);
            uploadStatus = UploadStatus.NETWORK_ERROR;
        }
        UploadStatus uploadStatus2 = uploadStatus;
        uploadStatus2.logStatus(request2.getDescription(), request2.getBody().length, this.internalLogger, request2.getId());
        return uploadStatus2;
    }

    private final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final UploadStatus executeUploadRequest(com.datadog.android.v2.api.Request request) {
        String apiKey;
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Iterable iterable = request.getHeaders().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)((String)it.getKey()), (String)"DD-API-KEY", (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        String string = apiKey = entry == null ? null : (String)entry.getValue();
        if (apiKey != null && (((CharSequence)apiKey).length() == 0 || !this.isValidHeaderValue(apiKey))) {
            return UploadStatus.INVALID_TOKEN_ERROR;
        }
        Request okHttpRequest = this.buildOkHttpRequest(request);
        Call call = this.callFactory.newCall(okHttpRequest);
        Response response = call.execute();
        response.close();
        return this.responseCodeToUploadStatus(response.code());
    }

    private final Request buildOkHttpRequest(com.datadog.android.v2.api.Request request) {
        MediaType mediaType = request.getContentType() == null ? (MediaType)null : MediaType.parse((String)request.getContentType());
        Request.Builder builder = new Request.Builder().url(request.getUrl()).post(RequestBody.create((MediaType)mediaType, (byte[])request.getBody()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            String header = entry.getKey();
            String value = entry.getValue();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = header.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            if (Intrinsics.areEqual((Object)string, (Object)"user-agent")) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, WARNING_USER_AGENT_HEADER_RESERVED, null, 8, null);
                continue;
            }
            builder.addHeader(header, value);
        }
        builder.addHeader(HEADER_USER_AGENT, this.getUserAgent());
        Request request2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"builder.build()");
        return request2;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeHeaderValue(String value) {
        String string;
        String string2;
        String string3 = value;
        if (string3 == null) {
            string2 = null;
        } else {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = string3;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                char element$iv$iv;
                int index$iv$iv = n++;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!this.isValidHeaderValueChar(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string4 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"filterTo(StringBuilder(), predicate).toString()");
            string2 = string = string4;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private final boolean isValidHeaderValue(String value) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (this.isValidHeaderValueChar(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidHeaderValueChar(char c) {
        if (c == '\t') return true;
        if (' ' > c) return false;
        if (c >= '\u007f') return false;
        return true;
    }

    private final UploadStatus responseCodeToUploadStatus(int code) {
        UploadStatus uploadStatus;
        switch (code) {
            case 202: {
                uploadStatus = UploadStatus.SUCCESS;
                break;
            }
            case 400: {
                uploadStatus = UploadStatus.HTTP_CLIENT_ERROR;
                break;
            }
            case 401: {
                uploadStatus = UploadStatus.INVALID_TOKEN_ERROR;
                break;
            }
            case 403: {
                uploadStatus = UploadStatus.INVALID_TOKEN_ERROR;
                break;
            }
            case 408: {
                uploadStatus = UploadStatus.HTTP_CLIENT_RATE_LIMITING;
                break;
            }
            case 413: {
                uploadStatus = UploadStatus.HTTP_CLIENT_ERROR;
                break;
            }
            case 429: {
                uploadStatus = UploadStatus.HTTP_CLIENT_RATE_LIMITING;
                break;
            }
            case 500: {
                uploadStatus = UploadStatus.HTTP_SERVER_ERROR;
                break;
            }
            case 503: {
                uploadStatus = UploadStatus.HTTP_SERVER_ERROR;
                break;
            }
            default: {
                uploadStatus = UploadStatus.UNKNOWN_ERROR;
            }
        }
        return uploadStatus;
    }

    public static final /* synthetic */ String access$sanitizeHeaderValue(DataOkHttpUploader $this, String value) {
        return $this.sanitizeHeaderValue(value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/v2/core/internal/net/DataOkHttpUploader$Companion;", "", "()V", "HEADER_USER_AGENT", "", "HTTP_ACCEPTED", "", "HTTP_BAD_REQUEST", "HTTP_CLIENT_TIMEOUT", "HTTP_ENTITY_TOO_LARGE", "HTTP_FORBIDDEN", "HTTP_INTERNAL_ERROR", "HTTP_TOO_MANY_REQUESTS", "HTTP_UNAUTHORIZED", "HTTP_UNAVAILABLE", "SYSTEM_UA", "WARNING_USER_AGENT_HEADER_RESERVED", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

