/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.data.upload;

import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.data.upload.UploadScheduler;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.data.upload.DataUploadRunnable;
import com.datadog.android.v2.core.internal.net.DataUploader;
import com.datadog.android.v2.core.internal.storage.Storage;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/v2/core/internal/data/upload/DataUploadScheduler;", "Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "storage", "Lcom/datadog/android/v2/core/internal/storage/Storage;", "dataUploader", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "(Lcom/datadog/android/v2/core/internal/storage/Storage;Lcom/datadog/android/v2/core/internal/net/DataUploader;Lcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/configuration/UploadFrequency;Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "runnable", "Lcom/datadog/android/v2/core/internal/data/upload/DataUploadRunnable;", "startScheduling", "", "stopScheduling", "dd-sdk-android_release"})
public final class DataUploadScheduler
implements UploadScheduler {
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @NotNull
    private final DataUploadRunnable runnable;

    public DataUploadScheduler(@NotNull Storage storage, @NotNull DataUploader dataUploader, @NotNull ContextProvider contextProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull UploadFrequency uploadFrequency, @NotNull ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
        Intrinsics.checkNotNullParameter((Object)scheduledThreadPoolExecutor, (String)"scheduledThreadPoolExecutor");
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.runnable = new DataUploadRunnable(this.scheduledThreadPoolExecutor, storage, dataUploader, contextProvider, networkInfoProvider, systemInfoProvider, uploadFrequency, 0L, 128, null);
    }

    @Override
    public void startScheduling() {
        ConcurrencyExtKt.scheduleSafe(this.scheduledThreadPoolExecutor, "Data upload", this.runnable.getCurrentDelayIntervalMs$dd_sdk_android_release(), TimeUnit.MILLISECONDS, this.runnable);
    }

    @Override
    public void stopScheduling() {
        this.scheduledThreadPoolExecutor.remove(this.runnable);
    }
}

