/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.data.upload.UploadRunnable;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.net.DataUploader;
import com.datadog.android.v2.core.internal.storage.BatchConfirmation;
import com.datadog.android.v2.core.internal.storage.BatchId;
import com.datadog.android.v2.core.internal.storage.BatchReader;
import com.datadog.android.v2.core.internal.storage.Storage;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010'\u001a\u0004\u0018\u00010&H\u0003J\b\u0010(\u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020\u001fH\u0017J\b\u0010.\u001a\u00020\u001fH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/datadog/android/v2/core/internal/data/upload/DataUploadRunnable;", "Lcom/datadog/android/core/internal/data/upload/UploadRunnable;", "threadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "storage", "Lcom/datadog/android/v2/core/internal/storage/Storage;", "dataUploader", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "batchUploadWaitTimeoutMs", "", "(Ljava/util/concurrent/ScheduledThreadPoolExecutor;Lcom/datadog/android/v2/core/internal/storage/Storage;Lcom/datadog/android/v2/core/internal/net/DataUploader;Lcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/configuration/UploadFrequency;J)V", "currentDelayIntervalMs", "getCurrentDelayIntervalMs$dd_sdk_android_release", "()J", "setCurrentDelayIntervalMs$dd_sdk_android_release", "(J)V", "maxDelayMs", "getMaxDelayMs$dd_sdk_android_release", "setMaxDelayMs$dd_sdk_android_release", "minDelayMs", "getMinDelayMs$dd_sdk_android_release", "setMinDelayMs$dd_sdk_android_release", "consumeBatch", "", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "batchId", "Lcom/datadog/android/v2/core/internal/storage/BatchId;", "batch", "", "", "batchMeta", "decreaseInterval", "increaseInterval", "isNetworkAvailable", "", "isSystemReady", "run", "scheduleNextUpload", "Companion", "dd-sdk-android_release"})
public final class DataUploadRunnable
implements UploadRunnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledThreadPoolExecutor threadPoolExecutor;
    @NotNull
    private final Storage storage;
    @NotNull
    private final DataUploader dataUploader;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final SystemInfoProvider systemInfoProvider;
    private final long batchUploadWaitTimeoutMs;
    private long currentDelayIntervalMs;
    private long minDelayMs;
    private long maxDelayMs;
    public static final int LOW_BATTERY_THRESHOLD = 10;
    public static final int MIN_DELAY_FACTOR = 1;
    public static final int DEFAULT_DELAY_FACTOR = 5;
    public static final int MAX_DELAY_FACTOR = 10;
    public static final double DECREASE_PERCENT = 0.9;
    public static final double INCREASE_PERCENT = 1.1;

    public DataUploadRunnable(@NotNull ScheduledThreadPoolExecutor threadPoolExecutor, @NotNull Storage storage, @NotNull DataUploader dataUploader, @NotNull ContextProvider contextProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull UploadFrequency uploadFrequency, long batchUploadWaitTimeoutMs) {
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
        this.threadPoolExecutor = threadPoolExecutor;
        this.storage = storage;
        this.dataUploader = dataUploader;
        this.contextProvider = contextProvider;
        this.networkInfoProvider = networkInfoProvider;
        this.systemInfoProvider = systemInfoProvider;
        this.batchUploadWaitTimeoutMs = batchUploadWaitTimeoutMs;
        this.currentDelayIntervalMs = (long)5 * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
        this.minDelayMs = 1L * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
        this.maxDelayMs = (long)10 * uploadFrequency.getBaseStepMs$dd_sdk_android_release();
    }

    public /* synthetic */ DataUploadRunnable(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Storage storage, DataUploader dataUploader, ContextProvider contextProvider, NetworkInfoProvider networkInfoProvider, SystemInfoProvider systemInfoProvider, UploadFrequency uploadFrequency, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            l = CoreFeature.Companion.getNETWORK_TIMEOUT_MS$dd_sdk_android_release();
        }
        this(scheduledThreadPoolExecutor, storage, dataUploader, contextProvider, networkInfoProvider, systemInfoProvider, uploadFrequency, l);
    }

    public final long getCurrentDelayIntervalMs$dd_sdk_android_release() {
        return this.currentDelayIntervalMs;
    }

    public final void setCurrentDelayIntervalMs$dd_sdk_android_release(long l) {
        this.currentDelayIntervalMs = l;
    }

    public final long getMinDelayMs$dd_sdk_android_release() {
        return this.minDelayMs;
    }

    public final void setMinDelayMs$dd_sdk_android_release(long l) {
        this.minDelayMs = l;
    }

    public final long getMaxDelayMs$dd_sdk_android_release() {
        return this.maxDelayMs;
    }

    public final void setMaxDelayMs$dd_sdk_android_release(long l) {
        this.maxDelayMs = l;
    }

    @Override
    @WorkerThread
    public void run() {
        if (this.isNetworkAvailable() && this.isSystemReady()) {
            DatadogContext context = this.contextProvider.getContext();
            CountDownLatch lock = new CountDownLatch(1);
            this.storage.readNextBatch((Function0<Unit>)((Function0)new Function0<Unit>(this, lock){
                final /* synthetic */ DataUploadRunnable this$0;
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.this$0 = $receiver;
                    this.$lock = $lock;
                    super(0);
                }

                public final void invoke() {
                    DataUploadRunnable.access$increaseInterval(this.this$0);
                    this.$lock.countDown();
                }
            }), (Function2<? super BatchId, ? super BatchReader, Unit>)((Function2)new Function2<BatchId, BatchReader, Unit>(this, context, lock){
                final /* synthetic */ DataUploadRunnable this$0;
                final /* synthetic */ DatadogContext $context;
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$lock = $lock;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull BatchId batchId, @NotNull BatchReader reader2) {
                    Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
                    Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                    try {
                        List<byte[]> batch = reader2.read();
                        byte[] batchMeta = reader2.currentMetadata();
                        DataUploadRunnable.access$consumeBatch(this.this$0, this.$context, batchId, batch, batchMeta);
                    }
                    finally {
                        this.$lock.countDown();
                    }
                }
            }));
            lock.await(this.batchUploadWaitTimeoutMs, TimeUnit.MILLISECONDS);
        }
        this.scheduleNextUpload();
    }

    private final boolean isNetworkAvailable() {
        NetworkInfo networkInfo = this.networkInfoProvider.getLatestNetworkInfo();
        return networkInfo.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    private final boolean isSystemReady() {
        SystemInfo systemInfo = this.systemInfoProvider.getLatestSystemInfo();
        boolean hasEnoughPower = systemInfo.getBatteryFullOrCharging() || systemInfo.getOnExternalPowerSource() || systemInfo.getBatteryLevel() > 10;
        return hasEnoughPower && !systemInfo.getPowerSaveMode();
    }

    private final void scheduleNextUpload() {
        this.threadPoolExecutor.remove(this);
        ConcurrencyExtKt.scheduleSafe(this.threadPoolExecutor, "Data upload", this.currentDelayIntervalMs, TimeUnit.MILLISECONDS, this);
    }

    @WorkerThread
    private final void consumeBatch(DatadogContext context, BatchId batchId, List<byte[]> batch, byte[] batchMeta) {
        UploadStatus status = this.dataUploader.upload(context, batch, batchMeta);
        this.storage.confirmBatchRead(batchId, (Function1<? super BatchConfirmation, Unit>)((Function1)new Function1<BatchConfirmation, Unit>(status, this){
            final /* synthetic */ UploadStatus $status;
            final /* synthetic */ DataUploadRunnable this$0;
            {
                this.$status = $status;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BatchConfirmation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$status.getShouldRetry()) {
                    it.markAsRead(false);
                    DataUploadRunnable.access$increaseInterval(this.this$0);
                } else {
                    it.markAsRead(true);
                    DataUploadRunnable.access$decreaseInterval(this.this$0);
                }
            }
        }));
    }

    private final void decreaseInterval() {
        this.currentDelayIntervalMs = Math.max(this.minDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 0.9)));
    }

    private final void increaseInterval() {
        this.currentDelayIntervalMs = Math.min(this.maxDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 1.1)));
    }

    public static final /* synthetic */ void access$increaseInterval(DataUploadRunnable $this) {
        $this.increaseInterval();
    }

    public static final /* synthetic */ void access$consumeBatch(DataUploadRunnable $this, DatadogContext context, BatchId batchId, List batch, byte[] batchMeta) {
        $this.consumeBatch(context, batchId, batch, batchMeta);
    }

    public static final /* synthetic */ void access$decreaseInterval(DataUploadRunnable $this) {
        $this.decreaseInterval();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/v2/core/internal/data/upload/DataUploadRunnable$Companion;", "", "()V", "DECREASE_PERCENT", "", "DEFAULT_DELAY_FACTOR", "", "INCREASE_PERCENT", "LOW_BATTERY_THRESHOLD", "MAX_DELAY_FACTOR", "MIN_DELAY_FACTOR", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

