/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.DeviceInfo;
import com.datadog.android.v2.api.context.DeviceType;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.ProcessInfo;
import com.datadog.android.v2.api.context.TimeInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\rH\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\r2\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/v2/core/internal/DatadogContextProvider;", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "(Lcom/datadog/android/core/internal/CoreFeature;)V", "context", "Lcom/datadog/android/v2/api/context/DatadogContext;", "getContext", "()Lcom/datadog/android/v2/api/context/DatadogContext;", "getCoreFeature", "()Lcom/datadog/android/core/internal/CoreFeature;", "getFeatureContext", "", "", "", "feature", "setFeatureContext", "", "dd-sdk-android_release"})
public final class DatadogContextProvider
implements ContextProvider {
    @NotNull
    private final CoreFeature coreFeature;

    public DatadogContextProvider(@NotNull CoreFeature coreFeature) {
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"coreFeature");
        this.coreFeature = coreFeature;
    }

    @NotNull
    public final CoreFeature getCoreFeature() {
        return this.coreFeature;
    }

    @Override
    @NotNull
    public DatadogContext getContext() {
        Map<String, Map<String, Object>> source;
        String string = this.coreFeature.getClientToken$dd_sdk_android_release();
        String string2 = this.coreFeature.getServiceName$dd_sdk_android_release();
        String string3 = this.coreFeature.getEnvName$dd_sdk_android_release();
        String string4 = this.coreFeature.getPackageVersionProvider$dd_sdk_android_release().getVersion();
        String string5 = this.coreFeature.getVariant$dd_sdk_android_release();
        String string6 = this.coreFeature.getSdkVersion$dd_sdk_android_release();
        String string7 = this.coreFeature.getSourceName$dd_sdk_android_release();
        TimeProvider $this$_get_context__u24lambda_u2d0 = this.coreFeature.getTimeProvider$dd_sdk_android_release();
        boolean bl = false;
        long deviceTimeMs = $this$_get_context__u24lambda_u2d0.getDeviceTimestamp();
        long serverTimeMs = $this$_get_context__u24lambda_u2d0.getServerTimestamp();
        TimeInfo timeInfo = new TimeInfo(TimeUnit.MILLISECONDS.toNanos(deviceTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs - deviceTimeMs), serverTimeMs - deviceTimeMs);
        ProcessInfo processInfo = new ProcessInfo(this.coreFeature.isMainProcess$dd_sdk_android_release(), CoreFeature.Companion.getProcessImportance$dd_sdk_android_release());
        NetworkInfo networkInfo = this.coreFeature.getNetworkInfoProvider$dd_sdk_android_release().getLatestNetworkInfo();
        AndroidInfoProvider $this$_get_context__u24lambda_u2d1 = this.coreFeature.getAndroidInfoProvider$dd_sdk_android_release();
        boolean bl2 = false;
        Object object = $this$_get_context__u24lambda_u2d1.getDeviceName();
        String string8 = $this$_get_context__u24lambda_u2d1.getDeviceBrand();
        DeviceType deviceType2 = $this$_get_context__u24lambda_u2d1.getDeviceType();
        String string9 = $this$_get_context__u24lambda_u2d1.getDeviceModel();
        String string10 = $this$_get_context__u24lambda_u2d1.getDeviceBuildId();
        String string11 = $this$_get_context__u24lambda_u2d1.getOsName();
        Object object2 = $this$_get_context__u24lambda_u2d1.getOsVersion();
        String string12 = $this$_get_context__u24lambda_u2d1.getOsMajorVersion();
        String string13 = $this$_get_context__u24lambda_u2d1.getArchitecture();
        DeviceInfo deviceInfo = new DeviceInfo((String)object, string8, string9, deviceType2, string10, string11, string12, (String)object2, string13);
        UserInfo userInfo = this.coreFeature.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        TrackingConsent trackingConsent = this.coreFeature.getTrackingConsentProvider$dd_sdk_android_release().getConsent();
        Object $this$_get_context__u24lambda_u2d3 = object = (Map)new LinkedHashMap();
        boolean bl3 = false;
        Map<String, Map<String, Object>> $this$forEach$iv = source = this.getCoreFeature().getFeaturesContext$dd_sdk_android_release();
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = (Map.Entry)object2.next();
            boolean bl4 = false;
            String key = (String)$dstr$key$value.getKey();
            Map value = (Map)$dstr$key$value.getValue();
            Object object3 = $this$_get_context__u24lambda_u2d3;
            Map map = MapsKt.toMap((Map)value);
            object3.put(key, map);
        }
        Object object4 = object;
        return new DatadogContext(string, string2, string3, string4, string5, string7, string6, timeInfo, processInfo, networkInfo, deviceInfo, userInfo, trackingConsent, (Map<String, ? extends Map<String, ? extends Object>>)object4);
    }

    @Override
    public void setFeatureContext(@NotNull String feature, @NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.coreFeature.getFeaturesContext$dd_sdk_android_release().put(feature, context);
    }

    @Override
    @NotNull
    public Map<String, Object> getFeatureContext(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Map<String, Object> map = this.coreFeature.getFeaturesContext$dd_sdk_android_release().get(feature);
        Map map2 = map == null ? null : MapsKt.toMap(map);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }
}

