/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.core.LogcatLogHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u000fH\u0002R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/v2/core/SdkInternalLogger;", "Lcom/datadog/android/v2/api/InternalLogger;", "devLogHandlerFactory", "Lkotlin/Function0;", "Lcom/datadog/android/v2/core/LogcatLogHandler;", "sdkLogHandlerFactory", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "devLogger", "getDevLogger$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/LogcatLogHandler;", "sdkLogger", "getSdkLogger$dd_sdk_android_release", "log", "", "level", "Lcom/datadog/android/v2/api/InternalLogger$Level;", "target", "Lcom/datadog/android/v2/api/InternalLogger$Target;", "message", "", "throwable", "", "targets", "", "logToMaintainer", "error", "logToTelemetry", "logToUser", "toLogLevel", "", "Companion", "dd-sdk-android_release"})
public final class SdkInternalLogger
implements InternalLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogcatLogHandler devLogger;
    @Nullable
    private final LogcatLogHandler sdkLogger;
    @NotNull
    public static final String SDK_LOG_TAG = "DD_LOG";
    @NotNull
    public static final String DEV_LOG_TAG = "Datadog";

    public SdkInternalLogger(@NotNull Function0<LogcatLogHandler> devLogHandlerFactory, @NotNull Function0<LogcatLogHandler> sdkLogHandlerFactory) {
        Intrinsics.checkNotNullParameter(devLogHandlerFactory, (String)"devLogHandlerFactory");
        Intrinsics.checkNotNullParameter(sdkLogHandlerFactory, (String)"sdkLogHandlerFactory");
        this.devLogger = (LogcatLogHandler)devLogHandlerFactory.invoke();
        this.sdkLogger = (LogcatLogHandler)sdkLogHandlerFactory.invoke();
    }

    public /* synthetic */ SdkInternalLogger(Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        this((Function0<LogcatLogHandler>)function0, (Function0<LogcatLogHandler>)function02);
    }

    @NotNull
    public final LogcatLogHandler getDevLogger$dd_sdk_android_release() {
        return this.devLogger;
    }

    @Nullable
    public final LogcatLogHandler getSdkLogger$dd_sdk_android_release() {
        return this.sdkLogger;
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull InternalLogger.Target target, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                this.logToUser(level, message, throwable);
                break;
            }
            case 2: {
                this.logToMaintainer(level, message, throwable);
                break;
            }
            case 3: {
                this.logToTelemetry(level, message, throwable);
            }
        }
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull List<? extends InternalLogger.Target> targets, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InternalLogger.Target it = (InternalLogger.Target)((Object)element$iv);
            boolean bl = false;
            this.log(level, it, message, throwable);
        }
    }

    private final void logToUser(InternalLogger.Level level, String message, Throwable error) {
        this.devLogger.log(this.toLogLevel(level), message, error);
    }

    private final void logToMaintainer(InternalLogger.Level level, String message, Throwable error) {
        LogcatLogHandler logcatLogHandler = this.sdkLogger;
        if (logcatLogHandler != null) {
            logcatLogHandler.log(this.toLogLevel(level), message, error);
        }
    }

    private final void logToTelemetry(InternalLogger.Level level, String message, Throwable error) {
        if (level == InternalLogger.Level.ERROR || level == InternalLogger.Level.WARN || error != null) {
            RuntimeUtilsKt.getTelemetry().error(message, error);
        } else {
            RuntimeUtilsKt.getTelemetry().debug(message);
        }
    }

    private final int toLogLevel(InternalLogger.Level $this$toLogLevel) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toLogLevel.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public SdkInternalLogger() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/v2/core/SdkInternalLogger$Companion;", "", "()V", "DEV_LOG_TAG", "", "SDK_LOG_TAG", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InternalLogger.Target.values().length];
            nArray[InternalLogger.Target.USER.ordinal()] = 1;
            nArray[InternalLogger.Target.MAINTAINER.ordinal()] = 2;
            nArray[InternalLogger.Target.TELEMETRY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InternalLogger.Level.values().length];
            nArray[InternalLogger.Level.VERBOSE.ordinal()] = 1;
            nArray[InternalLogger.Level.DEBUG.ordinal()] = 2;
            nArray[InternalLogger.Level.INFO.ordinal()] = 3;
            nArray[InternalLogger.Level.WARN.ordinal()] = 4;
            nArray[InternalLogger.Level.ERROR.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

