/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core;

import android.app.Application;
import android.content.Context;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.Credentials;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleCallback;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.time.NoOpTimeProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.error.internal.CrashReportsFeature;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.plugin.DatadogContext;
import com.datadog.android.plugin.DatadogPlugin;
import com.datadog.android.plugin.DatadogRumContext;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.tracing.internal.TracingFeature;
import com.datadog.android.v2.api.FeatureEventReceiver;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.FeatureStorageConfiguration;
import com.datadog.android.v2.api.FeatureUploadConfiguration;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.RequestFactory;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.TimeInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.log.internal.net.LogsRequestFactory;
import com.datadog.android.v2.rum.internal.net.RumRequestFactory;
import com.datadog.android.v2.tracing.internal.net.TracesRequestFactory;
import com.datadog.android.webview.internal.log.WebViewLogsFeature;
import com.datadog.android.webview.internal.rum.WebViewRumFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u008a\u00012\u00020\u0001:\u0002\u008a\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010L\u001a\u00020M2\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010P0OH\u0016J\u001c\u0010Q\u001a\u00020M2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020P0OH\u0002J\b\u0010S\u001a\u00020MH\u0016J\b\u0010T\u001a\u00020MH\u0016J\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VJ\u0012\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010Y\u001a\u00020\tH\u0016J\u001e\u0010Z\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010P0O2\u0006\u0010Y\u001a\u00020\tH\u0016J\b\u0010[\u001a\u00020%H\u0016J(\u0010\\\u001a\u00020M2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010]\u001a\u00020^H\u0002J\u001a\u0010_\u001a\u00020M2\b\u0010\u0006\u001a\u0004\u0018\u00010`2\u0006\u0010a\u001a\u00020\u0003H\u0002J\u001a\u0010b\u001a\u00020M2\b\u0010\u0006\u001a\u0004\u0018\u00010c2\u0006\u0010a\u001a\u00020\u0003H\u0002J\u001a\u0010d\u001a\u00020M2\b\u0010\u0006\u001a\u0004\u0018\u00010e2\u0006\u0010a\u001a\u00020\u0003H\u0002J\u001a\u0010f\u001a\u00020M2\b\u0010\u0006\u001a\u0004\u0018\u00010g2\u0006\u0010a\u001a\u00020\u0003H\u0002J\u0010\u0010h\u001a\u00020^2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010i\u001a\u00020^2\u0006\u0010j\u001a\u00020\tH\u0002J\u0010\u0010k\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010l\u001a\u00020M2\u0006\u0010Y\u001a\u00020\t2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pH\u0016J\u0018\u0010l\u001a\u00020M2\u0006\u0010Y\u001a\u00020\t2\u0006\u0010q\u001a\u00020rH\u0002J\u0010\u0010s\u001a\u00020M2\u0006\u0010Y\u001a\u00020\tH\u0016J\u0010\u0010t\u001a\u00020M2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010u\u001a\u00020M2\u0006\u0010Y\u001a\u00020\t2\u0006\u0010v\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020M2\u0006\u0010y\u001a\u00020zH\u0016J\u0010\u0010{\u001a\u00020M2\u0006\u0010|\u001a\u00020}H\u0016J\u0010\u0010~\u001a\u00020M2\u0006\u0010\u007f\u001a\u00020%H\u0016J\u0011\u0010\u0080\u0001\u001a\u00020M2\u0006\u0010a\u001a\u00020\u0003H\u0002J\t\u0010\u0081\u0001\u001a\u00020MH\u0002J\t\u0010\u0082\u0001\u001a\u00020MH\u0016J \u0010\u0083\u0001\u001a\u00020M2\u0015\u0010\u0084\u0001\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010P0OH\u0002JF\u0010\u0085\u0001\u001a\u00020M2\u0006\u0010Y\u001a\u00020\t23\u0010\u0086\u0001\u001a.\u0012#\u0012!\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010P0\u001e\u00a2\u0006\u000e\b\u0088\u0001\u0012\t\b\u0089\u0001\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020M0\u0087\u0001H\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001c\u0010F\u001a\u0004\u0018\u00010GX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010K\u00a8\u0006\u008b\u0001"}, d2={"Lcom/datadog/android/v2/core/DatadogCore;", "Lcom/datadog/android/v2/api/SdkCore;", "context", "Landroid/content/Context;", "credentials", "Lcom/datadog/android/core/configuration/Credentials;", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "instanceId", "", "(Landroid/content/Context;Lcom/datadog/android/core/configuration/Credentials;Lcom/datadog/android/core/configuration/Configuration;Ljava/lang/String;)V", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "getContextProvider$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/ContextProvider;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "getCoreFeature$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/CoreFeature;", "setCoreFeature$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/CoreFeature;)V", "crashReportsFeature", "Lcom/datadog/android/error/internal/CrashReportsFeature;", "getCrashReportsFeature$dd_sdk_android_release", "()Lcom/datadog/android/error/internal/CrashReportsFeature;", "setCrashReportsFeature$dd_sdk_android_release", "(Lcom/datadog/android/error/internal/CrashReportsFeature;)V", "getCredentials$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/Credentials;", "features", "", "Lcom/datadog/android/core/internal/SdkFeature;", "getFeatures$dd_sdk_android_release", "()Ljava/util/Map;", "getInstanceId$dd_sdk_android_release", "()Ljava/lang/String;", "libraryVerbosity", "", "getLibraryVerbosity$dd_sdk_android_release", "()I", "setLibraryVerbosity$dd_sdk_android_release", "(I)V", "logsFeature", "Lcom/datadog/android/log/internal/LogsFeature;", "getLogsFeature$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/LogsFeature;", "setLogsFeature$dd_sdk_android_release", "(Lcom/datadog/android/log/internal/LogsFeature;)V", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "getRumFeature$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/RumFeature;", "setRumFeature$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/RumFeature;)V", "time", "Lcom/datadog/android/v2/api/context/TimeInfo;", "getTime", "()Lcom/datadog/android/v2/api/context/TimeInfo;", "tracingFeature", "Lcom/datadog/android/tracing/internal/TracingFeature;", "getTracingFeature$dd_sdk_android_release", "()Lcom/datadog/android/tracing/internal/TracingFeature;", "setTracingFeature$dd_sdk_android_release", "(Lcom/datadog/android/tracing/internal/TracingFeature;)V", "webViewLogsFeature", "Lcom/datadog/android/webview/internal/log/WebViewLogsFeature;", "getWebViewLogsFeature$dd_sdk_android_release", "()Lcom/datadog/android/webview/internal/log/WebViewLogsFeature;", "setWebViewLogsFeature$dd_sdk_android_release", "(Lcom/datadog/android/webview/internal/log/WebViewLogsFeature;)V", "webViewRumFeature", "Lcom/datadog/android/webview/internal/rum/WebViewRumFeature;", "getWebViewRumFeature$dd_sdk_android_release", "()Lcom/datadog/android/webview/internal/rum/WebViewRumFeature;", "setWebViewRumFeature$dd_sdk_android_release", "(Lcom/datadog/android/webview/internal/rum/WebViewRumFeature;)V", "addUserProperties", "", "extraInfo", "", "", "applyAdditionalConfiguration", "additionalConfiguration", "clearAllData", "flushStoredData", "getAllFeatures", "", "Lcom/datadog/android/v2/api/FeatureScope;", "getFeature", "featureName", "getFeatureContext", "getVerbosity", "initialize", "isDebug", "", "initializeCrashReportFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "appContext", "initializeLogsFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "initializeRumFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "initializeTracingFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "isAppDebuggable", "isEnvironmentNameValid", "envName", "modifyConfigurationForDeveloperDebug", "registerFeature", "storageConfiguration", "Lcom/datadog/android/v2/api/FeatureStorageConfiguration;", "uploadConfiguration", "Lcom/datadog/android/v2/api/FeatureUploadConfiguration;", "requestFactory", "Lcom/datadog/android/v2/api/RequestFactory;", "removeEventReceiver", "sendConfigurationTelemetryEvent", "setEventReceiver", "receiver", "Lcom/datadog/android/v2/api/FeatureEventReceiver;", "setTrackingConsent", "consent", "Lcom/datadog/android/privacy/TrackingConsent;", "setUserInfo", "userInfo", "Lcom/datadog/android/v2/api/context/UserInfo;", "setVerbosity", "level", "setupLifecycleMonitorCallback", "setupShutdownHook", "stop", "updateContextInPlugins", "rumContext", "updateFeatureContext", "updateCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Companion", "dd-sdk-android_release"})
public final class DatadogCore
implements SdkCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Credentials credentials;
    @NotNull
    private final String instanceId;
    private int libraryVerbosity;
    public CoreFeature coreFeature;
    @NotNull
    private final Map<String, SdkFeature> features;
    @Nullable
    private LogsFeature logsFeature;
    @Nullable
    private TracingFeature tracingFeature;
    @Nullable
    private RumFeature rumFeature;
    @Nullable
    private CrashReportsFeature crashReportsFeature;
    @Nullable
    private WebViewLogsFeature webViewLogsFeature;
    @Nullable
    private WebViewRumFeature webViewRumFeature;
    @NotNull
    public static final String SHUTDOWN_THREAD_NAME = "datadog_shutdown";
    @NotNull
    public static final String ENV_NAME_VALIDATION_REG_EX = "[a-zA-Z0-9_:./-]{0,195}[a-zA-Z0-9_./-]";
    @NotNull
    public static final String MESSAGE_ENV_NAME_NOT_VALID = "The environment name should contain maximum 196 of the following allowed characters [a-zA-Z0-9_:./-] and should never finish with a semicolon.In this case the Datadog SDK will not be initialised.";
    @NotNull
    public static final String WARNING_MESSAGE_APPLICATION_ID_IS_NULL = "You're trying to enable RUM but no Application Id was provided. Please pass this value into the Datadog Credentials:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);";
    @NotNull
    public static final String MISSING_FEATURE_FOR_EVENT_RECEIVER = "Cannot add event receiver for feature \"%s\", it is not registered.";
    @NotNull
    public static final String EVENT_RECEIVER_ALREADY_EXISTS = "Feature \"%s\" already has event receiver registered, overwriting it.";
    private static final long CONFIGURATION_TELEMETRY_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);

    public DatadogCore(@NotNull Context context, @NotNull Credentials credentials, @NotNull Configuration configuration, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        this.credentials = credentials;
        this.instanceId = instanceId;
        this.libraryVerbosity = Integer.MAX_VALUE;
        this.features = new LinkedHashMap();
        boolean isDebug = this.isAppDebuggable(context);
        if (!this.isEnvironmentNameValid(this.credentials.getEnvName())) {
            throw new IllegalArgumentException(MESSAGE_ENV_NAME_NOT_VALID);
        }
        this.initialize(context, this.credentials, configuration, isDebug);
    }

    @NotNull
    public final Credentials getCredentials$dd_sdk_android_release() {
        return this.credentials;
    }

    @NotNull
    public final String getInstanceId$dd_sdk_android_release() {
        return this.instanceId;
    }

    public final int getLibraryVerbosity$dd_sdk_android_release() {
        return this.libraryVerbosity;
    }

    public final void setLibraryVerbosity$dd_sdk_android_release(int n) {
        this.libraryVerbosity = n;
    }

    @NotNull
    public final CoreFeature getCoreFeature$dd_sdk_android_release() {
        CoreFeature coreFeature = this.coreFeature;
        if (coreFeature != null) {
            return coreFeature;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"coreFeature");
        return null;
    }

    public final void setCoreFeature$dd_sdk_android_release(@NotNull CoreFeature coreFeature) {
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"<set-?>");
        this.coreFeature = coreFeature;
    }

    @NotNull
    public final Map<String, SdkFeature> getFeatures$dd_sdk_android_release() {
        return this.features;
    }

    @Nullable
    public final LogsFeature getLogsFeature$dd_sdk_android_release() {
        return this.logsFeature;
    }

    public final void setLogsFeature$dd_sdk_android_release(@Nullable LogsFeature logsFeature) {
        this.logsFeature = logsFeature;
    }

    @Nullable
    public final TracingFeature getTracingFeature$dd_sdk_android_release() {
        return this.tracingFeature;
    }

    public final void setTracingFeature$dd_sdk_android_release(@Nullable TracingFeature tracingFeature) {
        this.tracingFeature = tracingFeature;
    }

    @Nullable
    public final RumFeature getRumFeature$dd_sdk_android_release() {
        return this.rumFeature;
    }

    public final void setRumFeature$dd_sdk_android_release(@Nullable RumFeature rumFeature) {
        this.rumFeature = rumFeature;
    }

    @Nullable
    public final CrashReportsFeature getCrashReportsFeature$dd_sdk_android_release() {
        return this.crashReportsFeature;
    }

    public final void setCrashReportsFeature$dd_sdk_android_release(@Nullable CrashReportsFeature crashReportsFeature) {
        this.crashReportsFeature = crashReportsFeature;
    }

    @Nullable
    public final WebViewLogsFeature getWebViewLogsFeature$dd_sdk_android_release() {
        return this.webViewLogsFeature;
    }

    public final void setWebViewLogsFeature$dd_sdk_android_release(@Nullable WebViewLogsFeature webViewLogsFeature) {
        this.webViewLogsFeature = webViewLogsFeature;
    }

    @Nullable
    public final WebViewRumFeature getWebViewRumFeature$dd_sdk_android_release() {
        return this.webViewRumFeature;
    }

    public final void setWebViewRumFeature$dd_sdk_android_release(@Nullable WebViewRumFeature webViewRumFeature) {
        this.webViewRumFeature = webViewRumFeature;
    }

    @Nullable
    public final ContextProvider getContextProvider$dd_sdk_android_release() {
        return this.getCoreFeature$dd_sdk_android_release().getInitialized$dd_sdk_android_release().get() ? this.getCoreFeature$dd_sdk_android_release().getContextProvider$dd_sdk_android_release() : (ContextProvider)null;
    }

    @Override
    @NotNull
    public TimeInfo getTime() {
        TimeProvider $this$_get_time__u24lambda_u2d0 = this.getCoreFeature$dd_sdk_android_release().getTimeProvider$dd_sdk_android_release();
        boolean bl = false;
        long deviceTimeMs = $this$_get_time__u24lambda_u2d0 instanceof NoOpTimeProvider ? System.currentTimeMillis() : $this$_get_time__u24lambda_u2d0.getDeviceTimestamp();
        long serverTimeMs = $this$_get_time__u24lambda_u2d0 instanceof NoOpTimeProvider ? deviceTimeMs : $this$_get_time__u24lambda_u2d0.getServerTimestamp();
        return new TimeInfo(TimeUnit.MILLISECONDS.toNanos(deviceTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs), TimeUnit.MILLISECONDS.toNanos(serverTimeMs - deviceTimeMs), serverTimeMs - deviceTimeMs);
    }

    @Override
    public void registerFeature(@NotNull String featureName, @NotNull FeatureStorageConfiguration storageConfiguration, @NotNull FeatureUploadConfiguration uploadConfiguration) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)storageConfiguration, (String)"storageConfiguration");
        Intrinsics.checkNotNullParameter((Object)uploadConfiguration, (String)"uploadConfiguration");
        SdkFeature feature = new SdkFeature(this.getCoreFeature$dd_sdk_android_release(), featureName, storageConfiguration, uploadConfiguration);
        this.features.put(featureName, feature);
    }

    @Override
    @Nullable
    public FeatureScope getFeature(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        return this.features.get(featureName);
    }

    @Override
    public void setVerbosity(int level) {
        this.libraryVerbosity = level;
    }

    @Override
    public int getVerbosity() {
        return this.libraryVerbosity;
    }

    @Override
    public void setTrackingConsent(@NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        this.getCoreFeature$dd_sdk_android_release().getTrackingConsentProvider$dd_sdk_android_release().setConsent(consent);
    }

    @Override
    public void setUserInfo(@NotNull UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        this.getCoreFeature$dd_sdk_android_release().getUserInfoProvider$dd_sdk_android_release().setUserInfo(userInfo);
    }

    @Override
    public void addUserProperties(@NotNull Map<String, ? extends Object> extraInfo) {
        Intrinsics.checkNotNullParameter(extraInfo, (String)"extraInfo");
        this.getCoreFeature$dd_sdk_android_release().getUserInfoProvider$dd_sdk_android_release().addUserProperties(extraInfo);
    }

    @Override
    public void clearAllData() {
        Iterable $this$forEach$iv = this.features.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFeature it = (SdkFeature)element$iv;
            boolean bl = false;
            it.clearAllData();
        }
    }

    @Override
    public void stop() {
        LogsFeature logsFeature = this.logsFeature;
        if (logsFeature != null) {
            logsFeature.stop$dd_sdk_android_release();
        }
        this.logsFeature = null;
        TracingFeature tracingFeature = this.tracingFeature;
        if (tracingFeature != null) {
            tracingFeature.stop();
        }
        this.tracingFeature = null;
        RumFeature rumFeature = this.rumFeature;
        if (rumFeature != null) {
            rumFeature.stop();
        }
        this.rumFeature = null;
        CrashReportsFeature crashReportsFeature = this.crashReportsFeature;
        if (crashReportsFeature != null) {
            crashReportsFeature.stop();
        }
        this.crashReportsFeature = null;
        WebViewLogsFeature webViewLogsFeature = this.webViewLogsFeature;
        if (webViewLogsFeature != null) {
            webViewLogsFeature.stop();
        }
        this.webViewLogsFeature = null;
        WebViewRumFeature webViewRumFeature = this.webViewRumFeature;
        if (webViewRumFeature != null) {
            webViewRumFeature.stop();
        }
        this.webViewRumFeature = null;
        this.features.clear();
        this.getCoreFeature$dd_sdk_android_release().stop();
    }

    @Override
    public void flushStoredData() {
        this.getCoreFeature$dd_sdk_android_release().drainAndShutdownExecutors();
        Iterable $this$forEach$iv = this.features.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFeature it = (SdkFeature)element$iv;
            boolean bl = false;
            it.flushStoredData$dd_sdk_android_release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFeatureContext(@NotNull String featureName, @NotNull Function1<? super Map<String, Object>, Unit> updateCallback) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(updateCallback, (String)"updateCallback");
        SdkFeature sdkFeature = this.features.get(featureName);
        if (sdkFeature == null) {
            return;
        }
        SdkFeature feature = sdkFeature;
        ContextProvider contextProvider = this.getContextProvider$dd_sdk_android_release();
        if (contextProvider != null) {
            Map map;
            ContextProvider it = contextProvider;
            boolean bl = false;
            synchronized (feature) {
                boolean bl2 = false;
                Map<String, Object> featureContext = it.getFeatureContext(featureName);
                Map mutableContext = MapsKt.toMutableMap(featureContext);
                updateCallback.invoke((Object)mutableContext);
                it.setFeatureContext(featureName, mutableContext);
                map = mutableContext;
            }
            Map updatedContext = map;
            if (Intrinsics.areEqual((Object)featureName, (Object)"rum")) {
                this.updateContextInPlugins(updatedContext);
            }
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getFeatureContext(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        ContextProvider contextProvider = this.getContextProvider$dd_sdk_android_release();
        Map map = contextProvider == null ? null : contextProvider.getFeatureContext(featureName);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    public void setEventReceiver(@NotNull String featureName, @NotNull FeatureEventReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        SdkFeature feature = this.features.get(featureName);
        if (feature == null) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = MISSING_FEATURE_FOR_EVENT_RECEIVER;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{featureName};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, string2, null, 8, null);
        } else {
            if (feature.getEventReceiver$dd_sdk_android_release().get() != null) {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                String string = EVENT_RECEIVER_ALREADY_EXISTS;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{featureName};
                String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, string3, null, 8, null);
            }
            feature.getEventReceiver$dd_sdk_android_release().set(receiver);
        }
    }

    @Override
    public void removeEventReceiver(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        SdkFeature sdkFeature = this.features.get(featureName);
        if (sdkFeature != null) {
            AtomicReference<FeatureEventReceiver> atomicReference = sdkFeature.getEventReceiver$dd_sdk_android_release();
            if (atomicReference != null) {
                atomicReference.set(null);
            }
        }
    }

    @NotNull
    public final List<FeatureScope> getAllFeatures() {
        return CollectionsKt.toList((Iterable)this.features.values());
    }

    private final void initialize(Context context, Credentials credentials, Configuration configuration, boolean isDebug) {
        Context appContext = context.getApplicationContext();
        Configuration mutableConfig = null;
        mutableConfig = configuration;
        if (isDebug & configuration.getCoreConfig$dd_sdk_android_release().getEnableDeveloperModeWhenDebuggable()) {
            mutableConfig = this.modifyConfigurationForDeveloperDebug(configuration);
            this.setVerbosity(2);
        }
        Object object = mutableConfig.getAdditionalConfig$dd_sdk_android_release().get("_dd.telemetry.configuration_sample_rate");
        if (object != null) {
            Object it = object;
            boolean bl = false;
            if (it instanceof Number && mutableConfig.getRumConfig$dd_sdk_android_release() != null) {
                Configuration.Feature.RUM rUM = mutableConfig.getRumConfig$dd_sdk_android_release();
                mutableConfig = Configuration.copy$default(mutableConfig, null, null, null, null, rUM == null ? null : Configuration.Feature.RUM.copy$default(rUM, null, null, 0.0f, 0.0f, ((Number)it).floatValue(), null, null, null, null, false, false, null, 4079, null), null, 47, null);
            }
        }
        this.setCoreFeature$dd_sdk_android_release(new CoreFeature());
        CoreFeature coreFeature = this.getCoreFeature$dd_sdk_android_release();
        Intrinsics.checkNotNullExpressionValue((Object)appContext, (String)"appContext");
        coreFeature.initialize(appContext, this.instanceId, credentials, mutableConfig.getCoreConfig$dd_sdk_android_release(), TrackingConsent.PENDING);
        this.applyAdditionalConfiguration(mutableConfig.getAdditionalConfig$dd_sdk_android_release());
        this.initializeLogsFeature(mutableConfig.getLogsConfig$dd_sdk_android_release(), appContext);
        this.initializeTracingFeature(mutableConfig.getTracesConfig$dd_sdk_android_release(), appContext);
        this.initializeRumFeature(mutableConfig.getRumConfig$dd_sdk_android_release(), appContext);
        this.initializeCrashReportFeature(mutableConfig.getCrashReportConfig$dd_sdk_android_release(), appContext);
        this.getCoreFeature$dd_sdk_android_release().getNdkCrashHandler$dd_sdk_android_release().handleNdkCrash(this);
        this.setupLifecycleMonitorCallback(appContext);
        this.setupShutdownHook();
        this.sendConfigurationTelemetryEvent(configuration);
    }

    private final void initializeLogsFeature(Configuration.Feature.Logs configuration, Context appContext) {
        if (configuration != null) {
            Object it;
            DatadogCore datadogCore;
            Object object;
            SdkFeature it2;
            this.registerFeature("logs", new LogsRequestFactory(configuration.getEndpointUrl()));
            this.registerFeature("web-logs", new LogsRequestFactory(configuration.getEndpointUrl()));
            SdkFeature sdkFeature = this.features.get("logs");
            if (sdkFeature != null) {
                it2 = sdkFeature;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                object = new LogsFeature(this);
                LogsFeature logsFeature = object;
                datadogCore = this;
                boolean bl2 = false;
                ((LogsFeature)it).initialize$dd_sdk_android_release(configuration);
                datadogCore.setLogsFeature$dd_sdk_android_release((LogsFeature)object);
            }
            SdkFeature sdkFeature2 = this.features.get("web-logs");
            if (sdkFeature2 != null) {
                it2 = sdkFeature2;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                it = object = new WebViewLogsFeature();
                datadogCore = this;
                boolean bl3 = false;
                ((WebViewLogsFeature)it).initialize();
                datadogCore.setWebViewLogsFeature$dd_sdk_android_release((WebViewLogsFeature)object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeCrashReportFeature(Configuration.Feature.CrashReport configuration, Context appContext) {
        if (configuration != null) {
            this.registerFeature("crash", new LogsRequestFactory(configuration.getEndpointUrl()));
            SdkFeature sdkFeature = this.features.get("crash");
            if (sdkFeature != null) {
                void it;
                CrashReportsFeature crashReportsFeature;
                SdkFeature it2 = sdkFeature;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                CrashReportsFeature crashReportsFeature2 = crashReportsFeature = new CrashReportsFeature(this);
                DatadogCore datadogCore = this;
                boolean bl2 = false;
                it.initialize(appContext);
                datadogCore.setCrashReportsFeature$dd_sdk_android_release(crashReportsFeature);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeTracingFeature(Configuration.Feature.Tracing configuration, Context appContext) {
        if (configuration != null) {
            this.registerFeature("tracing", new TracesRequestFactory(configuration.getEndpointUrl()));
            SdkFeature sdkFeature = this.features.get("tracing");
            if (sdkFeature != null) {
                void it;
                TracingFeature tracingFeature;
                SdkFeature it2 = sdkFeature;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                TracingFeature tracingFeature2 = tracingFeature = new TracingFeature(this);
                DatadogCore datadogCore = this;
                boolean bl2 = false;
                it.initialize(configuration);
                datadogCore.setTracingFeature$dd_sdk_android_release(tracingFeature);
            }
        }
    }

    private final void initializeRumFeature(Configuration.Feature.RUM configuration, Context appContext) {
        if (configuration != null) {
            Object it;
            DatadogCore datadogCore;
            Object object;
            SdkFeature it2;
            CharSequence charSequence = this.getCoreFeature$dd_sdk_android_release().getRumApplicationId$dd_sdk_android_release();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, WARNING_MESSAGE_APPLICATION_ID_IS_NULL, null, 8, null);
            }
            this.registerFeature("rum", new RumRequestFactory(configuration.getEndpointUrl()));
            this.registerFeature("web-rum", new RumRequestFactory(configuration.getEndpointUrl()));
            SdkFeature sdkFeature = this.features.get("rum");
            if (sdkFeature != null) {
                it2 = sdkFeature;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                object = new RumFeature(this, this.getCoreFeature$dd_sdk_android_release(), null, 4, null);
                RumFeature rumFeature = object;
                datadogCore = this;
                boolean bl2 = false;
                ((RumFeature)it).initialize(appContext, configuration);
                datadogCore.setRumFeature$dd_sdk_android_release((RumFeature)object);
            }
            SdkFeature sdkFeature2 = this.features.get("web-rum");
            if (sdkFeature2 != null) {
                it2 = sdkFeature2;
                boolean bl = false;
                it2.initialize(appContext, configuration.getPlugins());
                it = object = new WebViewRumFeature(this.getCoreFeature$dd_sdk_android_release());
                datadogCore = this;
                boolean bl3 = false;
                ((WebViewRumFeature)it).initialize();
                datadogCore.setWebViewRumFeature$dd_sdk_android_release((WebViewRumFeature)object);
            }
        }
    }

    private final void registerFeature(String featureName, RequestFactory requestFactory) {
        FilePersistenceConfig filePersistenceConfig = this.getCoreFeature$dd_sdk_android_release().buildFilePersistenceConfig();
        this.registerFeature(featureName, new FeatureStorageConfiguration(filePersistenceConfig.getMaxItemSize(), filePersistenceConfig.getMaxItemsPerBatch(), filePersistenceConfig.getMaxBatchSize(), filePersistenceConfig.getOldFileThreshold()), new FeatureUploadConfiguration(requestFactory));
    }

    private final Configuration modifyConfigurationForDeveloperDebug(Configuration configuration) {
        Configuration.Feature.RUM rUM = configuration.getRumConfig$dd_sdk_android_release();
        return Configuration.copy$default(configuration, Configuration.Core.copy$default(configuration.getCoreConfig$dd_sdk_android_release(), false, false, null, BatchSize.SMALL, UploadFrequency.FREQUENT, null, null, null, null, null, 999, null), null, null, null, rUM == null ? null : Configuration.Feature.RUM.copy$default(rUM, null, null, 100.0f, 0.0f, 0.0f, null, null, null, null, false, false, null, 4091, null), null, 46, null);
    }

    private final void applyAdditionalConfiguration(Map<String, ? extends Object> additionalConfiguration) {
        Object it;
        Object object = additionalConfiguration.get("_dd.source");
        if (object != null) {
            it = object;
            boolean bl = false;
            if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                this.getCoreFeature$dd_sdk_android_release().setSourceName$dd_sdk_android_release((String)it);
            }
        }
        Object object2 = additionalConfiguration.get("_dd.sdk_version");
        if (object2 != null) {
            it = object2;
            boolean bl = false;
            if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                this.getCoreFeature$dd_sdk_android_release().setSdkVersion$dd_sdk_android_release((String)it);
            }
        }
        Object object3 = additionalConfiguration.get("_dd.version");
        if (object3 != null) {
            it = object3;
            boolean bl = false;
            if (it instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                this.getCoreFeature$dd_sdk_android_release().getPackageVersionProvider$dd_sdk_android_release().setVersion((String)it);
            }
        }
    }

    private final void setupLifecycleMonitorCallback(Context appContext) {
        if (appContext instanceof Application) {
            ProcessLifecycleCallback callback = new ProcessLifecycleCallback(this.getCoreFeature$dd_sdk_android_release().getNetworkInfoProvider$dd_sdk_android_release(), appContext);
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ProcessLifecycleMonitor(callback));
        }
    }

    private final boolean isEnvironmentNameValid(String envName) {
        CharSequence charSequence = envName;
        return new Regex(ENV_NAME_VALIDATION_REG_EX).matches(charSequence);
    }

    private final boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    private final void setupShutdownHook() {
        try {
            Runnable hookRunnable = () -> DatadogCore.setupShutdownHook$lambda-21(this);
            Thread hook = new Thread(hookRunnable, SHUTDOWN_THREAD_NAME);
            Runtime.getRuntime().addShutdownHook(hook);
        }
        catch (IllegalStateException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unable to add shutdown hook, Runtime is already shutting down", (Throwable)e);
            this.stop();
        }
        catch (IllegalArgumentException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Shutdown hook was rejected", (Throwable)e);
        }
        catch (SecurityException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Security Manager denied adding shutdown hook ", (Throwable)e);
        }
    }

    private final void sendConfigurationTelemetryEvent(Configuration configuration) {
        Runnable runnable = () -> DatadogCore.sendConfigurationTelemetryEvent$lambda-22(configuration);
        ConcurrencyExtKt.scheduleSafe(this.getCoreFeature$dd_sdk_android_release().getUploadExecutorService$dd_sdk_android_release(), "Configuration telemetry", CONFIGURATION_TELEMETRY_DELAY_MS, TimeUnit.MILLISECONDS, runnable);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateContextInPlugins(Map<String, ? extends Object> rumContext) {
        void $this$flatMapTo$iv$iv;
        Object object = rumContext.get("application_id");
        String applicationId = object instanceof String ? (String)object : null;
        Object object2 = rumContext.get("session_id");
        String sessionId = object2 instanceof String ? (String)object2 : null;
        Object object3 = rumContext.get("view_id");
        String viewId = object3 instanceof String ? (String)object3 : null;
        DatadogContext pluginContext = new DatadogContext(new DatadogRumContext(applicationId, sessionId, viewId));
        Iterable $this$flatMap$iv = this.features.values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SdkFeature it = (SdkFeature)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getPlugins();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            it.onContextChanged(pluginContext);
        }
    }

    private static final void setupShutdownHook$lambda-21(DatadogCore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.stop();
    }

    private static final void sendConfigurationTelemetryEvent$lambda-22(Configuration $configuration) {
        AdvancedRumMonitor monitor;
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = monitor = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.sendConfigurationTelemetryEvent($configuration);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/v2/core/DatadogCore$Companion;", "", "()V", "CONFIGURATION_TELEMETRY_DELAY_MS", "", "getCONFIGURATION_TELEMETRY_DELAY_MS$dd_sdk_android_release", "()J", "ENV_NAME_VALIDATION_REG_EX", "", "EVENT_RECEIVER_ALREADY_EXISTS", "MESSAGE_ENV_NAME_NOT_VALID", "MISSING_FEATURE_FOR_EVENT_RECEIVER", "SHUTDOWN_THREAD_NAME", "WARNING_MESSAGE_APPLICATION_ID_IS_NULL", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCONFIGURATION_TELEMETRY_DELAY_MS$dd_sdk_android_release() {
            return CONFIGURATION_TELEMETRY_DELAY_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

