/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.data;

import androidx.annotation.WorkerThread;
import com.datadog.android.event.EventMapper;
import com.datadog.android.tracing.model.SpanEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.ContextAwareMapper;
import com.datadog.android.v2.core.internal.storage.ContextAwareSerializer;
import com.datadog.opentracing.DDSpan;
import com.datadog.trace.common.writer.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0017H\u0016J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0003R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/tracing/internal/data/TraceWriter;", "Lcom/datadog/trace/common/writer/Writer;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "legacyMapper", "Lcom/datadog/android/v2/core/internal/storage/ContextAwareMapper;", "Lcom/datadog/opentracing/DDSpan;", "Lcom/datadog/android/tracing/model/SpanEvent;", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "serializer", "Lcom/datadog/android/v2/core/internal/storage/ContextAwareSerializer;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/v2/core/internal/storage/ContextAwareMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/v2/core/internal/storage/ContextAwareSerializer;Lcom/datadog/android/v2/api/InternalLogger;)V", "getEventMapper$dd_sdk_android_release", "()Lcom/datadog/android/event/EventMapper;", "close", "", "incrementTraceCount", "start", "write", "trace", "", "writeSpan", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "writer", "Lcom/datadog/android/v2/api/EventBatchWriter;", "span", "Companion", "dd-sdk-android_release"})
public final class TraceWriter
implements Writer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final ContextAwareMapper<DDSpan, SpanEvent> legacyMapper;
    @NotNull
    private final EventMapper<SpanEvent> eventMapper;
    @NotNull
    private final ContextAwareSerializer<SpanEvent> serializer;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String ERROR_SERIALIZING = "Error serializing %s model";

    public TraceWriter(@NotNull SdkCore sdkCore, @NotNull ContextAwareMapper<DDSpan, SpanEvent> legacyMapper, @NotNull EventMapper<SpanEvent> eventMapper, @NotNull ContextAwareSerializer<SpanEvent> serializer, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(legacyMapper, (String)"legacyMapper");
        Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.sdkCore = sdkCore;
        this.legacyMapper = legacyMapper;
        this.eventMapper = eventMapper;
        this.serializer = serializer;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final EventMapper<SpanEvent> getEventMapper$dd_sdk_android_release() {
        return this.eventMapper;
    }

    @Override
    public void start() {
    }

    @Override
    public void write(@Nullable List<DDSpan> trace) {
        if (trace == null) {
            return;
        }
        FeatureScope featureScope = this.sdkCore.getFeature("tracing");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(trace, this){
                final /* synthetic */ List<DDSpan> $trace;
                final /* synthetic */ TraceWriter this$0;
                {
                    this.$trace = $trace;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    Iterable iterable = this.$trace;
                    TraceWriter traceWriter = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DDSpan span = (DDSpan)element$iv;
                        boolean bl = false;
                        TraceWriter.access$writeSpan(traceWriter, datadogContext, eventBatchWriter, span);
                    }
                }
            }, 1, null);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void incrementTraceCount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void writeSpan(DatadogContext datadogContext, EventBatchWriter writer, DDSpan span) {
        SpanEvent spanEvent = this.legacyMapper.map(datadogContext, span);
        SpanEvent spanEvent2 = this.eventMapper.map(spanEvent);
        if (spanEvent2 == null) {
            return;
        }
        SpanEvent mapped = spanEvent2;
        try {
            byte[] byArray;
            byte[] byArray2;
            String string = this.serializer.serialize(datadogContext, mapped);
            if (string == null) {
                byArray2 = null;
            } else {
                byte[] byArray3 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                byArray2 = byArray = byArray3;
            }
            if (byArray == null) {
                return;
            }
            byte[] serialized = byArray;
            synchronized (this) {
                boolean bl = false;
                boolean bl2 = writer.write(serialized, null);
            }
        }
        catch (Throwable e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_SERIALIZING;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{mapped.getClass().getSimpleName()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, e);
        }
    }

    public static final /* synthetic */ void access$writeSpan(TraceWriter $this, DatadogContext datadogContext, EventBatchWriter writer, DDSpan span) {
        $this.writeSpan(datadogContext, writer, span);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/tracing/internal/data/TraceWriter$Companion;", "", "()V", "ERROR_SERIALIZING", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

