/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.storage;

import com.datadog.android.sessionreplay.RecordWriter;
import com.datadog.android.sessionreplay.processor.EnrichedRecord;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/sessionreplay/internal/storage/SessionReplayRecordWriter;", "Lcom/datadog/android/sessionreplay/RecordWriter;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "(Lcom/datadog/android/v2/api/SdkCore;)V", "lastRumContextId", "", "resoleRumContextId", "record", "Lcom/datadog/android/sessionreplay/processor/EnrichedRecord;", "resolveForceNewBatch", "", "write", "", "dd-sdk-android_release"})
public final class SessionReplayRecordWriter
implements RecordWriter {
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private String lastRumContextId;

    public SessionReplayRecordWriter(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
        this.lastRumContextId = "";
    }

    public void write(@NotNull EnrichedRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        boolean forceNewBatch = this.resolveForceNewBatch(record);
        FeatureScope featureScope = this.sdkCore.getFeature("session-replay");
        if (featureScope != null) {
            featureScope.withWriteContext(forceNewBatch, (Function2<? super DatadogContext, ? super EventBatchWriter, Unit>)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(record, this){
                final /* synthetic */ EnrichedRecord $record;
                final /* synthetic */ SessionReplayRecordWriter this$0;
                {
                    this.$record = $record;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull DatadogContext $noName_0, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    byte[] byArray = this.$record.toJson().getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    byte[] serializedRecord = byArray;
                    SessionReplayRecordWriter sessionReplayRecordWriter = this.this$0;
                    synchronized (sessionReplayRecordWriter) {
                        boolean bl = false;
                        eventBatchWriter.write(serializedRecord, null);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }));
        }
    }

    private final boolean resolveForceNewBatch(EnrichedRecord record) {
        String newRumContextId = this.resoleRumContextId(record);
        boolean forceNewBatch = !Intrinsics.areEqual((Object)this.lastRumContextId, (Object)newRumContextId);
        this.lastRumContextId = newRumContextId;
        return forceNewBatch;
    }

    private final String resoleRumContextId(EnrichedRecord record) {
        return record.getApplicationId() + "-" + record.getSessionId() + "-" + record.getViewId();
    }
}

