/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.tracking.TrackingStrategy;
import com.datadog.android.v2.api.InternalLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0004J \u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0004J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "()V", "convertToRumAttributes", "", "", "", "intent", "Landroid/content/Intent;", "bundle", "Landroid/os/Bundle;", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "register", "context", "Landroid/content/Context;", "unregister", "Companion", "dd-sdk-android_release"})
public abstract class ActivityLifecycleTrackingStrategy
implements Application.ActivityLifecycleCallbacks,
TrackingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ARGUMENT_TAG = "view.arguments";
    @NotNull
    public static final String INTENT_ACTION_TAG = "view.intent.action";
    @NotNull
    public static final String INTENT_URI_TAG = "view.intent.uri";

    @Override
    public void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "In order to use the RUM automatic tracking feature you will haveto use the Application context when initializing the SDK", null, 8, null);
        }
    }

    @Override
    public void unregister(@Nullable Context context) {
        if (context instanceof Application) {
            ((Application)context).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @NotNull
    protected final Map<String, Object> convertToRumAttributes(@Nullable Intent intent) {
        String string;
        Object object;
        String it;
        if (intent == null) {
            return MapsKt.emptyMap();
        }
        Map attributes = new LinkedHashMap();
        String string2 = intent.getAction();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            object = attributes;
            string = INTENT_ACTION_TAG;
            object.put(string, it);
        }
        String string3 = intent.getDataString();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            object = attributes;
            string = INTENT_URI_TAG;
            object.put(string, it);
        }
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            Bundle bundle2 = bundle;
            boolean bl = false;
            object = bundle2.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bundle.keySet()");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl2 = false;
                attributes.put("view.arguments." + it2, bundle2.get(it2));
            }
        }
        return attributes;
    }

    @NotNull
    protected final Map<String, Object> convertToRumAttributes(@Nullable Bundle bundle) {
        if (bundle == null) {
            return MapsKt.emptyMap();
        }
        Map attributes = new LinkedHashMap();
        Set set = bundle.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bundle.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            attributes.put("view.arguments." + it, bundle.get(it));
        }
        return attributes;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy$Companion;", "", "()V", "ARGUMENT_TAG", "", "INTENT_ACTION_TAG", "INTENT_URI_TAG", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

