/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/vitals/CPUVitalReader;", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "statFile", "Ljava/io/File;", "(Ljava/io/File;)V", "getStatFile$dd_sdk_android_release", "()Ljava/io/File;", "readVitalData", "", "()Ljava/lang/Double;", "Companion", "dd-sdk-android_release"})
public final class CPUVitalReader
implements VitalReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statFile;
    @NotNull
    private static final String STAT_PATH = "/proc/self/stat";
    @NotNull
    private static final File STAT_FILE = new File("/proc/self/stat");
    private static final int UTIME_IDX = 13;

    public CPUVitalReader(@NotNull File statFile) {
        Intrinsics.checkNotNullParameter((Object)statFile, (String)"statFile");
        this.statFile = statFile;
    }

    public /* synthetic */ CPUVitalReader(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = STAT_FILE;
        }
        this(file);
    }

    @NotNull
    public final File getStatFile$dd_sdk_android_release() {
        return this.statFile;
    }

    @Override
    @Nullable
    public Double readVitalData() {
        if (!FileExtKt.existsSafe(this.statFile) || !FileExtKt.canReadSafe(this.statFile)) {
            return null;
        }
        String string = FileExtKt.readTextSafe$default(this.statFile, null, 1, null);
        if (string == null) {
            return null;
        }
        String stat = string;
        char[] cArray = new char[]{' '};
        List tokens = StringsKt.split$default((CharSequence)stat, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return tokens.size() > 13 ? StringsKt.toDoubleOrNull((String)((String)tokens.get(13))) : (Double)null;
    }

    public CPUVitalReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/vitals/CPUVitalReader$Companion;", "", "()V", "STAT_FILE", "Ljava/io/File;", "getSTAT_FILE$dd_sdk_android_release", "()Ljava/io/File;", "STAT_PATH", "", "UTIME_IDX", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getSTAT_FILE$dd_sdk_android_release() {
            return STAT_FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

