/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "", "()V", "viewsTimeAndState", "Ljava/util/WeakHashMap;", "Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer$ViewLoadingInfo;", "getLoadingTime", "", "view", "(Ljava/lang/Object;)Ljava/lang/Long;", "isFirstTimeLoading", "", "onCreated", "", "onDestroyed", "onFinishedLoading", "onPaused", "onStartLoading", "ViewLoadingInfo", "dd-sdk-android_release"})
public final class ViewLoadingTimer {
    @NotNull
    private final WeakHashMap<Object, ViewLoadingInfo> viewsTimeAndState = new WeakHashMap();

    public final void onCreated(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Map map = this.viewsTimeAndState;
        ViewLoadingInfo viewLoadingInfo = new ViewLoadingInfo(System.nanoTime(), 0L, false, false, 14, null);
        map.put(view, viewLoadingInfo);
    }

    public final void onStartLoading(@NotNull Object view) {
        ViewLoadingInfo viewLoadingInfo;
        ViewLoadingInfo viewLoadingInfo2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.viewsTimeAndState.containsKey(view)) {
            viewLoadingInfo2 = this.viewsTimeAndState.get(view);
        } else {
            ViewLoadingInfo viewLoadingInfo3;
            ViewLoadingInfo it = viewLoadingInfo3 = new ViewLoadingInfo(System.nanoTime(), 0L, false, false, 14, null);
            boolean bl = false;
            ((Map)this.viewsTimeAndState).put(view, it);
            viewLoadingInfo2 = viewLoadingInfo3;
        }
        ViewLoadingInfo viewLoadingInfo4 = viewLoadingInfo = viewLoadingInfo2;
        if (viewLoadingInfo4 != null) {
            ViewLoadingInfo it = viewLoadingInfo4;
            boolean bl = false;
            if (it.getLoadingStart() == null) {
                it.setLoadingStart(System.nanoTime());
            }
        }
    }

    public final void onFinishedLoading(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewLoadingInfo viewLoadingInfo = this.viewsTimeAndState.get(view);
        if (viewLoadingInfo != null) {
            ViewLoadingInfo it = viewLoadingInfo;
            boolean bl = false;
            Long loadingStart = it.getLoadingStart();
            it.setLoadingTime(loadingStart != null ? System.nanoTime() - loadingStart : 0L);
            if (it.getFinishedLoadingOnce()) {
                it.setFirstTimeLoading(false);
            }
        }
    }

    public final void onDestroyed(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.viewsTimeAndState.remove(view);
    }

    public final void onPaused(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewLoadingInfo viewLoadingInfo = this.viewsTimeAndState.get(view);
        if (viewLoadingInfo != null) {
            ViewLoadingInfo it = viewLoadingInfo;
            boolean bl = false;
            it.setLoadingTime(0L);
            it.setLoadingStart(null);
            it.setFirstTimeLoading(false);
            it.setFinishedLoadingOnce(true);
        }
    }

    @Nullable
    public final Long getLoadingTime(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewLoadingInfo viewLoadingInfo = this.viewsTimeAndState.get(view);
        if (viewLoadingInfo != null) {
            ViewLoadingInfo it = viewLoadingInfo;
            boolean bl = false;
            return it.getLoadingTime();
        }
        return null;
    }

    public final boolean isFirstTimeLoading(@NotNull Object view) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewLoadingInfo viewLoadingInfo = this.viewsTimeAndState.get(view);
        return viewLoadingInfo == null ? false : (bl = viewLoadingInfo.getFirstTimeLoading());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J8\u0010\u001c\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer$ViewLoadingInfo;", "", "loadingStart", "", "loadingTime", "firstTimeLoading", "", "finishedLoadingOnce", "(Ljava/lang/Long;JZZ)V", "getFinishedLoadingOnce", "()Z", "setFinishedLoadingOnce", "(Z)V", "getFirstTimeLoading", "setFirstTimeLoading", "getLoadingStart", "()Ljava/lang/Long;", "setLoadingStart", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getLoadingTime", "()J", "setLoadingTime", "(J)V", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Long;JZZ)Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer$ViewLoadingInfo;", "equals", "other", "hashCode", "", "toString", "", "dd-sdk-android_release"})
    private static final class ViewLoadingInfo {
        @Nullable
        private Long loadingStart;
        private long loadingTime;
        private boolean firstTimeLoading;
        private boolean finishedLoadingOnce;

        public ViewLoadingInfo(@Nullable Long loadingStart, long loadingTime, boolean firstTimeLoading, boolean finishedLoadingOnce) {
            this.loadingStart = loadingStart;
            this.loadingTime = loadingTime;
            this.firstTimeLoading = firstTimeLoading;
            this.finishedLoadingOnce = finishedLoadingOnce;
        }

        public /* synthetic */ ViewLoadingInfo(Long l, long l2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(l, l2, bl, bl2);
        }

        @Nullable
        public final Long getLoadingStart() {
            return this.loadingStart;
        }

        public final void setLoadingStart(@Nullable Long l) {
            this.loadingStart = l;
        }

        public final long getLoadingTime() {
            return this.loadingTime;
        }

        public final void setLoadingTime(long l) {
            this.loadingTime = l;
        }

        public final boolean getFirstTimeLoading() {
            return this.firstTimeLoading;
        }

        public final void setFirstTimeLoading(boolean bl) {
            this.firstTimeLoading = bl;
        }

        public final boolean getFinishedLoadingOnce() {
            return this.finishedLoadingOnce;
        }

        public final void setFinishedLoadingOnce(boolean bl) {
            this.finishedLoadingOnce = bl;
        }

        @Nullable
        public final Long component1() {
            return this.loadingStart;
        }

        public final long component2() {
            return this.loadingTime;
        }

        public final boolean component3() {
            return this.firstTimeLoading;
        }

        public final boolean component4() {
            return this.finishedLoadingOnce;
        }

        @NotNull
        public final ViewLoadingInfo copy(@Nullable Long loadingStart, long loadingTime, boolean firstTimeLoading, boolean finishedLoadingOnce) {
            return new ViewLoadingInfo(loadingStart, loadingTime, firstTimeLoading, finishedLoadingOnce);
        }

        public static /* synthetic */ ViewLoadingInfo copy$default(ViewLoadingInfo viewLoadingInfo, Long l, long l2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                l = viewLoadingInfo.loadingStart;
            }
            if ((n & 2) != 0) {
                l2 = viewLoadingInfo.loadingTime;
            }
            if ((n & 4) != 0) {
                bl = viewLoadingInfo.firstTimeLoading;
            }
            if ((n & 8) != 0) {
                bl2 = viewLoadingInfo.finishedLoadingOnce;
            }
            return viewLoadingInfo.copy(l, l2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ViewLoadingInfo(loadingStart=" + this.loadingStart + ", loadingTime=" + this.loadingTime + ", firstTimeLoading=" + this.firstTimeLoading + ", finishedLoadingOnce=" + this.finishedLoadingOnce + ")";
        }

        public int hashCode() {
            int result = this.loadingStart == null ? 0 : ((Object)this.loadingStart).hashCode();
            result = result * 31 + Long.hashCode(this.loadingTime);
            int n = this.firstTimeLoading ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.finishedLoadingOnce ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewLoadingInfo)) {
                return false;
            }
            ViewLoadingInfo viewLoadingInfo = (ViewLoadingInfo)other;
            if (!Intrinsics.areEqual((Object)this.loadingStart, (Object)viewLoadingInfo.loadingStart)) {
                return false;
            }
            if (this.loadingTime != viewLoadingInfo.loadingTime) {
                return false;
            }
            if (this.firstTimeLoading != viewLoadingInfo.firstTimeLoading) {
                return false;
            }
            return this.finishedLoadingOnce == viewLoadingInfo.finishedLoadingOnce;
        }
    }
}

