/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesTracker;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.tracking.FragmentLifecycleCallbacks;
import com.datadog.android.rum.internal.tracking.ViewLoadingTimer;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BW\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J \u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0006H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0002H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/FragmentLifecycleCallbacks;", "Landroidx/fragment/app/FragmentActivity;", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "viewLoadingTimer", "Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "rumMonitor", "Lcom/datadog/android/rum/RumMonitor;", "advancedRumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "(Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;Lcom/datadog/android/rum/internal/RumFeature;Lcom/datadog/android/rum/RumMonitor;Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "getArgumentsProvider$dd_sdk_android_release", "()Lkotlin/jvm/functions/Function1;", "getViewLoadingTimer$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "setViewLoadingTimer$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;)V", "onFragmentActivityCreated", "", "fm", "Landroidx/fragment/app/FragmentManager;", "f", "savedInstanceState", "Landroid/os/Bundle;", "onFragmentAttached", "context", "Landroid/content/Context;", "onFragmentDestroyed", "onFragmentPaused", "onFragmentResumed", "onFragmentStarted", "register", "activity", "resolveKey", "fragment", "resolveLoadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "firstTimeLoading", "", "unregister", "dd-sdk-android_release"})
public class AndroidXFragmentLifecycleCallbacks
extends FragmentManager.FragmentLifecycleCallbacks
implements FragmentLifecycleCallbacks<FragmentActivity> {
    @NotNull
    private final Function1<Fragment, Map<String, Object>> argumentsProvider;
    @NotNull
    private final ComponentPredicate<Fragment> componentPredicate;
    @NotNull
    private ViewLoadingTimer viewLoadingTimer;
    @NotNull
    private final RumFeature rumFeature;
    @NotNull
    private final RumMonitor rumMonitor;
    @NotNull
    private final AdvancedRumMonitor advancedRumMonitor;

    public AndroidXFragmentLifecycleCallbacks(@NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull ViewLoadingTimer viewLoadingTimer, @NotNull RumFeature rumFeature, @NotNull RumMonitor rumMonitor, @NotNull AdvancedRumMonitor advancedRumMonitor2) {
        Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        Intrinsics.checkNotNullParameter((Object)viewLoadingTimer, (String)"viewLoadingTimer");
        Intrinsics.checkNotNullParameter((Object)rumFeature, (String)"rumFeature");
        Intrinsics.checkNotNullParameter((Object)rumMonitor, (String)"rumMonitor");
        Intrinsics.checkNotNullParameter((Object)advancedRumMonitor2, (String)"advancedRumMonitor");
        this.argumentsProvider = argumentsProvider;
        this.componentPredicate = componentPredicate;
        this.viewLoadingTimer = viewLoadingTimer;
        this.rumFeature = rumFeature;
        this.rumMonitor = rumMonitor;
        this.advancedRumMonitor = advancedRumMonitor2;
    }

    public /* synthetic */ AndroidXFragmentLifecycleCallbacks(Function1 function1, ComponentPredicate componentPredicate, ViewLoadingTimer viewLoadingTimer, RumFeature rumFeature, RumMonitor rumMonitor, AdvancedRumMonitor advancedRumMonitor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            viewLoadingTimer = new ViewLoadingTimer();
        }
        this((Function1<? super Fragment, ? extends Map<String, ? extends Object>>)function1, componentPredicate, viewLoadingTimer, rumFeature, rumMonitor, advancedRumMonitor2);
    }

    @NotNull
    public final Function1<Fragment, Map<String, Object>> getArgumentsProvider$dd_sdk_android_release() {
        return this.argumentsProvider;
    }

    @NotNull
    public final ViewLoadingTimer getViewLoadingTimer$dd_sdk_android_release() {
        return this.viewLoadingTimer;
    }

    public final void setViewLoadingTimer$dd_sdk_android_release(@NotNull ViewLoadingTimer viewLoadingTimer) {
        Intrinsics.checkNotNullParameter((Object)viewLoadingTimer, (String)"<set-?>");
        this.viewLoadingTimer = viewLoadingTimer;
    }

    @Override
    public void register(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this, true);
    }

    @Override
    public void unregister(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getSupportFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
    }

    public void onFragmentAttached(@NotNull FragmentManager fm, @NotNull Fragment f, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onFragmentAttached(fm, f, context);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onCreated(this.resolveKey(it));
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentStarted(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentStarted(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onStartLoading(this.resolveKey(it));
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentActivityCreated(@NotNull FragmentManager fm, @NotNull Fragment f, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentActivityCreated(fm, f, savedInstanceState);
        Context context = f.getContext();
        if (f instanceof DialogFragment && context != null) {
            Dialog dialog = ((DialogFragment)f).getDialog();
            Window window = dialog == null ? null : dialog.getWindow();
            GesturesTracker gesturesTracker = this.rumFeature.getActionTrackingStrategy$dd_sdk_android_release().getGesturesTracker();
            gesturesTracker.startTracking(window, context);
        }
    }

    public void onFragmentResumed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentResumed(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                Object key = this.resolveKey(it);
                this.getViewLoadingTimer$dd_sdk_android_release().onFinishedLoading(key);
                ComponentPredicate<Fragment> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(f);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(f) : customName$iv;
                this.rumMonitor.startView(key, viewName, (Map)this.getArgumentsProvider$dd_sdk_android_release().invoke((Object)it));
                Long loadingTime = this.getViewLoadingTimer$dd_sdk_android_release().getLoadingTime(key);
                if (loadingTime != null) {
                    this.advancedRumMonitor.updateViewLoadingTime(key, loadingTime, this.resolveLoadingType(this.getViewLoadingTimer$dd_sdk_android_release().isFirstTimeLoading(key)));
                }
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentPaused(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentPaused(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                Object key = this.resolveKey(it);
                RumMonitor.DefaultImpls.stopView$default(this.rumMonitor, key, null, 2, null);
                this.getViewLoadingTimer$dd_sdk_android_release().onPaused(key);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onFragmentDestroyed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentDestroyed(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onDestroyed(this.resolveKey(it));
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    @NotNull
    public Object resolveKey(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return fragment;
    }

    private final ViewEvent.LoadingType resolveLoadingType(boolean firstTimeLoading) {
        return firstTimeLoading ? ViewEvent.LoadingType.FRAGMENT_DISPLAY : ViewEvent.LoadingType.FRAGMENT_REDISPLAY;
    }
}

