/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AbsListView;
import androidx.core.view.ScrollingView;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesUtilsKt;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import com.datadog.android.v2.api.InternalLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0000\u0018\u0000 H2\u00020\u0001:\u0001HB;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002J\u001a\u0010#\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u001eH\u0002J6\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010/\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u00100\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u0010$\u001a\u00020\u001eH\u0016J(\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u0014H\u0016J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001eH\u0016J(\u00108\u001a\u00020+2\u0006\u00103\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u0014H\u0016J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u00020+2\u0006\u0010$\u001a\u00020\u001eH\u0016J\u000e\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u001eJ\b\u0010@\u001a\u00020\u001bH\u0002J0\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010C0B2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u001eH\u0002R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener;", "Landroid/view/GestureDetector$OnGestureListener;", "windowReference", "Ljava/lang/ref/WeakReference;", "Landroid/view/Window;", "attributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "contextRef", "Ljava/lang/ref/Reference;", "Landroid/content/Context;", "(Ljava/lang/ref/WeakReference;[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;Ljava/lang/ref/Reference;)V", "[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "coordinatesContainer", "", "gestureDirection", "", "onTouchDownXPos", "", "onTouchDownYPos", "scrollEventType", "Lcom/datadog/android/rum/RumActionType;", "scrollTargetReference", "Landroid/view/View;", "closeScrollOrSwipeEventIfAny", "", "decorView", "onUpEvent", "Landroid/view/MotionEvent;", "findTargetForScroll", "x", "y", "findTargetForTap", "handleTapUp", "e", "handleViewGroup", "view", "Landroid/view/ViewGroup;", "stack", "Ljava/util/LinkedList;", "hitTest", "", "container", "isJetpackComposeView", "isScrollableView", "isValidScrollableTarget", "isValidTapTarget", "onDown", "onFling", "startDownEvent", "endUpEvent", "velocityX", "velocityY", "onLongPress", "onScroll", "currentMoveEvent", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onUp", "event", "resetScrollEventParameters", "resolveAttributes", "", "", "scrollTarget", "targetId", "resolveGestureDirection", "endEvent", "Companion", "dd-sdk-android_release"})
public final class GesturesListener
implements GestureDetector.OnGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<Window> windowReference;
    @NotNull
    private final ViewAttributesProvider[] attributesProviders;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final Reference<Context> contextRef;
    @NotNull
    private final int[] coordinatesContainer;
    @Nullable
    private RumActionType scrollEventType;
    @NotNull
    private String gestureDirection;
    @NotNull
    private WeakReference<View> scrollTargetReference;
    private float onTouchDownXPos;
    private float onTouchDownYPos;
    @NotNull
    public static final String SCROLL_DIRECTION_LEFT = "left";
    @NotNull
    public static final String SCROLL_DIRECTION_RIGHT = "right";
    @NotNull
    public static final String SCROLL_DIRECTION_UP = "up";
    @NotNull
    public static final String SCROLL_DIRECTION_DOWN = "down";
    @NotNull
    private static final String MSG_NO_TARGET_TAP = "We could not find a valid target for the " + RumActionType.TAP.name() + " event.The DecorView was empty and either transparent or not clickable for this Activity.";
    @NotNull
    private static final String MSG_NO_TARGET_SCROLL_SWIPE = "We could not find a valid target for the " + RumActionType.SCROLL.name() + " or " + RumActionType.SWIPE.name() + " event. The DecorView was empty and either transparent or not clickable for this Activity.";

    public GesturesListener(@NotNull WeakReference<Window> windowReference, @NotNull ViewAttributesProvider[] attributesProviders, @NotNull InteractionPredicate interactionPredicate, @NotNull Reference<Context> contextRef) {
        Intrinsics.checkNotNullParameter(windowReference, (String)"windowReference");
        Intrinsics.checkNotNullParameter((Object)attributesProviders, (String)"attributesProviders");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter(contextRef, (String)"contextRef");
        this.windowReference = windowReference;
        this.attributesProviders = attributesProviders;
        this.interactionPredicate = interactionPredicate;
        this.contextRef = contextRef;
        this.coordinatesContainer = new int[2];
        this.gestureDirection = "";
        this.scrollTargetReference = new WeakReference<Object>(null);
    }

    public /* synthetic */ GesturesListener(WeakReference weakReference, ViewAttributesProvider[] viewAttributesProviderArray, InteractionPredicate interactionPredicate, Reference reference, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean $i$f$emptyArray = false;
            viewAttributesProviderArray = new ViewAttributesProvider[]{};
        }
        if ((n & 4) != 0) {
            interactionPredicate = new NoOpInteractionPredicate();
        }
        this(weakReference, viewAttributesProviderArray, interactionPredicate, reference);
    }

    public void onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Window window = (Window)this.windowReference.get();
        View decorView = window == null ? null : window.getDecorView();
        this.handleTapUp(decorView, e);
        return false;
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.resetScrollEventParameters();
        this.onTouchDownXPos = e.getX();
        this.onTouchDownYPos = e.getY();
        return false;
    }

    public final void onUp(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Window window = (Window)this.windowReference.get();
        View decorView = window == null ? null : window.getDecorView();
        this.closeScrollOrSwipeEventIfAny(decorView, event);
        this.resetScrollEventParameters();
    }

    public boolean onFling(@NotNull MotionEvent startDownEvent, @NotNull MotionEvent endUpEvent, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)startDownEvent, (String)"startDownEvent");
        Intrinsics.checkNotNullParameter((Object)endUpEvent, (String)"endUpEvent");
        this.scrollEventType = RumActionType.SWIPE;
        return false;
    }

    public boolean onScroll(@NotNull MotionEvent startDownEvent, @NotNull MotionEvent currentMoveEvent, float distanceX, float distanceY) {
        Intrinsics.checkNotNullParameter((Object)startDownEvent, (String)"startDownEvent");
        Intrinsics.checkNotNullParameter((Object)currentMoveEvent, (String)"currentMoveEvent");
        RumMonitor rumMonitor = GlobalRum.get();
        Window window = (Window)this.windowReference.get();
        Object object = window == null ? null : window.getDecorView();
        if (object == null) {
            return false;
        }
        View decorView = object;
        if (this.scrollEventType == null) {
            View scrollTarget = this.findTargetForScroll(decorView, startDownEvent.getX(), startDownEvent.getY());
            if (scrollTarget == null) {
                return false;
            }
            this.scrollTargetReference = new WeakReference<View>(scrollTarget);
            String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), scrollTarget.getId());
            Map<String, Object> attributes = this.resolveAttributes(scrollTarget, targetId, null);
            rumMonitor.startUserAction(RumActionType.SCROLL, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, scrollTarget), attributes);
            this.scrollEventType = RumActionType.SCROLL;
        }
        return false;
    }

    public void onLongPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private final void closeScrollOrSwipeEventIfAny(View decorView, MotionEvent onUpEvent) {
        RumActionType rumActionType = this.scrollEventType;
        if (rumActionType == null) {
            return;
        }
        RumActionType type = rumActionType;
        RumMonitor registeredRumMonitor = GlobalRum.get();
        View scrollTarget = (View)this.scrollTargetReference.get();
        if (decorView == null || scrollTarget == null) {
            return;
        }
        String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), scrollTarget.getId());
        Map<String, Object> attributes = this.resolveAttributes(scrollTarget, targetId, onUpEvent);
        registeredRumMonitor.stopUserAction(type, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, scrollTarget), attributes);
    }

    private final Map<String, Object> resolveAttributes(View scrollTarget, String targetId, MotionEvent onUpEvent) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName(scrollTarget)), TuplesKt.to((Object)"action.target.resource_id", (Object)targetId)};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        if (onUpEvent != null) {
            this.gestureDirection = this.resolveGestureDirection(onUpEvent);
            attributes.put("action.gesture.direction", this.gestureDirection);
        }
        ViewAttributesProvider[] $this$forEach$iv = this.attributesProviders;
        boolean $i$f$forEach = false;
        for (ViewAttributesProvider element$iv : $this$forEach$iv) {
            ViewAttributesProvider it = element$iv;
            boolean bl = false;
            it.extractAttributes(scrollTarget, attributes);
        }
        return attributes;
    }

    private final void resetScrollEventParameters() {
        this.scrollTargetReference.clear();
        this.scrollEventType = null;
        this.gestureDirection = "";
        this.onTouchDownYPos = 0.0f;
        this.onTouchDownXPos = 0.0f;
    }

    private final void handleTapUp(View decorView, MotionEvent e) {
        if (decorView != null) {
            View view = this.findTargetForTap(decorView, e.getX(), e.getY());
            if (view != null) {
                View target = view;
                boolean bl = false;
                String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), target.getId());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName(target)), TuplesKt.to((Object)"action.target.resource_id", (Object)targetId)};
                Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
                ViewAttributesProvider[] $this$forEach$iv = this.attributesProviders;
                boolean $i$f$forEach = false;
                for (ViewAttributesProvider element$iv : $this$forEach$iv) {
                    ViewAttributesProvider it = element$iv;
                    boolean bl2 = false;
                    it.extractAttributes(target, attributes);
                }
                GlobalRum.get().addUserAction(RumActionType.TAP, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, target), attributes);
            }
        }
    }

    private final View findTargetForTap(View decorView, float x, float y) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.addFirst(decorView);
        View target = null;
        boolean notifyMissingTarget = true;
        while (!((Collection)queue).isEmpty()) {
            View view = (View)queue.removeFirst();
            if (queue.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                if (this.isJetpackComposeView(view)) {
                    notifyMissingTarget = false;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            if (this.isValidTapTarget(view)) {
                target = view;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.handleViewGroup((ViewGroup)view, x, y, queue, this.coordinatesContainer);
        }
        if (target == null && notifyMissingTarget) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, MSG_NO_TARGET_TAP, null, 8, null);
        }
        return target;
    }

    private final View findTargetForScroll(View decorView, float x, float y) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(decorView);
        boolean notifyMissingTarget = true;
        while (!((Collection)queue).isEmpty()) {
            View view = (View)queue.removeFirst();
            if (queue.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                if (this.isJetpackComposeView(view)) {
                    notifyMissingTarget = false;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            if (this.isValidScrollableTarget(view)) {
                return view;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.handleViewGroup((ViewGroup)view, x, y, queue, this.coordinatesContainer);
        }
        if (notifyMissingTarget) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, MSG_NO_TARGET_SCROLL_SWIPE, null, 8, null);
        }
        return null;
    }

    private final void handleViewGroup(ViewGroup view, float x, float y, LinkedList<View> stack, int[] coordinatesContainer) {
        int n = 0;
        int n2 = view.getChildCount();
        while (n < n2) {
            int i = n++;
            View child = view.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            if (!this.hitTest(child, x, y, coordinatesContainer)) continue;
            stack.add(child);
        }
    }

    private final boolean isValidTapTarget(View view) {
        return view.isClickable() && view.getVisibility() == 0;
    }

    private final boolean isValidScrollableTarget(View view) {
        return view.getVisibility() == 0 && this.isScrollableView(view);
    }

    private final boolean isScrollableView(View view) {
        return ScrollingView.class.isAssignableFrom(view.getClass()) || AbsListView.class.isAssignableFrom(view.getClass());
    }

    private final boolean hitTest(View view, float x, float y, int[] container) {
        view.getLocationInWindow(container);
        int vx = container[0];
        int vy = container[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(x < (float)vx || x > (float)(vx + w) || y < (float)vy || y > (float)(vy + h));
    }

    private final String resolveGestureDirection(MotionEvent endEvent) {
        float diffX = endEvent.getX() - this.onTouchDownXPos;
        float diffY = endEvent.getY() - this.onTouchDownYPos;
        return Math.abs(diffX) > Math.abs(diffY) ? (diffX > 0.0f ? SCROLL_DIRECTION_RIGHT : SCROLL_DIRECTION_LEFT) : (diffY > 0.0f ? SCROLL_DIRECTION_DOWN : SCROLL_DIRECTION_UP);
    }

    private final boolean isJetpackComposeView(View view) {
        String string = view.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.name");
        return StringsKt.startsWith$default((String)string, (String)"androidx.compose.ui.platform.ComposeView", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener$Companion;", "", "()V", "MSG_NO_TARGET_SCROLL_SWIPE", "", "getMSG_NO_TARGET_SCROLL_SWIPE$dd_sdk_android_release", "()Ljava/lang/String;", "MSG_NO_TARGET_TAP", "getMSG_NO_TARGET_TAP$dd_sdk_android_release", "SCROLL_DIRECTION_DOWN", "SCROLL_DIRECTION_LEFT", "SCROLL_DIRECTION_RIGHT", "SCROLL_DIRECTION_UP", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMSG_NO_TARGET_TAP$dd_sdk_android_release() {
            return MSG_NO_TARGET_TAP;
        }

        @NotNull
        public final String getMSG_NO_TARGET_SCROLL_SWIPE$dd_sdk_android_release() {
            return MSG_NO_TARGET_SCROLL_SWIPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

