/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.AppStartTimeProvider;
import com.datadog.android.rum.internal.DefaultAppStartTimeProvider;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewManagerScope;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.datadog.android.v2.core.internal.storage.NoOpDataWriter;
import java.security.SecureRandom;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 T2\u00020\u0001:\u0002TUB\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\b\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001cJ\b\u0010G\u001a\u00020HH\u0016J \u0010I\u001a\u0004\u0018\u00010\u00012\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002000MH\u0017J\b\u0010(\u001a\u00020\bH\u0016J\b\u0010N\u001a\u00020\bH\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u001aH\u0002J\b\u0010R\u001a\u00020PH\u0002J\u0010\u0010S\u001a\u00020P2\u0006\u0010J\u001a\u00020KH\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0004\u0018\u00010\u0001X\u0080\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u00020?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001eR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006V"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "samplingRate", "", "backgroundTrackingEnabled", "", "trackFrustrations", "viewChangedListener", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "applicationDisplayed", "appStartTimeProvider", "Lcom/datadog/android/rum/internal/AppStartTimeProvider;", "sessionInactivityNanos", "", "sessionMaxDurationNanos", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/v2/api/SdkCore;FZZLcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/RumSessionListener;Lcom/datadog/android/v2/core/internal/ContextProvider;ZLcom/datadog/android/rum/internal/AppStartTimeProvider;JJ)V", "getBackgroundTrackingEnabled$dd_sdk_android_release", "()Z", "childScope", "getChildScope$dd_sdk_android_release$annotations", "()V", "getChildScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "setChildScope$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;)V", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "isActive", "isActive$dd_sdk_android_release", "setActive$dd_sdk_android_release", "(Z)V", "lastUserInteractionNs", "Ljava/util/concurrent/atomic/AtomicLong;", "noOpWriter", "Lcom/datadog/android/v2/core/internal/storage/NoOpDataWriter;", "", "random", "Ljava/security/SecureRandom;", "getSamplingRate$dd_sdk_android_release", "()F", "sessionId", "", "getSessionId$dd_sdk_android_release", "()Ljava/lang/String;", "setSessionId$dd_sdk_android_release", "(Ljava/lang/String;)V", "getSessionListener$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumSessionListener;", "sessionStartNs", "sessionState", "Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;", "getSessionState$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;", "setSessionState$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;)V", "getTrackFrustrations$dd_sdk_android_release", "getViewChangedListener$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "isSessionComplete", "renewSession", "", "nanoTime", "stopSession", "updateSession", "Companion", "State", "dd-sdk-android_release"})
public final class RumSessionScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final SdkCore sdkCore;
    private final float samplingRate;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @Nullable
    private final RumViewChangedListener viewChangedListener;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @Nullable
    private final RumSessionListener sessionListener;
    private final long sessionInactivityNanos;
    private final long sessionMaxDurationNanos;
    @NotNull
    private String sessionId;
    @NotNull
    private State sessionState;
    private boolean isActive;
    @NotNull
    private final AtomicLong sessionStartNs;
    @NotNull
    private final AtomicLong lastUserInteractionNs;
    @NotNull
    private final SecureRandom random;
    @NotNull
    private final NoOpDataWriter<Object> noOpWriter;
    @Nullable
    private RumScope childScope;
    @NotNull
    public static final String SESSION_REPLAY_FEATURE_NAME = "session-replay";
    @NotNull
    public static final String SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY = "type";
    @NotNull
    public static final String RUM_SESSION_RENEWED_BUS_MESSAGE = "rum_session_renewed";
    @NotNull
    public static final String RUM_KEEP_SESSION_BUS_MESSAGE_KEY = "keepSession";
    private static final long DEFAULT_SESSION_INACTIVITY_NS = TimeUnit.MINUTES.toNanos(15L);
    private static final long DEFAULT_SESSION_MAX_DURATION_NS = TimeUnit.HOURS.toNanos(4L);

    public RumSessionScope(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, float samplingRate, boolean backgroundTrackingEnabled, boolean trackFrustrations2, @Nullable RumViewChangedListener viewChangedListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @Nullable RumSessionListener sessionListener, @NotNull ContextProvider contextProvider, boolean applicationDisplayed, @NotNull AppStartTimeProvider appStartTimeProvider, long sessionInactivityNanos, long sessionMaxDurationNanos) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)appStartTimeProvider, (String)"appStartTimeProvider");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.samplingRate = samplingRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations2;
        this.viewChangedListener = viewChangedListener;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.sessionListener = sessionListener;
        this.sessionInactivityNanos = sessionInactivityNanos;
        this.sessionMaxDurationNanos = sessionMaxDurationNanos;
        this.sessionId = RumContext.Companion.getNULL_UUID();
        this.sessionState = State.NOT_TRACKED;
        this.isActive = true;
        this.sessionStartNs = new AtomicLong(System.nanoTime());
        this.lastUserInteractionNs = new AtomicLong(0L);
        this.random = new SecureRandom();
        this.noOpWriter = new NoOpDataWriter();
        this.childScope = new RumViewManagerScope(this, this.sdkCore, this.backgroundTrackingEnabled, this.trackFrustrations, this.viewChangedListener, this.firstPartyHostHeaderTypeResolver, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, appStartTimeProvider, contextProvider, applicationDisplayed);
        this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(){

            public final void invoke(@NotNull Map<String, Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.putAll(this.getRumContext().toMap());
            }
        }));
    }

    public /* synthetic */ RumSessionScope(RumScope rumScope, SdkCore sdkCore, float f, boolean bl, boolean bl2, RumViewChangedListener rumViewChangedListener, FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, RumSessionListener rumSessionListener, ContextProvider contextProvider, boolean bl3, AppStartTimeProvider appStartTimeProvider, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x2000) != 0) {
            appStartTimeProvider = new DefaultAppStartTimeProvider(null, 1, null);
        }
        if ((n & 0x4000) != 0) {
            l = DEFAULT_SESSION_INACTIVITY_NS;
        }
        if ((n & 0x8000) != 0) {
            l2 = DEFAULT_SESSION_MAX_DURATION_NS;
        }
        this(rumScope, sdkCore, f, bl, bl2, rumViewChangedListener, firstPartyHostHeaderTypeResolver, vitalMonitor, vitalMonitor2, vitalMonitor3, rumSessionListener, contextProvider, bl3, appStartTimeProvider, l, l2);
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_release() {
        return this.backgroundTrackingEnabled;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_release() {
        return this.trackFrustrations;
    }

    @Nullable
    public final RumViewChangedListener getViewChangedListener$dd_sdk_android_release() {
        return this.viewChangedListener;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    @Nullable
    public final RumSessionListener getSessionListener$dd_sdk_android_release() {
        return this.sessionListener;
    }

    @NotNull
    public final String getSessionId$dd_sdk_android_release() {
        return this.sessionId;
    }

    public final void setSessionId$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sessionId = string;
    }

    @NotNull
    public final State getSessionState$dd_sdk_android_release() {
        return this.sessionState;
    }

    public final void setSessionState$dd_sdk_android_release(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.sessionState = state;
    }

    public final boolean isActive$dd_sdk_android_release() {
        return this.isActive;
    }

    public final void setActive$dd_sdk_android_release(boolean bl) {
        this.isActive = bl;
    }

    @Nullable
    public final RumScope getChildScope$dd_sdk_android_release() {
        return this.childScope;
    }

    public final void setChildScope$dd_sdk_android_release(@Nullable RumScope rumScope) {
        this.childScope = rumScope;
    }

    public static /* synthetic */ void getChildScope$dd_sdk_android_release$annotations() {
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (event instanceof RumRawEvent.ResetSession) {
            this.renewSession(System.nanoTime());
        } else if (event instanceof RumRawEvent.StopSession) {
            this.stopSession();
        }
        this.updateSession(event);
        DataWriter actualWriter = this.sessionState == State.TRACKED ? writer : (DataWriter)this.noOpWriter;
        RumScope rumScope = this.childScope;
        this.childScope = rumScope == null ? null : rumScope.handleEvent(event, actualWriter);
        return this.isSessionComplete() ? (RumScope)null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        RumContext parentContext = this.parentScope.getRumContext();
        String string = this.sessionId;
        State state = this.sessionState;
        boolean bl = this.isActive;
        return RumContext.copy$default(parentContext, null, string, bl, null, null, null, null, state, null, 377, null);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private final void stopSession() {
        this.isActive = false;
    }

    private final boolean isSessionComplete() {
        return !this.isActive && this.childScope == null;
    }

    private final void updateSession(RumRawEvent event) {
        long nanoTime = System.nanoTime();
        boolean isNewSession = Intrinsics.areEqual((Object)this.sessionId, (Object)RumContext.Companion.getNULL_UUID());
        long timeSinceLastInteractionNs = nanoTime - this.lastUserInteractionNs.get();
        boolean isExpired = timeSinceLastInteractionNs >= this.sessionInactivityNanos;
        long timeSinceSessionStartNs = nanoTime - this.sessionStartNs.get();
        boolean isTimedOut = timeSinceSessionStartNs >= this.sessionMaxDurationNanos;
        boolean isInteraction = event instanceof RumRawEvent.StartView || event instanceof RumRawEvent.StartAction;
        boolean isBackgroundEvent = ArraysKt.contains((Object[])RumViewManagerScope.Companion.getValidBackgroundEventTypes$dd_sdk_android_release(), event.getClass());
        if (isInteraction) {
            if (isNewSession || isExpired || isTimedOut) {
                this.renewSession(nanoTime);
            }
            this.lastUserInteractionNs.set(nanoTime);
        } else if (isExpired) {
            if (this.backgroundTrackingEnabled && isBackgroundEvent) {
                this.renewSession(nanoTime);
                this.lastUserInteractionNs.set(nanoTime);
            } else {
                this.sessionState = State.EXPIRED;
            }
        } else if (isTimedOut) {
            this.renewSession(nanoTime);
        }
    }

    private final void renewSession(long nanoTime) {
        boolean keepSession = (double)this.random.nextFloat() < NumberExtKt.percent(this.samplingRate);
        this.sessionState = keepSession ? State.TRACKED : State.NOT_TRACKED;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.sessionId = string;
        this.sessionStartNs.set(nanoTime);
        this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(this){
            final /* synthetic */ RumSessionScope this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.putAll(this.this$0.getRumContext().toMap());
            }
        }));
        RumSessionListener rumSessionListener = this.sessionListener;
        if (rumSessionListener != null) {
            rumSessionListener.onSessionStarted(this.sessionId, !keepSession);
        }
        FeatureScope featureScope = this.sdkCore.getFeature(SESSION_REPLAY_FEATURE_NAME);
        if (featureScope != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY, (Object)RUM_SESSION_RENEWED_BUS_MESSAGE), TuplesKt.to((Object)RUM_KEEP_SESSION_BUS_MESSAGE_KEY, (Object)keepSession)};
            featureScope.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$State;", "", "(Ljava/lang/String;I)V", "NOT_TRACKED", "TRACKED", "EXPIRED", "dd-sdk-android_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_TRACKED = new State();
        public static final /* enum */ State TRACKED = new State();
        public static final /* enum */ State EXPIRED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_TRACKED, State.TRACKED, State.EXPIRED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$Companion;", "", "()V", "DEFAULT_SESSION_INACTIVITY_NS", "", "getDEFAULT_SESSION_INACTIVITY_NS$dd_sdk_android_release", "()J", "DEFAULT_SESSION_MAX_DURATION_NS", "getDEFAULT_SESSION_MAX_DURATION_NS$dd_sdk_android_release", "RUM_KEEP_SESSION_BUS_MESSAGE_KEY", "", "RUM_SESSION_RENEWED_BUS_MESSAGE", "SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY", "SESSION_REPLAY_FEATURE_NAME", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_SESSION_INACTIVITY_NS$dd_sdk_android_release() {
            return DEFAULT_SESSION_INACTIVITY_NS;
        }

        public final long getDEFAULT_SESSION_MAX_DURATION_NS$dd_sdk_android_release() {
            return DEFAULT_SESSION_MAX_DURATION_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

