/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.core.internal.event.NoOpEventMapper;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.EventMapper;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+Be\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0001H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0001H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001H\u00c6\u0003Ji\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0012\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0002H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020\u0002H\u0002J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMapper;", "Lcom/datadog/android/event/EventMapper;", "", "viewEventMapper", "Lcom/datadog/android/rum/model/ViewEvent;", "errorEventMapper", "Lcom/datadog/android/rum/model/ErrorEvent;", "resourceEventMapper", "Lcom/datadog/android/rum/model/ResourceEvent;", "actionEventMapper", "Lcom/datadog/android/rum/model/ActionEvent;", "longTaskEventMapper", "Lcom/datadog/android/rum/model/LongTaskEvent;", "telemetryConfigurationMapper", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "(Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;)V", "getActionEventMapper", "()Lcom/datadog/android/event/EventMapper;", "getErrorEventMapper", "getLongTaskEventMapper", "getResourceEventMapper", "getTelemetryConfigurationMapper", "getViewEventMapper", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "map", "event", "mapRumEvent", "notifyEventDropped", "", "resolveEvent", "toString", "", "Companion", "dd-sdk-android_release"})
public final class RumEventMapper
implements EventMapper<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventMapper<ViewEvent> viewEventMapper;
    @NotNull
    private final EventMapper<ErrorEvent> errorEventMapper;
    @NotNull
    private final EventMapper<ResourceEvent> resourceEventMapper;
    @NotNull
    private final EventMapper<ActionEvent> actionEventMapper;
    @NotNull
    private final EventMapper<LongTaskEvent> longTaskEventMapper;
    @NotNull
    private final EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper;
    @NotNull
    public static final String VIEW_EVENT_NULL_WARNING_MESSAGE = "RumEventMapper: the returned mapped ViewEvent was null. The original event object will be used instead: %s";
    @NotNull
    public static final String EVENT_NULL_WARNING_MESSAGE = "RumEventMapper: the returned mapped object was null. This event will be dropped: %s";
    @NotNull
    public static final String NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE = "RumEventMapper: the returned mapped object was not the same instance as the original object. This event will be dropped: %s";
    @NotNull
    public static final String NO_EVENT_MAPPER_ASSIGNED_WARNING_MESSAGE = "RumEventMapper: there was no EventMapper assigned for RUM event type: %s";

    public RumEventMapper(@NotNull EventMapper<ViewEvent> viewEventMapper, @NotNull EventMapper<ErrorEvent> errorEventMapper, @NotNull EventMapper<ResourceEvent> resourceEventMapper, @NotNull EventMapper<ActionEvent> actionEventMapper, @NotNull EventMapper<LongTaskEvent> longTaskEventMapper, @NotNull EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper) {
        Intrinsics.checkNotNullParameter(viewEventMapper, (String)"viewEventMapper");
        Intrinsics.checkNotNullParameter(errorEventMapper, (String)"errorEventMapper");
        Intrinsics.checkNotNullParameter(resourceEventMapper, (String)"resourceEventMapper");
        Intrinsics.checkNotNullParameter(actionEventMapper, (String)"actionEventMapper");
        Intrinsics.checkNotNullParameter(longTaskEventMapper, (String)"longTaskEventMapper");
        Intrinsics.checkNotNullParameter(telemetryConfigurationMapper, (String)"telemetryConfigurationMapper");
        this.viewEventMapper = viewEventMapper;
        this.errorEventMapper = errorEventMapper;
        this.resourceEventMapper = resourceEventMapper;
        this.actionEventMapper = actionEventMapper;
        this.longTaskEventMapper = longTaskEventMapper;
        this.telemetryConfigurationMapper = telemetryConfigurationMapper;
    }

    public /* synthetic */ RumEventMapper(EventMapper eventMapper, EventMapper eventMapper2, EventMapper eventMapper3, EventMapper eventMapper4, EventMapper eventMapper5, EventMapper eventMapper6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eventMapper = new NoOpEventMapper();
        }
        if ((n & 2) != 0) {
            eventMapper2 = new NoOpEventMapper();
        }
        if ((n & 4) != 0) {
            eventMapper3 = new NoOpEventMapper();
        }
        if ((n & 8) != 0) {
            eventMapper4 = new NoOpEventMapper();
        }
        if ((n & 0x10) != 0) {
            eventMapper5 = new NoOpEventMapper();
        }
        if ((n & 0x20) != 0) {
            eventMapper6 = new NoOpEventMapper();
        }
        this(eventMapper, eventMapper2, eventMapper3, eventMapper4, eventMapper5, eventMapper6);
    }

    @NotNull
    public final EventMapper<ViewEvent> getViewEventMapper() {
        return this.viewEventMapper;
    }

    @NotNull
    public final EventMapper<ErrorEvent> getErrorEventMapper() {
        return this.errorEventMapper;
    }

    @NotNull
    public final EventMapper<ResourceEvent> getResourceEventMapper() {
        return this.resourceEventMapper;
    }

    @NotNull
    public final EventMapper<ActionEvent> getActionEventMapper() {
        return this.actionEventMapper;
    }

    @NotNull
    public final EventMapper<LongTaskEvent> getLongTaskEventMapper() {
        return this.longTaskEventMapper;
    }

    @NotNull
    public final EventMapper<TelemetryConfigurationEvent> getTelemetryConfigurationMapper() {
        return this.telemetryConfigurationMapper;
    }

    @Override
    @Nullable
    public Object map(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object mappedEvent = this.resolveEvent(event);
        if (mappedEvent == null) {
            this.notifyEventDropped(event);
        }
        return mappedEvent;
    }

    private final Object mapRumEvent(Object event) {
        Object object;
        Object object2 = event;
        if (object2 instanceof ViewEvent) {
            object = this.viewEventMapper.map((ViewEvent)event);
        } else if (object2 instanceof ActionEvent) {
            object = this.actionEventMapper.map((ActionEvent)event);
        } else if (object2 instanceof ErrorEvent) {
            object = !Intrinsics.areEqual((Object)((ErrorEvent)event).getError().isCrash(), (Object)true) ? this.errorEventMapper.map((ErrorEvent)event) : (ErrorEvent)event;
        } else if (object2 instanceof ResourceEvent) {
            object = this.resourceEventMapper.map((ResourceEvent)event);
        } else if (object2 instanceof LongTaskEvent) {
            object = this.longTaskEventMapper.map((LongTaskEvent)event);
        } else if (object2 instanceof TelemetryConfigurationEvent) {
            object = this.telemetryConfigurationMapper.map((TelemetryConfigurationEvent)event);
        } else if (object2 instanceof TelemetryDebugEvent ? true : object2 instanceof TelemetryErrorEvent) {
            object = event;
        } else {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object3 = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object3);
            object3 = NO_EVENT_MAPPER_ASSIGNED_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getClass().getSimpleName()};
            String string = String.format(locale, (String)object3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, list, string, null, 8, null);
            object = event;
        }
        return object;
    }

    private final Object resolveEvent(Object event) {
        Object object;
        Object mappedEvent = this.mapRumEvent(event);
        if (event instanceof ViewEvent && (mappedEvent == null || mappedEvent != event)) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = VIEW_EVENT_NULL_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            object = event;
        } else if (mappedEvent == null) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = EVENT_NULL_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string3, null, 8, null);
            object = null;
        } else if (mappedEvent != event) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event};
            String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string4, null, 8, null);
            object = null;
        } else {
            object = event;
        }
        return object;
    }

    private final void notifyEventDropped(Object event) {
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 == null) {
            return;
        }
        AdvancedRumMonitor monitor = advancedRumMonitor2;
        Object object = event;
        if (object instanceof ActionEvent) {
            int n;
            String string = ((ActionEvent)event).getView().getId();
            ActionEvent.Frustration frustration = ((ActionEvent)event).getAction().getFrustration();
            if (frustration == null) {
                n = 0;
            } else {
                int n2;
                List<ActionEvent.Type> list = frustration.getType();
                n = list == null ? 0 : (n2 = list.size());
            }
            monitor.eventDropped(string, new StorageEvent.Action(n));
        } else if (object instanceof ResourceEvent) {
            monitor.eventDropped(((ResourceEvent)event).getView().getId(), StorageEvent.Resource.INSTANCE);
        } else if (object instanceof ErrorEvent) {
            monitor.eventDropped(((ErrorEvent)event).getView().getId(), StorageEvent.Error.INSTANCE);
        } else if (object instanceof LongTaskEvent) {
            if (Intrinsics.areEqual((Object)((LongTaskEvent)event).getLongTask().isFrozenFrame(), (Object)true)) {
                monitor.eventDropped(((LongTaskEvent)event).getView().getId(), StorageEvent.FrozenFrame.INSTANCE);
            } else {
                monitor.eventDropped(((LongTaskEvent)event).getView().getId(), StorageEvent.LongTask.INSTANCE);
            }
        }
    }

    @NotNull
    public final EventMapper<ViewEvent> component1() {
        return this.viewEventMapper;
    }

    @NotNull
    public final EventMapper<ErrorEvent> component2() {
        return this.errorEventMapper;
    }

    @NotNull
    public final EventMapper<ResourceEvent> component3() {
        return this.resourceEventMapper;
    }

    @NotNull
    public final EventMapper<ActionEvent> component4() {
        return this.actionEventMapper;
    }

    @NotNull
    public final EventMapper<LongTaskEvent> component5() {
        return this.longTaskEventMapper;
    }

    @NotNull
    public final EventMapper<TelemetryConfigurationEvent> component6() {
        return this.telemetryConfigurationMapper;
    }

    @NotNull
    public final RumEventMapper copy(@NotNull EventMapper<ViewEvent> viewEventMapper, @NotNull EventMapper<ErrorEvent> errorEventMapper, @NotNull EventMapper<ResourceEvent> resourceEventMapper, @NotNull EventMapper<ActionEvent> actionEventMapper, @NotNull EventMapper<LongTaskEvent> longTaskEventMapper, @NotNull EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper) {
        Intrinsics.checkNotNullParameter(viewEventMapper, (String)"viewEventMapper");
        Intrinsics.checkNotNullParameter(errorEventMapper, (String)"errorEventMapper");
        Intrinsics.checkNotNullParameter(resourceEventMapper, (String)"resourceEventMapper");
        Intrinsics.checkNotNullParameter(actionEventMapper, (String)"actionEventMapper");
        Intrinsics.checkNotNullParameter(longTaskEventMapper, (String)"longTaskEventMapper");
        Intrinsics.checkNotNullParameter(telemetryConfigurationMapper, (String)"telemetryConfigurationMapper");
        return new RumEventMapper(viewEventMapper, errorEventMapper, resourceEventMapper, actionEventMapper, longTaskEventMapper, telemetryConfigurationMapper);
    }

    public static /* synthetic */ RumEventMapper copy$default(RumEventMapper rumEventMapper, EventMapper eventMapper, EventMapper eventMapper2, EventMapper eventMapper3, EventMapper eventMapper4, EventMapper eventMapper5, EventMapper eventMapper6, int n, Object object) {
        if ((n & 1) != 0) {
            eventMapper = rumEventMapper.viewEventMapper;
        }
        if ((n & 2) != 0) {
            eventMapper2 = rumEventMapper.errorEventMapper;
        }
        if ((n & 4) != 0) {
            eventMapper3 = rumEventMapper.resourceEventMapper;
        }
        if ((n & 8) != 0) {
            eventMapper4 = rumEventMapper.actionEventMapper;
        }
        if ((n & 0x10) != 0) {
            eventMapper5 = rumEventMapper.longTaskEventMapper;
        }
        if ((n & 0x20) != 0) {
            eventMapper6 = rumEventMapper.telemetryConfigurationMapper;
        }
        return rumEventMapper.copy(eventMapper, eventMapper2, eventMapper3, eventMapper4, eventMapper5, eventMapper6);
    }

    @NotNull
    public String toString() {
        return "RumEventMapper(viewEventMapper=" + this.viewEventMapper + ", errorEventMapper=" + this.errorEventMapper + ", resourceEventMapper=" + this.resourceEventMapper + ", actionEventMapper=" + this.actionEventMapper + ", longTaskEventMapper=" + this.longTaskEventMapper + ", telemetryConfigurationMapper=" + this.telemetryConfigurationMapper + ")";
    }

    public int hashCode() {
        int result = this.viewEventMapper.hashCode();
        result = result * 31 + this.errorEventMapper.hashCode();
        result = result * 31 + this.resourceEventMapper.hashCode();
        result = result * 31 + this.actionEventMapper.hashCode();
        result = result * 31 + this.longTaskEventMapper.hashCode();
        result = result * 31 + this.telemetryConfigurationMapper.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumEventMapper)) {
            return false;
        }
        RumEventMapper rumEventMapper = (RumEventMapper)other;
        if (!Intrinsics.areEqual(this.viewEventMapper, rumEventMapper.viewEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorEventMapper, rumEventMapper.errorEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.resourceEventMapper, rumEventMapper.resourceEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actionEventMapper, rumEventMapper.actionEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.longTaskEventMapper, rumEventMapper.longTaskEventMapper)) {
            return false;
        }
        return Intrinsics.areEqual(this.telemetryConfigurationMapper, rumEventMapper.telemetryConfigurationMapper);
    }

    public RumEventMapper() {
        this(null, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMapper$Companion;", "", "()V", "EVENT_NULL_WARNING_MESSAGE", "", "NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE", "NO_EVENT_MAPPER_ASSIGNED_WARNING_MESSAGE", "VIEW_EVENT_NULL_WARNING_MESSAGE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

