/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.VitalsUpdateFrequency;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.event.NoOpEventMapper;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.thread.LoggingScheduledThreadPoolExecutor;
import com.datadog.android.core.internal.thread.NoOpScheduledExecutorService;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.MapperSerializer;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.anr.ANRDetectorRunnable;
import com.datadog.android.rum.internal.debug.UiRumDebugListener;
import com.datadog.android.rum.internal.domain.RumDataWriter;
import com.datadog.android.rum.internal.domain.event.RumEventSerializer;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.ndk.DatadogNdkCrashEventHandler;
import com.datadog.android.rum.internal.ndk.DatadogNdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashEventHandler;
import com.datadog.android.rum.internal.tracking.NoOpUserActionTrackingStrategy;
import com.datadog.android.rum.internal.tracking.UserActionTrackingStrategy;
import com.datadog.android.rum.internal.vitals.AggregatingVitalMonitor;
import com.datadog.android.rum.internal.vitals.CPUVitalReader;
import com.datadog.android.rum.internal.vitals.MemoryVitalReader;
import com.datadog.android.rum.internal.vitals.NoOpVitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalFrameCallback;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import com.datadog.android.rum.internal.vitals.VitalReader;
import com.datadog.android.rum.internal.vitals.VitalReaderRunnable;
import com.datadog.android.rum.tracking.NoOpTrackingStrategy;
import com.datadog.android.rum.tracking.NoOpViewTrackingStrategy;
import com.datadog.android.rum.tracking.TrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.v2.api.FeatureEventReceiver;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.datadog.android.v2.core.internal.storage.NoOpDataWriter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u008f\u00012\u00020\u0001:\u0002\u008f\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010q\u001a\u00020r2\u000e\u0010s\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030tH\u0002J\u0016\u0010u\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010v\u001a\u00020wH\u0002J\r\u0010x\u001a\u00020rH\u0000\u00a2\u0006\u0002\byJ\r\u0010z\u001a\u00020rH\u0000\u00a2\u0006\u0002\b{J\u0016\u0010|\u001a\u00020r2\u0006\u0010}\u001a\u00020\"2\u0006\u0010v\u001a\u00020wJ\b\u0010~\u001a\u00020rH\u0002J&\u0010\u007f\u001a\u00020r2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0013\u0010\u0086\u0001\u001a\u00020r2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0013\u0010\u0089\u0001\u001a\u00020r2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0012\u0010\u008a\u0001\u001a\u00020r2\u0007\u0010\u008b\u0001\u001a\u000205H\u0016J\u0011\u0010\u008c\u0001\u001a\u00020r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0007\u0010\u008d\u0001\u001a\u00020rJ\u0013\u0010\u008e\u0001\u001a\u00020r2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R \u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020.X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00100\"\u0004\bB\u00102R\u0014\u0010C\u001a\u00020DX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020HX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020.X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u00100\"\u0004\bO\u00102R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010P\u001a\b\u0012\u0004\u0012\u0002050QX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001a\u0010V\u001a\u00020WX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\\\u001a\u00020WX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010Y\"\u0004\b^\u0010[R\u001a\u0010_\u001a\u00020WX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010Y\"\u0004\ba\u0010[R\u001a\u0010b\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010*\"\u0004\bd\u0010,R\u001a\u0010e\u001a\u00020fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001a\u0010k\u001a\u00020lX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010p\u00a8\u0006\u0090\u0001"}, d2={"Lcom/datadog/android/rum/internal/RumFeature;", "Lcom/datadog/android/v2/api/FeatureEventReceiver;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "ndkCrashEventHandler", "Lcom/datadog/android/rum/internal/ndk/NdkCrashEventHandler;", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/core/internal/CoreFeature;Lcom/datadog/android/rum/internal/ndk/NdkCrashEventHandler;)V", "actionTrackingStrategy", "Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "getActionTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;", "setActionTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/tracking/UserActionTrackingStrategy;)V", "anrDetectorExecutorService", "Ljava/util/concurrent/ExecutorService;", "getAnrDetectorExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ExecutorService;", "setAnrDetectorExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ExecutorService;)V", "anrDetectorHandler", "Landroid/os/Handler;", "getAnrDetectorHandler$dd_sdk_android_release", "()Landroid/os/Handler;", "setAnrDetectorHandler$dd_sdk_android_release", "(Landroid/os/Handler;)V", "anrDetectorRunnable", "Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "getAnrDetectorRunnable$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "setAnrDetectorRunnable$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;)V", "appContext", "Landroid/content/Context;", "getAppContext$dd_sdk_android_release", "()Landroid/content/Context;", "setAppContext$dd_sdk_android_release", "(Landroid/content/Context;)V", "backgroundEventTracking", "", "getBackgroundEventTracking$dd_sdk_android_release", "()Z", "setBackgroundEventTracking$dd_sdk_android_release", "(Z)V", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "getCpuVitalMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "setCpuVitalMonitor$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/vitals/VitalMonitor;)V", "dataWriter", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "getDataWriter$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "setDataWriter$dd_sdk_android_release", "(Lcom/datadog/android/v2/core/internal/storage/DataWriter;)V", "debugActivityLifecycleListener", "Landroid/app/Application$ActivityLifecycleCallbacks;", "getDebugActivityLifecycleListener$dd_sdk_android_release", "()Landroid/app/Application$ActivityLifecycleCallbacks;", "setDebugActivityLifecycleListener$dd_sdk_android_release", "(Landroid/app/Application$ActivityLifecycleCallbacks;)V", "frameRateVitalMonitor", "getFrameRateVitalMonitor$dd_sdk_android_release", "setFrameRateVitalMonitor$dd_sdk_android_release", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "longTaskTrackingStrategy", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "getLongTaskTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/tracking/TrackingStrategy;", "setLongTaskTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/tracking/TrackingStrategy;)V", "memoryVitalMonitor", "getMemoryVitalMonitor$dd_sdk_android_release", "setMemoryVitalMonitor$dd_sdk_android_release", "rumEventMapper", "Lcom/datadog/android/event/EventMapper;", "getRumEventMapper$dd_sdk_android_release", "()Lcom/datadog/android/event/EventMapper;", "setRumEventMapper$dd_sdk_android_release", "(Lcom/datadog/android/event/EventMapper;)V", "samplingRate", "", "getSamplingRate$dd_sdk_android_release", "()F", "setSamplingRate$dd_sdk_android_release", "(F)V", "telemetryConfigurationSamplingRate", "getTelemetryConfigurationSamplingRate$dd_sdk_android_release", "setTelemetryConfigurationSamplingRate$dd_sdk_android_release", "telemetrySamplingRate", "getTelemetrySamplingRate$dd_sdk_android_release", "setTelemetrySamplingRate$dd_sdk_android_release", "trackFrustrations", "getTrackFrustrations$dd_sdk_android_release", "setTrackFrustrations$dd_sdk_android_release", "viewTrackingStrategy", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "getViewTrackingStrategy$dd_sdk_android_release", "()Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "setViewTrackingStrategy$dd_sdk_android_release", "(Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;)V", "vitalExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "getVitalExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ScheduledExecutorService;", "setVitalExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ScheduledExecutorService;)V", "addJvmCrash", "", "crashEvent", "", "createDataWriter", "configuration", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "disableDebugging", "disableDebugging$dd_sdk_android_release", "enableDebugging", "enableDebugging$dd_sdk_android_release", "initialize", "context", "initializeANRDetector", "initializeVitalMonitor", "vitalReader", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "vitalObserver", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "periodInMs", "", "initializeVitalMonitors", "frequency", "Lcom/datadog/android/core/configuration/VitalsUpdateFrequency;", "initializeVitalReaders", "onReceive", "event", "registerTrackingStrategies", "stop", "unregisterTrackingStrategies", "Companion", "dd-sdk-android_release"})
public final class RumFeature
implements FeatureEventReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final CoreFeature coreFeature;
    @NotNull
    private final NdkCrashEventHandler ndkCrashEventHandler;
    @NotNull
    private DataWriter<Object> dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    private float samplingRate;
    private float telemetrySamplingRate;
    private float telemetryConfigurationSamplingRate;
    private boolean backgroundEventTracking;
    private boolean trackFrustrations;
    @NotNull
    private ViewTrackingStrategy viewTrackingStrategy;
    @NotNull
    private UserActionTrackingStrategy actionTrackingStrategy;
    @NotNull
    private EventMapper<Object> rumEventMapper;
    @NotNull
    private TrackingStrategy longTaskTrackingStrategy;
    @NotNull
    private VitalMonitor cpuVitalMonitor;
    @NotNull
    private VitalMonitor memoryVitalMonitor;
    @NotNull
    private VitalMonitor frameRateVitalMonitor;
    @Nullable
    private Application.ActivityLifecycleCallbacks debugActivityLifecycleListener;
    @NotNull
    private ScheduledExecutorService vitalExecutorService;
    public ExecutorService anrDetectorExecutorService;
    public ANRDetectorRunnable anrDetectorRunnable;
    public Handler anrDetectorHandler;
    public Context appContext;
    private static final long startupTimeNs = System.nanoTime();
    @NotNull
    public static final String RUM_FEATURE_NAME = "rum";
    @NotNull
    public static final String VIEW_TIMESTAMP_OFFSET_IN_MS_KEY = "view_timestamp_offset";
    @NotNull
    public static final String UNSUPPORTED_EVENT_TYPE = "RUM feature receive an event of unsupported type=%s.";
    @NotNull
    public static final String UNKNOWN_EVENT_TYPE_PROPERTY_VALUE = "RUM feature received an event with unknown value of \"type\" property=%s.";
    @NotNull
    public static final String JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS = "RUM feature received a JVM crash event where one or more mandatory (throwable, message) fields are either missing or have wrong type.";

    public RumFeature(@NotNull SdkCore sdkCore, @NotNull CoreFeature coreFeature, @NotNull NdkCrashEventHandler ndkCrashEventHandler) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"coreFeature");
        Intrinsics.checkNotNullParameter((Object)ndkCrashEventHandler, (String)"ndkCrashEventHandler");
        this.sdkCore = sdkCore;
        this.coreFeature = coreFeature;
        this.ndkCrashEventHandler = ndkCrashEventHandler;
        this.dataWriter = new NoOpDataWriter();
        this.initialized = new AtomicBoolean(false);
        this.viewTrackingStrategy = new NoOpViewTrackingStrategy();
        this.actionTrackingStrategy = new NoOpUserActionTrackingStrategy();
        this.rumEventMapper = new NoOpEventMapper();
        this.longTaskTrackingStrategy = new NoOpTrackingStrategy();
        this.cpuVitalMonitor = new NoOpVitalMonitor();
        this.memoryVitalMonitor = new NoOpVitalMonitor();
        this.frameRateVitalMonitor = new NoOpVitalMonitor();
        this.vitalExecutorService = new NoOpScheduledExecutorService();
    }

    public /* synthetic */ RumFeature(SdkCore sdkCore, CoreFeature coreFeature, NdkCrashEventHandler ndkCrashEventHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ndkCrashEventHandler = new DatadogNdkCrashEventHandler(null, 1, null);
        }
        this(sdkCore, coreFeature, ndkCrashEventHandler);
    }

    @NotNull
    public final DataWriter<Object> getDataWriter$dd_sdk_android_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_release(@NotNull DataWriter<Object> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"<set-?>");
        this.dataWriter = dataWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final void setSamplingRate$dd_sdk_android_release(float f) {
        this.samplingRate = f;
    }

    public final float getTelemetrySamplingRate$dd_sdk_android_release() {
        return this.telemetrySamplingRate;
    }

    public final void setTelemetrySamplingRate$dd_sdk_android_release(float f) {
        this.telemetrySamplingRate = f;
    }

    public final float getTelemetryConfigurationSamplingRate$dd_sdk_android_release() {
        return this.telemetryConfigurationSamplingRate;
    }

    public final void setTelemetryConfigurationSamplingRate$dd_sdk_android_release(float f) {
        this.telemetryConfigurationSamplingRate = f;
    }

    public final boolean getBackgroundEventTracking$dd_sdk_android_release() {
        return this.backgroundEventTracking;
    }

    public final void setBackgroundEventTracking$dd_sdk_android_release(boolean bl) {
        this.backgroundEventTracking = bl;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_release() {
        return this.trackFrustrations;
    }

    public final void setTrackFrustrations$dd_sdk_android_release(boolean bl) {
        this.trackFrustrations = bl;
    }

    @NotNull
    public final ViewTrackingStrategy getViewTrackingStrategy$dd_sdk_android_release() {
        return this.viewTrackingStrategy;
    }

    public final void setViewTrackingStrategy$dd_sdk_android_release(@NotNull ViewTrackingStrategy viewTrackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)viewTrackingStrategy, (String)"<set-?>");
        this.viewTrackingStrategy = viewTrackingStrategy;
    }

    @NotNull
    public final UserActionTrackingStrategy getActionTrackingStrategy$dd_sdk_android_release() {
        return this.actionTrackingStrategy;
    }

    public final void setActionTrackingStrategy$dd_sdk_android_release(@NotNull UserActionTrackingStrategy userActionTrackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)userActionTrackingStrategy, (String)"<set-?>");
        this.actionTrackingStrategy = userActionTrackingStrategy;
    }

    @NotNull
    public final EventMapper<Object> getRumEventMapper$dd_sdk_android_release() {
        return this.rumEventMapper;
    }

    public final void setRumEventMapper$dd_sdk_android_release(@NotNull EventMapper<Object> eventMapper) {
        Intrinsics.checkNotNullParameter(eventMapper, (String)"<set-?>");
        this.rumEventMapper = eventMapper;
    }

    @NotNull
    public final TrackingStrategy getLongTaskTrackingStrategy$dd_sdk_android_release() {
        return this.longTaskTrackingStrategy;
    }

    public final void setLongTaskTrackingStrategy$dd_sdk_android_release(@NotNull TrackingStrategy trackingStrategy) {
        Intrinsics.checkNotNullParameter((Object)trackingStrategy, (String)"<set-?>");
        this.longTaskTrackingStrategy = trackingStrategy;
    }

    @NotNull
    public final VitalMonitor getCpuVitalMonitor$dd_sdk_android_release() {
        return this.cpuVitalMonitor;
    }

    public final void setCpuVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        this.cpuVitalMonitor = vitalMonitor;
    }

    @NotNull
    public final VitalMonitor getMemoryVitalMonitor$dd_sdk_android_release() {
        return this.memoryVitalMonitor;
    }

    public final void setMemoryVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        this.memoryVitalMonitor = vitalMonitor;
    }

    @NotNull
    public final VitalMonitor getFrameRateVitalMonitor$dd_sdk_android_release() {
        return this.frameRateVitalMonitor;
    }

    public final void setFrameRateVitalMonitor$dd_sdk_android_release(@NotNull VitalMonitor vitalMonitor) {
        Intrinsics.checkNotNullParameter((Object)vitalMonitor, (String)"<set-?>");
        this.frameRateVitalMonitor = vitalMonitor;
    }

    @Nullable
    public final Application.ActivityLifecycleCallbacks getDebugActivityLifecycleListener$dd_sdk_android_release() {
        return this.debugActivityLifecycleListener;
    }

    public final void setDebugActivityLifecycleListener$dd_sdk_android_release(@Nullable Application.ActivityLifecycleCallbacks activityLifecycleCallbacks) {
        this.debugActivityLifecycleListener = activityLifecycleCallbacks;
    }

    @NotNull
    public final ScheduledExecutorService getVitalExecutorService$dd_sdk_android_release() {
        return this.vitalExecutorService;
    }

    public final void setVitalExecutorService$dd_sdk_android_release(@NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"<set-?>");
        this.vitalExecutorService = scheduledExecutorService;
    }

    @NotNull
    public final ExecutorService getAnrDetectorExecutorService$dd_sdk_android_release() {
        ExecutorService executorService = this.anrDetectorExecutorService;
        if (executorService != null) {
            return executorService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorExecutorService");
        return null;
    }

    public final void setAnrDetectorExecutorService$dd_sdk_android_release(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        this.anrDetectorExecutorService = executorService;
    }

    @NotNull
    public final ANRDetectorRunnable getAnrDetectorRunnable$dd_sdk_android_release() {
        ANRDetectorRunnable aNRDetectorRunnable = this.anrDetectorRunnable;
        if (aNRDetectorRunnable != null) {
            return aNRDetectorRunnable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorRunnable");
        return null;
    }

    public final void setAnrDetectorRunnable$dd_sdk_android_release(@NotNull ANRDetectorRunnable aNRDetectorRunnable) {
        Intrinsics.checkNotNullParameter((Object)aNRDetectorRunnable, (String)"<set-?>");
        this.anrDetectorRunnable = aNRDetectorRunnable;
    }

    @NotNull
    public final Handler getAnrDetectorHandler$dd_sdk_android_release() {
        Handler handler = this.anrDetectorHandler;
        if (handler != null) {
            return handler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"anrDetectorHandler");
        return null;
    }

    public final void setAnrDetectorHandler$dd_sdk_android_release(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.anrDetectorHandler = handler;
    }

    @NotNull
    public final Context getAppContext$dd_sdk_android_release() {
        Context context = this.appContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        return null;
    }

    public final void setAppContext$dd_sdk_android_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.appContext = context;
    }

    public final void initialize(@NotNull Context context, @NotNull Configuration.Feature.RUM configuration) {
        TrackingStrategy it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.dataWriter = this.createDataWriter(configuration);
        this.samplingRate = configuration.getSamplingRate();
        this.telemetrySamplingRate = configuration.getTelemetrySamplingRate();
        this.telemetryConfigurationSamplingRate = configuration.getTelemetryConfigurationSamplingRate();
        this.backgroundEventTracking = configuration.getBackgroundEventTracking();
        this.trackFrustrations = configuration.getTrackFrustrations();
        this.rumEventMapper = configuration.getRumEventMapper();
        ViewTrackingStrategy viewTrackingStrategy = configuration.getViewTrackingStrategy();
        if (viewTrackingStrategy != null) {
            it = viewTrackingStrategy;
            boolean bl = false;
            this.setViewTrackingStrategy$dd_sdk_android_release((ViewTrackingStrategy)it);
        }
        UserActionTrackingStrategy userActionTrackingStrategy = configuration.getUserActionTrackingStrategy();
        if (userActionTrackingStrategy != null) {
            it = userActionTrackingStrategy;
            boolean bl = false;
            this.setActionTrackingStrategy$dd_sdk_android_release((UserActionTrackingStrategy)it);
        }
        TrackingStrategy trackingStrategy = configuration.getLongTaskTrackingStrategy();
        if (trackingStrategy != null) {
            it = trackingStrategy;
            boolean bl = false;
            this.setLongTaskTrackingStrategy$dd_sdk_android_release(it);
        }
        this.initializeVitalMonitors(configuration.getVitalsMonitorUpdateFrequency());
        this.initializeANRDetector();
        this.registerTrackingStrategies(context);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.setAppContext$dd_sdk_android_release(context2);
        this.sdkCore.setEventReceiver(RUM_FEATURE_NAME, this);
        this.initialized.set(true);
    }

    public final void stop() {
        this.sdkCore.removeEventReceiver(RUM_FEATURE_NAME);
        this.unregisterTrackingStrategies(this.getAppContext$dd_sdk_android_release());
        this.dataWriter = new NoOpDataWriter();
        this.viewTrackingStrategy = new NoOpViewTrackingStrategy();
        this.actionTrackingStrategy = new NoOpUserActionTrackingStrategy();
        this.longTaskTrackingStrategy = new NoOpTrackingStrategy();
        this.rumEventMapper = new NoOpEventMapper();
        this.cpuVitalMonitor = new NoOpVitalMonitor();
        this.memoryVitalMonitor = new NoOpVitalMonitor();
        this.frameRateVitalMonitor = new NoOpVitalMonitor();
        this.vitalExecutorService.shutdownNow();
        this.getAnrDetectorExecutorService$dd_sdk_android_release().shutdownNow();
        this.getAnrDetectorRunnable$dd_sdk_android_release().stop();
        this.vitalExecutorService = new NoOpScheduledExecutorService();
    }

    private final DataWriter<Object> createDataWriter(Configuration.Feature.RUM configuration) {
        return new RumDataWriter((Serializer<Object>)new MapperSerializer<Object>(configuration.getRumEventMapper(), new RumEventSerializer(null, 1, null)), BatchFileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.coreFeature.getLocalDataEncryption$dd_sdk_android_release()), RuntimeUtilsKt.getInternalLogger(), DatadogNdkCrashHandler.Companion.getLastViewEventFile$dd_sdk_android_release(this.coreFeature.getStorageDir$dd_sdk_android_release()));
    }

    @Override
    public void onReceive(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof Map)) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNSUPPORTED_EVENT_TYPE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getClass().getCanonicalName()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            return;
        }
        if (Intrinsics.areEqual(((Map)event).get("type"), (Object)"jvm_crash")) {
            this.addJvmCrash((Map)event);
        } else if (Intrinsics.areEqual(((Map)event).get("type"), (Object)"ndk_crash")) {
            this.ndkCrashEventHandler.handleEvent((Map)event, this.sdkCore, this.dataWriter);
        } else {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_EVENT_TYPE_PROPERTY_VALUE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{((Map)event).get("type")};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string3, null, 8, null);
        }
    }

    public final void enableDebugging$dd_sdk_android_release() {
        Context context = this.getAppContext$dd_sdk_android_release();
        if (context instanceof Application) {
            this.debugActivityLifecycleListener = new UiRumDebugListener();
            ((Application)context).registerActivityLifecycleCallbacks(this.debugActivityLifecycleListener);
        }
    }

    public final void disableDebugging$dd_sdk_android_release() {
        Context context = this.getAppContext$dd_sdk_android_release();
        if (this.debugActivityLifecycleListener != null && context instanceof Application) {
            ((Application)context).unregisterActivityLifecycleCallbacks(this.debugActivityLifecycleListener);
            this.debugActivityLifecycleListener = null;
        }
    }

    private final void registerTrackingStrategies(Context appContext) {
        this.actionTrackingStrategy.register(appContext);
        this.viewTrackingStrategy.register(appContext);
        this.longTaskTrackingStrategy.register(appContext);
    }

    private final void unregisterTrackingStrategies(Context appContext) {
        this.actionTrackingStrategy.unregister(appContext);
        this.viewTrackingStrategy.unregister(appContext);
        this.longTaskTrackingStrategy.unregister(appContext);
    }

    private final void initializeVitalMonitors(VitalsUpdateFrequency frequency) {
        if (frequency == VitalsUpdateFrequency.NEVER) {
            return;
        }
        this.cpuVitalMonitor = new AggregatingVitalMonitor();
        this.memoryVitalMonitor = new AggregatingVitalMonitor();
        this.frameRateVitalMonitor = new AggregatingVitalMonitor();
        this.initializeVitalReaders(frequency.getPeriodInMs$dd_sdk_android_release());
    }

    private final void initializeVitalReaders(long periodInMs) {
        this.vitalExecutorService = new LoggingScheduledThreadPoolExecutor(1, RuntimeUtilsKt.getInternalLogger());
        this.initializeVitalMonitor(new CPUVitalReader(null, 1, null), this.cpuVitalMonitor, periodInMs);
        this.initializeVitalMonitor(new MemoryVitalReader(null, 1, null), this.memoryVitalMonitor, periodInMs);
        VitalFrameCallback vitalFrameCallback2 = new VitalFrameCallback(this.frameRateVitalMonitor, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RumFeature this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getInitialized$dd_sdk_android_release().get();
            }
        }));
        try {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)vitalFrameCallback2);
        }
        catch (IllegalStateException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unable to initialize the Choreographer FrameCallback", (Throwable)e);
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "It seems you initialized the SDK on a thread without a Looper: we won't be able to track your Views' refresh rate.", null, 8, null);
        }
    }

    private final void initializeVitalMonitor(VitalReader vitalReader, VitalObserver vitalObserver, long periodInMs) {
        VitalReaderRunnable readerRunnable = new VitalReaderRunnable(this.sdkCore, vitalReader, vitalObserver, this.vitalExecutorService, periodInMs);
        ConcurrencyExtKt.scheduleSafe(this.vitalExecutorService, "Vitals monitoring", periodInMs, TimeUnit.MILLISECONDS, readerRunnable);
    }

    private final void initializeANRDetector() {
        this.setAnrDetectorHandler$dd_sdk_android_release(new Handler(Looper.getMainLooper()));
        this.setAnrDetectorRunnable$dd_sdk_android_release(new ANRDetectorRunnable(this.getAnrDetectorHandler$dd_sdk_android_release(), 0L, 0L, 6, null));
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.setAnrDetectorExecutorService$dd_sdk_android_release(executorService);
        ConcurrencyExtKt.executeSafe(this.getAnrDetectorExecutorService$dd_sdk_android_release(), "ANR detection", this.getAnrDetectorRunnable$dd_sdk_android_release());
    }

    private final void addJvmCrash(Map<?, ?> crashEvent) {
        String message;
        Object obj = crashEvent.get("throwable");
        Throwable throwable = obj instanceof Throwable ? (Throwable)obj : null;
        Object obj2 = crashEvent.get("message");
        String string = message = obj2 instanceof String ? (String)obj2 : null;
        if (throwable == null || message == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS, null, 8, null);
            return;
        }
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.addCrash(message, RumErrorSource.SOURCE, throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/RumFeature$Companion;", "", "()V", "JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS", "", "RUM_FEATURE_NAME", "UNKNOWN_EVENT_TYPE_PROPERTY_VALUE", "UNSUPPORTED_EVENT_TYPE", "VIEW_TIMESTAMP_OFFSET_IN_MS_KEY", "startupTimeNs", "", "getStartupTimeNs$dd_sdk_android_release", "()J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getStartupTimeNs$dd_sdk_android_release() {
            return startupTimeNs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

