/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.NoOpRumMonitor;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0007J\b\u0010\u0016\u001a\u00020\rH\u0007J\b\u0010\b\u001a\u00020\u0017H\u0007J\r\u0010\u0018\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0007R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/datadog/android/rum/GlobalRum;", "", "()V", "globalAttributes", "", "", "getGlobalAttributes$dd_sdk_android_release", "()Ljava/util/Map;", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRegistered$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "monitor", "Lcom/datadog/android/rum/RumMonitor;", "getMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/RumMonitor;", "setMonitor$dd_sdk_android_release", "(Lcom/datadog/android/rum/RumMonitor;)V", "addAttribute", "", "key", "value", "get", "", "notifyIngestedWebViewEvent", "notifyIngestedWebViewEvent$dd_sdk_android_release", "notifyInterceptorInstantiated", "notifyInterceptorInstantiated$dd_sdk_android_release", "registerIfAbsent", "provider", "Ljava/util/concurrent/Callable;", "removeAttribute", "dd-sdk-android_release"})
public final class GlobalRum {
    @NotNull
    public static final GlobalRum INSTANCE = new GlobalRum();
    @NotNull
    private static final Map<String, Object> globalAttributes = new ConcurrentHashMap();
    @NotNull
    private static final AtomicBoolean isRegistered = new AtomicBoolean(false);
    @NotNull
    private static RumMonitor monitor = new NoOpRumMonitor();

    private GlobalRum() {
    }

    @NotNull
    public final Map<String, Object> getGlobalAttributes$dd_sdk_android_release() {
        return globalAttributes;
    }

    @NotNull
    public final AtomicBoolean isRegistered$dd_sdk_android_release() {
        return isRegistered;
    }

    @NotNull
    public final RumMonitor getMonitor$dd_sdk_android_release() {
        return monitor;
    }

    public final void setMonitor$dd_sdk_android_release(@NotNull RumMonitor rumMonitor) {
        Intrinsics.checkNotNullParameter((Object)rumMonitor, (String)"<set-?>");
        monitor = rumMonitor;
    }

    @JvmStatic
    public static final boolean isRegistered() {
        return isRegistered.get();
    }

    @JvmStatic
    public static final boolean registerIfAbsent(@NotNull RumMonitor monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        return GlobalRum.registerIfAbsent(() -> GlobalRum.registerIfAbsent$lambda-0(monitor));
    }

    @JvmStatic
    public static final boolean registerIfAbsent(@NotNull Callable<RumMonitor> provider) {
        boolean bl;
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (isRegistered.get()) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "RumMonitor has already been registered", null, 8, null);
            bl = false;
        } else if (isRegistered.compareAndSet(false, true)) {
            RumMonitor rumMonitor = provider.call();
            Intrinsics.checkNotNullExpressionValue((Object)rumMonitor, (String)"provider.call()");
            monitor = rumMonitor;
            bl = true;
        } else {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "Unable to register the RumMonitor", null, 8, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final RumMonitor get() {
        return monitor;
    }

    @JvmStatic
    public static final void addAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            globalAttributes.remove(key);
        } else {
            globalAttributes.put(key, value);
        }
    }

    @JvmStatic
    public static final void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        globalAttributes.remove(key);
    }

    public final void notifyIngestedWebViewEvent$dd_sdk_android_release() {
        RumMonitor rumMonitor = monitor;
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.sendWebViewEvent();
        }
    }

    public final void notifyInterceptorInstantiated$dd_sdk_android_release() {
        RumMonitor rumMonitor = monitor;
        AdvancedRumMonitor advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor2 != null) {
            advancedRumMonitor2.notifyInterceptorInstantiated();
        }
    }

    private static final RumMonitor registerIfAbsent$lambda-0(RumMonitor $monitor) {
        Intrinsics.checkNotNullParameter((Object)$monitor, (String)"$monitor");
        return $monitor;
    }
}

