/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.telemetry.internal.Telemetry;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Ji\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015JU\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/log/internal/logger/TelemetryLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "telemetry", "Lcom/datadog/android/telemetry/internal/Telemetry;", "(Lcom/datadog/android/telemetry/internal/Telemetry;)V", "handleLog", "", "level", "", "message", "", "errorKind", "errorMessage", "errorStacktrace", "attributes", "", "", "tags", "", "timestamp", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "throwable", "", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "dd-sdk-android_release"})
public final class TelemetryLogHandler
implements LogHandler {
    @NotNull
    private final Telemetry telemetry;

    public TelemetryLogHandler(@NotNull Telemetry telemetry) {
        Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
        this.telemetry = telemetry;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        switch (level) {
            case 5: 
            case 6: {
                this.telemetry.error(message, throwable);
                break;
            }
            default: {
                this.telemetry.debug(message);
            }
        }
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        switch (level) {
            case 5: 
            case 6: {
                this.telemetry.error(message, errorStacktrace, errorKind);
                break;
            }
            default: {
                this.telemetry.debug(message);
            }
        }
    }
}

