/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import android.os.Build;
import android.util.Log;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.logger.CombinedLogHandler;
import com.datadog.android.log.internal.logger.ConditionalLogHandler;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0014Ji\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$JU\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010&2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010*\u001a\u00020\u00032\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006,"}, d2={"Lcom/datadog/android/log/internal/logger/LogcatLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "serviceName", "", "useClassnameAsTag", "", "isDebug", "(Ljava/lang/String;ZZ)V", "isDebug$dd_sdk_android_release", "()Z", "getServiceName$dd_sdk_android_release", "()Ljava/lang/String;", "getUseClassnameAsTag$dd_sdk_android_release", "findValidCallStackElement", "Ljava/lang/StackTraceElement;", "stackTrace", "", "findValidCallStackElement$dd_sdk_android_release", "([Ljava/lang/StackTraceElement;)Ljava/lang/StackTraceElement;", "getCallerStackElement", "getCallerStackElement$dd_sdk_android_release", "handleLog", "", "level", "", "message", "errorKind", "errorMessage", "errorStacktrace", "attributes", "", "", "tags", "", "timestamp", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "throwable", "", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "resolveSuffix", "stackTraceElement", "resolveTag", "Companion", "dd-sdk-android_release"})
public final class LogcatLogHandler
implements LogHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serviceName;
    private final boolean useClassnameAsTag;
    private final boolean isDebug;
    private static final int MAX_TAG_LENGTH = 23;
    @NotNull
    private static final Regex ANONYMOUS_CLASS = new Regex("(\\$\\d+)+$");
    @NotNull
    private static final String[] IGNORED_CLASS_NAMES;
    @NotNull
    private static final String[] IGNORED_PACKAGE_PREFIXES;

    public LogcatLogHandler(@NotNull String serviceName, boolean useClassnameAsTag, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.serviceName = serviceName;
        this.useClassnameAsTag = useClassnameAsTag;
        this.isDebug = isDebug;
    }

    public /* synthetic */ LogcatLogHandler(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(string, bl, bl2);
    }

    @NotNull
    public final String getServiceName$dd_sdk_android_release() {
        return this.serviceName;
    }

    public final boolean getUseClassnameAsTag$dd_sdk_android_release() {
        return this.useClassnameAsTag;
    }

    public final boolean isDebug$dd_sdk_android_release() {
        return this.isDebug;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        StackTraceElement stackElement = this.getCallerStackElement$dd_sdk_android_release();
        String tag = this.resolveTag(stackElement);
        String suffix = this.resolveSuffix(stackElement);
        Log.println((int)level, (String)tag, (String)(message + suffix));
        if (throwable != null) {
            Log.println((int)level, (String)tag, (String)Log.getStackTraceString((Throwable)throwable));
        }
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        StackTraceElement stackElement = this.getCallerStackElement$dd_sdk_android_release();
        String tag = this.resolveTag(stackElement);
        String suffix = this.resolveSuffix(stackElement);
        Log.println((int)level, (String)tag, (String)(message + suffix));
        if (errorStacktrace != null) {
            Log.println((int)level, (String)tag, (String)errorStacktrace);
        }
    }

    private final String resolveTag(StackTraceElement stackTraceElement) {
        String string;
        String tag;
        String string2;
        if (stackTraceElement == null) {
            string2 = this.serviceName;
        } else {
            CharSequence charSequence = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"stackTraceElement.className");
            charSequence = charSequence;
            Regex regex = ANONYMOUS_CLASS;
            String string3 = "";
            string2 = tag = StringsKt.substringAfterLast$default((String)regex.replace(charSequence, string3), (char)'.', null, (int)2, null);
        }
        if (tag.length() >= 23 && Build.VERSION.SDK_INT < 24) {
            String string4 = tag.substring(0, 23);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4;
        } else {
            string = tag;
        }
        return string;
    }

    private final String resolveSuffix(StackTraceElement stackTraceElement) {
        return stackTraceElement == null ? "" : "\t| at ." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
    }

    @Nullable
    public final StackTraceElement getCallerStackElement$dd_sdk_android_release() {
        if (this.isDebug && this.useClassnameAsTag) {
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            return this.findValidCallStackElement$dd_sdk_android_release(stackTrace);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final StackTraceElement findValidCallStackElement$dd_sdk_android_release(@NotNull StackTraceElement[] stackTrace) {
        StackTraceElement element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        StackTraceElement[] $this$firstOrNull$iv = stackTrace;
        boolean $i$f$firstOrNull = false;
        StackTraceElement[] stackTraceElementArray = $this$firstOrNull$iv;
        int n = 0;
        int n2 = stackTraceElementArray.length;
        do {
            if (n >= n2) return null;
            element$iv = stackTraceElementArray[n];
            ++n;
            StackTraceElement element = element$iv;
            boolean bl2 = false;
            if (!ArraysKt.contains((Object[])IGNORED_CLASS_NAMES, (Object)element.getClassName())) {
                boolean bl3;
                block4: {
                    String[] $this$none$iv = IGNORED_PACKAGE_PREFIXES;
                    boolean $i$f$none = false;
                    for (String element$iv2 : $this$none$iv) {
                        String it = element$iv2;
                        boolean bl4 = false;
                        String string = element.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.className");
                        if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                        bl3 = false;
                        break block4;
                    }
                    bl3 = true;
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        StackTraceElement stackTraceElement = element$iv;
        return stackTraceElement;
    }

    static {
        String[] stringArray = new String[7];
        stringArray[0] = Logger.class.getCanonicalName();
        stringArray[1] = LogHandler.class.getCanonicalName();
        String string = LogHandler.class.getCanonicalName();
        stringArray[2] = string == null ? null : string + "$DefaultImpls";
        stringArray[3] = LogcatLogHandler.class.getCanonicalName();
        stringArray[4] = ConditionalLogHandler.class.getCanonicalName();
        stringArray[5] = CombinedLogHandler.class.getCanonicalName();
        stringArray[6] = DatadogLogHandler.class.getCanonicalName();
        IGNORED_CLASS_NAMES = stringArray;
        stringArray = new String[]{"com.datadog.android.timber", "timber.log"};
        IGNORED_PACKAGE_PREFIXES = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/log/internal/logger/LogcatLogHandler$Companion;", "", "()V", "ANONYMOUS_CLASS", "Lkotlin/text/Regex;", "IGNORED_CLASS_NAMES", "", "", "getIGNORED_CLASS_NAMES$dd_sdk_android_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "IGNORED_PACKAGE_PREFIXES", "getIGNORED_PACKAGE_PREFIXES$dd_sdk_android_release", "MAX_TAG_LENGTH", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getIGNORED_CLASS_NAMES$dd_sdk_android_release() {
            return IGNORED_CLASS_NAMES;
        }

        @NotNull
        public final String[] getIGNORED_PACKAGE_PREFIXES$dd_sdk_android_release() {
            return IGNORED_PACKAGE_PREFIXES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

