/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal;

import androidx.annotation.AnyThread;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.MapperSerializer;
import com.datadog.android.log.internal.domain.DatadogLogGenerator;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.domain.event.LogEventMapperWrapper;
import com.datadog.android.log.internal.domain.event.LogEventSerializer;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureEventReceiver;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.datadog.android.v2.core.internal.storage.NoOpDataWriter;
import com.datadog.android.v2.log.internal.storage.LogsDataWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\u00020\u00162\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0002J\r\u0010 \u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b!R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/datadog/android/log/internal/LogsFeature;", "Lcom/datadog/android/v2/api/FeatureEventReceiver;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "(Lcom/datadog/android/v2/api/SdkCore;)V", "dataWriter", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "getDataWriter$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "setDataWriter$dd_sdk_android_release", "(Lcom/datadog/android/v2/core/internal/storage/DataWriter;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "logGenerator", "Lcom/datadog/android/log/internal/domain/DatadogLogGenerator;", "createDataWriter", "configuration", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "initialize", "", "initialize$dd_sdk_android_release", "onReceive", "event", "", "sendJvmCrashLog", "data", "", "sendNdkCrashLog", "sendSpanLog", "stop", "stop$dd_sdk_android_release", "Companion", "dd-sdk-android_release"})
public final class LogsFeature
implements FeatureEventReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private DataWriter<LogEvent> dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final DatadogLogGenerator logGenerator;
    @NotNull
    private static final String TYPE_EVENT_KEY = "type";
    @NotNull
    private static final String TIMESTAMP_EVENT_KEY = "timestamp";
    @NotNull
    private static final String LOGGER_NAME_EVENT_KEY = "loggerName";
    @NotNull
    private static final String ATTRIBUTES_EVENT_KEY = "attributes";
    @NotNull
    private static final String MESSAGE_EVENT_KEY = "message";
    @NotNull
    private static final String THROWABLE_EVENT_KEY = "throwable";
    @NotNull
    private static final String USER_INFO_EVENT_KEY = "userInfo";
    @NotNull
    private static final String NETWORK_INFO_EVENT_KEY = "networkInfo";
    @NotNull
    private static final String THREAD_NAME_EVENT_KEY = "threadName";
    @NotNull
    public static final String LOGS_FEATURE_NAME = "logs";
    @NotNull
    public static final String UNSUPPORTED_EVENT_TYPE = "Logs feature receive an event of unsupported type=%s.";
    @NotNull
    public static final String UNKNOWN_EVENT_TYPE_PROPERTY_VALUE = "Logs feature received an event with unknown value of \"type\" property=%s.";
    @NotNull
    public static final String JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING = "Logs feature received a JVM crash event where one or more mandatory (loggerName, throwable, message, timestamp, threadName) fields are either missing or have wrong type.";
    @NotNull
    public static final String NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING = "Logs feature received a NDK crash event where one or more mandatory (loggerName, message, timestamp, attributes) fields are either missing or have wrong type.";
    @NotNull
    public static final String SPAN_LOG_EVENT_MISSING_MANDATORY_FIELDS_WARNING = "Logs feature received a Span log event where one or more mandatory (loggerName, message, timestamp, attributes) fields are either missing or have wrong type.";
    public static final long MAX_WRITE_WAIT_TIMEOUT_MS = 500L;

    public LogsFeature(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
        this.dataWriter = new NoOpDataWriter();
        this.initialized = new AtomicBoolean(false);
        this.logGenerator = new DatadogLogGenerator(null, 1, null);
    }

    @NotNull
    public final DataWriter<LogEvent> getDataWriter$dd_sdk_android_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_release(@NotNull DataWriter<LogEvent> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"<set-?>");
        this.dataWriter = dataWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    public final void initialize$dd_sdk_android_release(@NotNull Configuration.Feature.Logs configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.sdkCore.setEventReceiver(LOGS_FEATURE_NAME, this);
        this.dataWriter = this.createDataWriter(configuration);
        this.initialized.set(true);
    }

    public final void stop$dd_sdk_android_release() {
        this.sdkCore.removeEventReceiver(LOGS_FEATURE_NAME);
        this.dataWriter = new NoOpDataWriter();
        this.initialized.set(false);
    }

    @Override
    @AnyThread
    public void onReceive(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof Map)) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNSUPPORTED_EVENT_TYPE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getClass().getCanonicalName()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
            return;
        }
        if (Intrinsics.areEqual(((Map)event).get(TYPE_EVENT_KEY), (Object)"jvm_crash")) {
            this.sendJvmCrashLog((Map)event);
        } else if (Intrinsics.areEqual(((Map)event).get(TYPE_EVENT_KEY), (Object)"ndk_crash")) {
            this.sendNdkCrashLog((Map)event);
        } else if (Intrinsics.areEqual(((Map)event).get(TYPE_EVENT_KEY), (Object)"span_log")) {
            this.sendSpanLog((Map)event);
        } else {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_EVENT_TYPE_PROPERTY_VALUE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{((Map)event).get(TYPE_EVENT_KEY)};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string3, null, 8, null);
        }
    }

    private final DataWriter<LogEvent> createDataWriter(Configuration.Feature.Logs configuration) {
        return new LogsDataWriter(new MapperSerializer(new LogEventMapperWrapper(configuration.getLogsEventMapper()), new LogEventSerializer(null, 1, null)), RuntimeUtilsKt.getInternalLogger());
    }

    private final void sendJvmCrashLog(Map<?, ?> data) {
        String loggerName;
        Object obj = data.get(THREAD_NAME_EVENT_KEY);
        String threadName = obj instanceof String ? (String)obj : null;
        Object obj2 = data.get(THROWABLE_EVENT_KEY);
        Throwable throwable = obj2 instanceof Throwable ? (Throwable)obj2 : null;
        Object obj3 = data.get(TIMESTAMP_EVENT_KEY);
        Long timestamp = obj3 instanceof Long ? (Long)obj3 : null;
        Object obj4 = data.get(MESSAGE_EVENT_KEY);
        String message = obj4 instanceof String ? (String)obj4 : null;
        Object obj5 = data.get(LOGGER_NAME_EVENT_KEY);
        String string = loggerName = obj5 instanceof String ? (String)obj5 : null;
        if (threadName == null || throwable == null || timestamp == null || message == null || loggerName == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING, null, 8, null);
            return;
        }
        CountDownLatch lock = new CountDownLatch(1);
        FeatureScope featureScope = this.sdkCore.getFeature(LOGS_FEATURE_NAME);
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, message, throwable, timestamp, threadName, loggerName, lock){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Throwable $throwable;
                final /* synthetic */ Long $timestamp;
                final /* synthetic */ String $threadName;
                final /* synthetic */ String $loggerName;
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$throwable = $throwable;
                    this.$timestamp = $timestamp;
                    this.$threadName = $threadName;
                    this.$loggerName = $loggerName;
                    this.$lock = $lock;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    Map map = MapsKt.emptyMap();
                    Set set = SetsKt.emptySet();
                    LogEvent log = datadogLogGenerator.generateLog(9, this.$message, this.$throwable, map, set, this.$timestamp, this.$threadName, datadogContext, true, this.$loggerName, true, true, null, null);
                    this.this$0.getDataWriter$dd_sdk_android_release().write(eventBatchWriter, log);
                    this.$lock.countDown();
                }
            }, 1, null);
        }
        try {
            lock.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Log event write operation wait was interrupted.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendNdkCrashLog(Map<?, ?> data) {
        UserInfo userInfo;
        Object object;
        Map map;
        Map map2;
        Object obj = data.get(TIMESTAMP_EVENT_KEY);
        Long timestamp = obj instanceof Long ? (Long)obj : null;
        Object obj2 = data.get(MESSAGE_EVENT_KEY);
        String message = obj2 instanceof String ? (String)obj2 : null;
        Object obj3 = data.get(LOGGER_NAME_EVENT_KEY);
        String loggerName = obj3 instanceof String ? (String)obj3 : null;
        Object object2 = data.get(ATTRIBUTES_EVENT_KEY);
        Map map3 = map2 = object2 instanceof Map ? (Map)object2 : null;
        if (map2 == null) {
            map = null;
        } else {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Object $this$filterKeys$iv;
            object = map2;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                Object it = entry$iv.getKey();
                boolean bl = false;
                if (!(it instanceof String)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = object2 = (Map)result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                if (k == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = (String)k;
                Map map5 = map4;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map5.put(string, entry);
            }
            map = destination$iv$iv;
        }
        Map attributes = map;
        object2 = data.get(NETWORK_INFO_EVENT_KEY);
        NetworkInfo networkInfo = object2 instanceof NetworkInfo ? (NetworkInfo)object2 : null;
        object = data.get(USER_INFO_EVENT_KEY);
        UserInfo userInfo2 = userInfo = object instanceof UserInfo ? (UserInfo)object : null;
        if (loggerName == null || message == null || timestamp == null || attributes == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING, null, 8, null);
            return;
        }
        object = this.sdkCore.getFeature(LOGS_FEATURE_NAME);
        if (object != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)object, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, message, attributes, timestamp, loggerName, userInfo, networkInfo){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ Long $timestamp;
                final /* synthetic */ String $loggerName;
                final /* synthetic */ UserInfo $userInfo;
                final /* synthetic */ NetworkInfo $networkInfo;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$attributes = $attributes;
                    this.$timestamp = $timestamp;
                    this.$loggerName = $loggerName;
                    this.$userInfo = $userInfo;
                    this.$networkInfo = $networkInfo;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    String string = Thread.currentThread().getName();
                    Set set = SetsKt.emptySet();
                    long l = this.$timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    LogEvent log = datadogLogGenerator.generateLog(9, this.$message, null, this.$attributes, set, l, string, datadogContext, true, this.$loggerName, false, false, this.$userInfo, this.$networkInfo);
                    this.this$0.getDataWriter$dd_sdk_android_release().write(eventBatchWriter, log);
                }
            }, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendSpanLog(Map<?, ?> data) {
        Map map;
        Object object;
        Object obj = data.get(TIMESTAMP_EVENT_KEY);
        Long timestamp = obj instanceof Long ? (Long)obj : null;
        Object obj2 = data.get(MESSAGE_EVENT_KEY);
        String message = obj2 instanceof String ? (String)obj2 : null;
        Object obj3 = data.get(LOGGER_NAME_EVENT_KEY);
        String loggerName = obj3 instanceof String ? (String)obj3 : null;
        Object object2 = data.get(ATTRIBUTES_EVENT_KEY);
        Object object3 = object = object2 instanceof Map ? (Map)object2 : null;
        if (object == null) {
            map = null;
        } else {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Object $this$filterKeys$iv;
            Map map2 = object;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                Object it = entry$iv.getKey();
                boolean bl = false;
                if (!(it instanceof String)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = object2 = (Map)result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                if (k == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = (String)k;
                Map map4 = map3;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map4.put(string, entry);
            }
            map = destination$iv$iv;
        }
        Map attributes = map;
        if (loggerName == null || message == null || attributes == null || timestamp == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, SPAN_LOG_EVENT_MISSING_MANDATORY_FIELDS_WARNING, null, 8, null);
            return;
        }
        object = this.sdkCore.getFeature(LOGS_FEATURE_NAME);
        if (object != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)object, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, message, attributes, timestamp, loggerName){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ Long $timestamp;
                final /* synthetic */ String $loggerName;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$attributes = $attributes;
                    this.$timestamp = $timestamp;
                    this.$loggerName = $loggerName;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    String string = Thread.currentThread().getName();
                    Set set = SetsKt.emptySet();
                    LogGenerator logGenerator = datadogLogGenerator;
                    long l = this.$timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    LogEvent log = LogGenerator.DefaultImpls.generateLog$default(logGenerator, 2, this.$message, null, this.$attributes, set, l, string, datadogContext, true, this.$loggerName, false, true, null, null, 12288, null);
                    this.this$0.getDataWriter$dd_sdk_android_release().write(eventBatchWriter, log);
                }
            }, 1, null);
        }
    }

    public static final /* synthetic */ DatadogLogGenerator access$getLogGenerator$p(LogsFeature $this) {
        return $this.logGenerator;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/log/internal/LogsFeature$Companion;", "", "()V", "ATTRIBUTES_EVENT_KEY", "", "JVM_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING", "LOGGER_NAME_EVENT_KEY", "LOGS_FEATURE_NAME", "MAX_WRITE_WAIT_TIMEOUT_MS", "", "MESSAGE_EVENT_KEY", "NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING", "NETWORK_INFO_EVENT_KEY", "SPAN_LOG_EVENT_MISSING_MANDATORY_FIELDS_WARNING", "THREAD_NAME_EVENT_KEY", "THROWABLE_EVENT_KEY", "TIMESTAMP_EVENT_KEY", "TYPE_EVENT_KEY", "UNKNOWN_EVENT_TYPE_PROPERTY_VALUE", "UNSUPPORTED_EVENT_TYPE", "USER_INFO_EVENT_KEY", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

