/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log;

import androidx.annotation.FloatRange;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.log.internal.domain.DatadogLogGenerator;
import com.datadog.android.log.internal.logger.CombinedLogHandler;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.internal.logger.LogcatLogHandler;
import com.datadog.android.log.internal.logger.NoOpLogHandler;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0002>?B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0018J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0019J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001aJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J4\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J4\u0010%\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J4\u0010&\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J_\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0004\b.\u0010/JK\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010#2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0004\b.\u00100JN\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J<\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J\u000e\u00103\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u00104\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0007J\u0010\u00105\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u000e\u00106\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u001a\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u001c\u00108\u001a\u00020\u00102\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160:H\u0002J4\u0010;\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J4\u0010<\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007J4\u0010=\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00072\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0007R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006@"}, d2={"Lcom/datadog/android/log/Logger;", "", "handler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "(Lcom/datadog/android/log/internal/logger/LogHandler;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getHandler$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/logger/LogHandler;", "setHandler$dd_sdk_android_release", "tags", "Ljava/util/concurrent/CopyOnWriteArraySet;", "getTags$dd_sdk_android_release", "()Ljava/util/concurrent/CopyOnWriteArraySet;", "addAttribute", "", "key", "value", "Lcom/google/gson/JsonArray;", "Lcom/google/gson/JsonObject;", "Ljava/util/Date;", "", "", "", "", "", "Lorg/json/JSONArray;", "Lorg/json/JSONObject;", "addTag", "tag", "addTagInternal", "d", "message", "throwable", "", "", "e", "i", "internalLog", "level", "errorKind", "errorMessage", "errorStacktrace", "localAttributes", "timestamp", "internalLog$dd_sdk_android_release", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Long;)V", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/lang/Long;)V", "log", "priority", "removeAttribute", "removeTag", "removeTagInternal", "removeTagsWithKey", "safelyAddAttribute", "safelyRemoveTagsWithKey", "keyFilter", "Lkotlin/Function1;", "v", "w", "wtf", "Builder", "Companion", "dd-sdk-android_release"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LogHandler handler;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    @NotNull
    private final CopyOnWriteArraySet<String> tags;
    @NotNull
    public static final String SDK_NOT_INITIALIZED_WARNING_MESSAGE = "You're trying to create a Logger instance, but the SDK was not yet initialized. This Logger will not be able to send any messages. Please initialize the Datadog SDK first before creating a new Logger instance.";

    public Logger(@NotNull LogHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.attributes = new ConcurrentHashMap();
        this.tags = new CopyOnWriteArraySet();
    }

    @NotNull
    public final LogHandler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    public final void setHandler$dd_sdk_android_release(@NotNull LogHandler logHandler) {
        Intrinsics.checkNotNullParameter((Object)logHandler, (String)"<set-?>");
        this.handler = logHandler;
    }

    @NotNull
    public final CopyOnWriteArraySet<String> getTags$dd_sdk_android_release() {
        return this.tags;
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 2, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void v$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.v(string, throwable, map);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 3, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void d$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.d(string, throwable, map);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 4, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void i$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.i(string, throwable, map);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 5, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void w$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.w(string, throwable, map);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 6, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void e$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.e(string, throwable, map);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 7, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void wtf$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.wtf(string, throwable, map);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, priority, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void log$default(Logger logger, int n, String string, Throwable throwable, Map map, int n2, Object object) {
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        if ((n2 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.log(n, string, throwable, map);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, priority, message, errorKind, errorMessage, errorStacktrace, attributes, null, 64, null);
    }

    public static /* synthetic */ void log$default(Logger logger, int n, String string, String string2, String string3, String string4, Map map, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.log(n, string, string2, string3, string4, map);
    }

    public final void addAttribute(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Boolean bl = value;
        map.put(key, bl);
    }

    public final void addAttribute(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Integer n = value;
        map.put(key, n);
    }

    public final void addAttribute(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Long l = value;
        map.put(key, l);
    }

    public final void addAttribute(@NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Float f = Float.valueOf(value);
        map.put(key, f);
    }

    public final void addAttribute(@NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Double d = value;
        map.put(key, d);
    }

    public final void addAttribute(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable Date value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JsonObject value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JsonArray value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JSONObject value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JSONArray value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.attributes.remove(key);
    }

    public final void addTag(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addTagInternal(key + ":" + value);
    }

    public final void addTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.addTagInternal(tag);
    }

    public final void removeTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.removeTagInternal(tag);
    }

    public final void removeTagsWithKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String prefix = key + ":";
        this.safelyRemoveTagsWithKey((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }));
    }

    public final void internalLog$dd_sdk_android_release(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> localAttributes, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(localAttributes, (String)"localAttributes");
        Map combinedAttributes = new LinkedHashMap();
        combinedAttributes.putAll((Map)this.attributes);
        combinedAttributes.putAll(localAttributes);
        HashSet tagsSnapshot = new HashSet(this.tags);
        this.handler.handleLog(level, message, throwable, combinedAttributes, tagsSnapshot, timestamp);
    }

    public static /* synthetic */ void internalLog$dd_sdk_android_release$default(Logger logger, int n, String string, Throwable throwable, Map map, Long l, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            l = null;
        }
        logger.internalLog$dd_sdk_android_release(n, string, throwable, map, l);
    }

    public final void internalLog$dd_sdk_android_release(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> localAttributes, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(localAttributes, (String)"localAttributes");
        Map combinedAttributes = new LinkedHashMap();
        combinedAttributes.putAll((Map)this.attributes);
        combinedAttributes.putAll(localAttributes);
        HashSet tagsSnapshot = new HashSet(this.tags);
        this.handler.handleLog(level, message, errorKind, errorMessage, errorStacktrace, combinedAttributes, tagsSnapshot, timestamp);
    }

    public static /* synthetic */ void internalLog$dd_sdk_android_release$default(Logger logger, int n, String string, String string2, String string3, String string4, Map map, Long l, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            l = null;
        }
        logger.internalLog$dd_sdk_android_release(n, string, string2, string3, string4, map, l);
    }

    private final void addTagInternal(String tag) {
        this.tags.add(tag);
    }

    private final void removeTagInternal(String tag) {
        this.tags.remove(tag);
    }

    private final void safelyAddAttribute(String key, Object value) {
        Object object = value;
        if (object == null) {
            object = MapUtilsKt.getNULL_MAP_VALUE();
        }
        Object attributeValue = object;
        ((Map)this.attributes).put(key, attributeValue);
    }

    /*
     * WARNING - void declaration
     */
    private final void safelyRemoveTagsWithKey(Function1<? super String, Boolean> keyFilter) {
        void $this$filterTo$iv$iv;
        String[] $this$toTypedArray$iv = (String[])this.tags;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        thisCollection$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keyFilter.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        this.tags.removeAll(toRemove);
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void v(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, throwable, null, 8, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, null, null, 12, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, errorKind, errorMessage, errorStacktrace, null, 32, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010%\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/datadog/android/log/Logger$Builder;", "", "()V", "bundleWithRumEnabled", "", "bundleWithTraceEnabled", "datadogLogsEnabled", "logcatLogsEnabled", "loggerName", "", "minDatadogLogsPriority", "", "networkInfoEnabled", "sampleRate", "", "serviceName", "build", "Lcom/datadog/android/log/Logger;", "buildDatadogHandler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "logsFeature", "Lcom/datadog/android/log/internal/LogsFeature;", "buildLogcatHandler", "setBundleWithRumEnabled", "enabled", "setBundleWithTraceEnabled", "setDatadogLogsEnabled", "setDatadogLogsMinPriority", "minLogPriority", "setLogcatLogsEnabled", "setLoggerName", "name", "setNetworkInfoEnabled", "setSampleRate", "rate", "setServiceName", "dd-sdk-android_release"})
    public static final class Builder {
        @Nullable
        private String serviceName;
        @Nullable
        private String loggerName;
        private boolean datadogLogsEnabled = true;
        private boolean logcatLogsEnabled;
        private boolean networkInfoEnabled;
        private boolean bundleWithTraceEnabled = true;
        private boolean bundleWithRumEnabled = true;
        private float sampleRate = 1.0f;
        private int minDatadogLogsPriority = -1;

        @NotNull
        public final Logger build() {
            LogHandler logHandler;
            DatadogCore datadogCore;
            SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
            DatadogCore datadogCore2 = datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
            CoreFeature coreFeature = datadogCore2 == null ? null : datadogCore2.getCoreFeature$dd_sdk_android_release();
            DatadogCore datadogCore3 = datadogCore;
            LogsFeature logsFeature = datadogCore3 == null ? null : datadogCore3.getLogsFeature$dd_sdk_android_release();
            if (this.datadogLogsEnabled && this.logcatLogsEnabled) {
                LogHandler[] logHandlerArray = new LogHandler[]{this.buildDatadogHandler(datadogCore, coreFeature, logsFeature), this.buildLogcatHandler(coreFeature)};
                logHandler = new CombinedLogHandler(logHandlerArray);
            } else {
                logHandler = this.datadogLogsEnabled ? this.buildDatadogHandler(datadogCore, coreFeature, logsFeature) : (this.logcatLogsEnabled ? this.buildLogcatHandler(coreFeature) : (LogHandler)new NoOpLogHandler());
            }
            LogHandler handler = logHandler;
            return new Logger(handler);
        }

        @NotNull
        public final Builder setServiceName(@NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @NotNull
        public final Builder setDatadogLogsEnabled(boolean enabled) {
            this.datadogLogsEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setDatadogLogsMinPriority(int minLogPriority) {
            this.minDatadogLogsPriority = minLogPriority;
            return this;
        }

        @NotNull
        public final Builder setLogcatLogsEnabled(boolean enabled) {
            this.logcatLogsEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setNetworkInfoEnabled(boolean enabled) {
            this.networkInfoEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setLoggerName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.loggerName = name;
            return this;
        }

        @NotNull
        public final Builder setBundleWithTraceEnabled(boolean enabled) {
            this.bundleWithTraceEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setSampleRate(@FloatRange(from=0.0, to=1.0) float rate) {
            this.sampleRate = rate;
            return this;
        }

        private final LogHandler buildLogcatHandler(CoreFeature coreFeature) {
            String string = this.serviceName;
            if (string == null) {
                CoreFeature coreFeature2 = coreFeature;
                if (coreFeature2 == null) {
                    string = "unknown";
                } else {
                    string = coreFeature2.getServiceName$dd_sdk_android_release();
                    if (string == null) {
                        string = "unknown";
                    }
                }
            }
            return new LogcatLogHandler(string, true, false, 4, null);
        }

        private final LogHandler buildDatadogHandler(SdkCore sdkCore, CoreFeature coreFeature, LogsFeature logsFeature) {
            String string;
            String string2;
            if (sdkCore == null || coreFeature == null || logsFeature == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "You're trying to create a Logger instance, but the SDK was not yet initialized. This Logger will not be able to send any messages. Please initialize the Datadog SDK first before creating a new Logger instance.\nPlease add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);", null, 8, null);
                return new NoOpLogHandler();
            }
            String string3 = this.loggerName;
            if (string3 == null) {
                string3 = string2 = coreFeature.getPackageName$dd_sdk_android_release();
            }
            if ((string = this.serviceName) == null) {
                string = coreFeature.getServiceName$dd_sdk_android_release();
            }
            DatadogLogGenerator datadogLogGenerator = new DatadogLogGenerator(string);
            DataWriter<LogEvent> dataWriter = logsFeature.getDataWriter$dd_sdk_android_release();
            int n = this.minDatadogLogsPriority;
            boolean bl = this.bundleWithTraceEnabled;
            boolean bl2 = this.bundleWithRumEnabled;
            RateBasedSampler rateBasedSampler = new RateBasedSampler(this.sampleRate);
            boolean bl3 = this.networkInfoEnabled;
            return new DatadogLogHandler(string2, datadogLogGenerator, sdkCore, dataWriter, bl3, bl, bl2, rateBasedSampler, n);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/log/Logger$Companion;", "", "()V", "SDK_NOT_INITIALIZED_WARNING_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

