/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import android.content.ComponentName;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.fragment.DialogFragmentNavigator;
import androidx.navigation.fragment.FragmentNavigator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"UNKNOWN_DESTINATION_URL", "", "resolveViewUrl", "Landroid/content/ComponentName;", "", "dd-sdk-android_release"})
public final class ViewUtilsKt {
    @NotNull
    public static final String UNKNOWN_DESTINATION_URL = "Unknown";

    @NotNull
    public static final String resolveViewUrl(@NotNull Object $this$resolveViewUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolveViewUrl, (String)"<this>");
        Object object = $this$resolveViewUrl;
        if (object instanceof FragmentNavigator.Destination) {
            String string2 = ((FragmentNavigator.Destination)$this$resolveViewUrl).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
            string = string2;
        } else if (object instanceof DialogFragmentNavigator.Destination) {
            String string3 = ((DialogFragmentNavigator.Destination)$this$resolveViewUrl).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"className");
            string = string3;
        } else if (object instanceof ActivityNavigator.Destination) {
            ComponentName componentName = ((ActivityNavigator.Destination)$this$resolveViewUrl).getComponent();
            if (componentName == null) {
                string = UNKNOWN_DESTINATION_URL;
            } else {
                string = ViewUtilsKt.resolveViewUrl(componentName);
                if (string == null) {
                    string = UNKNOWN_DESTINATION_URL;
                }
            }
        } else if (object instanceof String) {
            string = (String)$this$resolveViewUrl;
        } else {
            String string4 = $this$resolveViewUrl.getClass().getCanonicalName();
            if (string4 == null) {
                string4 = $this$resolveViewUrl.getClass().getSimpleName();
            }
            String string5 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"javaClass.canonicalName ?: javaClass.simpleName");
            string = string5;
        }
        return string;
    }

    @NotNull
    public static final String resolveViewUrl(@NotNull ComponentName $this$resolveViewUrl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$resolveViewUrl, (String)"<this>");
        String string = $this$resolveViewUrl.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        if (((CharSequence)string).length() == 0) {
            string = $this$resolveViewUrl.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
            object = string;
        } else {
            string = $this$resolveViewUrl.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
            if (StringsKt.startsWith$default((String)string, (String)($this$resolveViewUrl.getPackageName() + "."), (boolean)false, (int)2, null)) {
                string = $this$resolveViewUrl.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                object = string;
            } else {
                string = $this$resolveViewUrl.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                    string = $this$resolveViewUrl.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                    object = string;
                } else {
                    object = $this$resolveViewUrl.getPackageName() + "." + $this$resolveViewUrl.getClassName();
                }
            }
        }
        return object;
    }
}

