/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ERROR_UNCAUGHT_EXECUTION_EXCEPTION", "", "loggingAfterExecute", "", "task", "Ljava/lang/Runnable;", "t", "", "logger", "Lcom/datadog/android/v2/api/InternalLogger;", "sleepSafe", "", "durationMs", "", "dd-sdk-android_release"})
public final class ThreadExtKt {
    @NotNull
    public static final String ERROR_UNCAUGHT_EXECUTION_EXCEPTION = "Uncaught exception during the task execution";

    public static final boolean sleepSafe(long durationMs) {
        try {
            Thread.sleep(durationMs);
            return false;
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Thread was unable to set its own interrupted state", (Throwable)se);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, "Thread tried to sleep for a negative amount of time", (Throwable)e);
            return false;
        }
    }

    public static final void loggingAfterExecute(@Nullable Runnable task, @Nullable Throwable t, @NotNull InternalLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Throwable throwable = t;
        if (t == null && task instanceof Future && ((Future)((Object)task)).isDone()) {
            try {
                ((Future)((Object)task)).get();
            }
            catch (CancellationException ce) {
                throwable = ce;
            }
            catch (ExecutionException ee) {
                throwable = ee.getCause();
            }
            catch (InterruptedException ie) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (SecurityException se) {
                    logger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Thread was unable to set its own interrupted state", (Throwable)se);
                }
            }
        }
        if (throwable != null) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            logger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), ERROR_UNCAUGHT_EXECUTION_EXCEPTION, throwable);
        }
    }
}

