/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.single;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.SerializerKt;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileWriter;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0010\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001'B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0003\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0017J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/datadog/android/core/internal/persistence/file/single/SingleItemDataWriter;", "T", "", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "serializer", "Lcom/datadog/android/core/internal/persistence/Serializer;", "fileWriter", "Lcom/datadog/android/core/internal/persistence/file/FileWriter;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/Serializer;Lcom/datadog/android/core/internal/persistence/file/FileWriter;Lcom/datadog/android/v2/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;)V", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getFilePersistenceConfig$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "getFileWriter$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileWriter;", "getInternalLogger$dd_sdk_android_release", "()Lcom/datadog/android/v2/api/InternalLogger;", "getSerializer$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/Serializer;", "checkEventSize", "", "eventSize", "", "consume", "", "data", "(Ljava/lang/Object;)V", "write", "element", "", "writeData", "byteArray", "", "Companion", "dd-sdk-android_release"})
public class SingleItemDataWriter<T>
implements DataWriter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileOrchestrator fileOrchestrator;
    @NotNull
    private final Serializer<T> serializer;
    @NotNull
    private final FileWriter fileWriter;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    public static final String ERROR_LARGE_DATA = "Can't write data with size %d (max item size is %d)";

    public SingleItemDataWriter(@NotNull FileOrchestrator fileOrchestrator, @NotNull Serializer<T> serializer, @NotNull FileWriter fileWriter, @NotNull InternalLogger internalLogger, @NotNull FilePersistenceConfig filePersistenceConfig) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)fileWriter, (String)"fileWriter");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        this.fileOrchestrator = fileOrchestrator;
        this.serializer = serializer;
        this.fileWriter = fileWriter;
        this.internalLogger = internalLogger;
        this.filePersistenceConfig = filePersistenceConfig;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    @NotNull
    public final Serializer<T> getSerializer$dd_sdk_android_release() {
        return this.serializer;
    }

    @NotNull
    public final FileWriter getFileWriter$dd_sdk_android_release() {
        return this.fileWriter;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_release() {
        return this.internalLogger;
    }

    @NotNull
    public final FilePersistenceConfig getFilePersistenceConfig$dd_sdk_android_release() {
        return this.filePersistenceConfig;
    }

    @Override
    @WorkerThread
    public void write(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.consume(element);
    }

    @Override
    @WorkerThread
    public void write(@NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = CollectionsKt.lastOrNull(data);
        if (object == null) {
            return;
        }
        Object element = object;
        this.consume(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void consume(T data) {
        byte[] byArray = SerializerKt.serializeToByteArray(this.serializer, data, this.internalLogger);
        if (byArray == null) {
            return;
        }
        byte[] byteArray = byArray;
        synchronized (this) {
            boolean bl = false;
            boolean bl2 = this.writeData(byteArray);
        }
    }

    @WorkerThread
    private final boolean writeData(byte[] byteArray) {
        if (!this.checkEventSize(byteArray.length)) {
            return false;
        }
        File file = FileOrchestrator.DefaultImpls.getWritableFile$default(this.fileOrchestrator, false, 1, null);
        if (file == null) {
            return false;
        }
        File file2 = file;
        return this.fileWriter.writeData(file2, byteArray, false);
    }

    private final boolean checkEventSize(int eventSize) {
        if ((long)eventSize > this.filePersistenceConfig.getMaxItemSize()) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_LARGE_DATA;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{eventSize, this.filePersistenceConfig.getMaxItemSize()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/file/single/SingleItemDataWriter$Companion;", "", "()V", "ERROR_LARGE_DATA", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

