/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.security.Encryption;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0017R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "encryption", "Lcom/datadog/android/security/Encryption;", "delegate", "(Lcom/datadog/android/security/Encryption;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;)V", "getDelegate$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "getEncryption$dd_sdk_android_release", "()Lcom/datadog/android/security/Encryption;", "readData", "", "", "file", "Ljava/io/File;", "writeData", "", "data", "append", "Companion", "dd-sdk-android_release"})
public final class EncryptedBatchReaderWriter
implements BatchFileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Encryption encryption;
    @NotNull
    private final BatchFileReaderWriter delegate;
    @NotNull
    public static final String BAD_ENCRYPTION_RESULT_MESSAGE = "Encryption of non-empty data produced empty result, aborting write operation.";

    public EncryptedBatchReaderWriter(@NotNull Encryption encryption, @NotNull BatchFileReaderWriter delegate) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.encryption = encryption;
        this.delegate = delegate;
    }

    @NotNull
    public final Encryption getEncryption$dd_sdk_android_release() {
        return this.encryption;
    }

    @NotNull
    public final BatchFileReaderWriter getDelegate$dd_sdk_android_release() {
        return this.delegate;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] encryptedData = this.encryption.encrypt(data);
        if (!(data.length == 0) && encryptedData.length == 0) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, BAD_ENCRYPTION_RESULT_MESSAGE, null, 8, null);
            return false;
        }
        return this.delegate.writeData(file, encryptedData, append);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @NotNull
    public List<byte[]> readData(@NotNull File file) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$map$iv = this.delegate.readData(file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getEncryption$dd_sdk_android_release().decrypt((byte[])it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/EncryptedBatchReaderWriter$Companion;", "", "()V", "BAD_ENCRYPTION_RESULT_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

