/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.v2.api.InternalLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0017J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/v2/api/InternalLogger;)V", "lockFileAndWriteData", "", "file", "Ljava/io/File;", "append", "", "data", "", "moveFile", "destDir", "readData", "writeData", "Companion", "dd-sdk-android_release"})
public final class PlainFileReaderWriter
implements FileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    public static final String ERROR_WRITE = "Unable to write data to file: %s";
    @NotNull
    public static final String ERROR_READ = "Unable to read data from file: %s";

    public PlainFileReaderWriter(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.lockFileAndWriteData(file, append, data);
            bl = true;
        }
        catch (IOException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        catch (SecurityException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    @NotNull
    public byte[] readData(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            byte[] byArray;
            String string;
            Object[] objectArray;
            Locale locale;
            if (!file.exists()) {
                object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = ERROR_READ;
                locale = Locale.US;
                objectArray = new Object[]{file.getPath()};
                string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                byArray = EMPTY_BYTE_ARRAY;
            } else if (file.isDirectory()) {
                object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = ERROR_READ;
                locale = Locale.US;
                objectArray = new Object[]{file.getPath()};
                string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                byArray = EMPTY_BYTE_ARRAY;
            } else {
                byArray = FilesKt.readBytes((File)file);
            }
            object = byArray;
        }
        catch (IOException e) {
            Object object2 = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object2);
            object2 = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            object = EMPTY_BYTE_ARRAY;
        }
        catch (SecurityException e) {
            Object object3 = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object3);
            object3 = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            object = EMPTY_BYTE_ARRAY;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockFileAndWriteData(File file, boolean append, byte[] data) throws IOException {
        Closeable closeable = new FileOutputStream(file, append);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock fileLock = outputStream.getChannel().lock();
            Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"outputStream.channel.lock()");
            FileLock $this$use$iv = fileLock;
            boolean $i$f$use = false;
            try {
                FileLock it = $this$use$iv;
                boolean bl2 = false;
                outputStream.write(data);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean moveFile(File file, File destDir) {
        File destFile = new File(destDir, file.getName());
        return FileExtKt.renameToSafe(file, destFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter$Companion;", "", "()V", "EMPTY_BYTE_ARRAY", "", "ERROR_READ", "", "ERROR_WRITE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

