/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001c\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\n\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/net/RotatingDnsResolver;", "Lokhttp3/Dns;", "delegate", "ttl", "Lkotlin/time/Duration;", "(Lokhttp3/Dns;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "knownHosts", "", "", "Lcom/datadog/android/core/internal/net/RotatingDnsResolver$ResolvedHost;", "J", "isValid", "", "knownHost", "lookup", "", "Ljava/net/InetAddress;", "hostname", "Companion", "ResolvedHost", "dd-sdk-android_release"})
public final class RotatingDnsResolver
implements Dns {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dns delegate;
    private final long ttl;
    @NotNull
    private final Map<String, ResolvedHost> knownHosts;
    private static final long TTL_30_MIN = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.MINUTES);

    private RotatingDnsResolver(Dns delegate, long ttl) {
        this.delegate = delegate;
        this.ttl = ttl;
        this.knownHosts = new LinkedHashMap();
    }

    public /* synthetic */ RotatingDnsResolver(Dns dns, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Dns dns2 = Dns.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)dns2, (String)"SYSTEM");
            dns = dns2;
        }
        if ((n & 2) != 0) {
            l = TTL_30_MIN;
        }
        this(dns, l, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        List list;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        ResolvedHost knownHost = this.knownHosts.get(hostname);
        if (knownHost != null && this.isValid(knownHost)) {
            knownHost.rotate();
            list = CollectionsKt.toMutableList((Collection)knownHost.getAddresses());
        } else {
            void var3_3;
            List result = this.delegate.lookup(hostname);
            Map<String, ResolvedHost> map = this.knownHosts;
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            ResolvedHost resolvedHost = new ResolvedHost(hostname, CollectionsKt.toMutableList((Collection)result));
            map.put(hostname, resolvedHost);
            list = var3_3;
        }
        return list;
    }

    private final boolean isValid(ResolvedHost knownHost) {
        return Duration.compareTo-LRDsOJo((long)knownHost.getAge-UwyO8pc(), (long)this.ttl) < 0 && !((Collection)knownHost.getAddresses()).isEmpty();
    }

    public /* synthetic */ RotatingDnsResolver(Dns delegate, long ttl, DefaultConstructorMarker $constructor_marker) {
        this(delegate, ttl);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0014\u001a\u00020\u0015\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/core/internal/net/RotatingDnsResolver$ResolvedHost;", "", "hostname", "", "addresses", "", "Ljava/net/InetAddress;", "(Ljava/lang/String;Ljava/util/List;)V", "getAddresses", "()Ljava/util/List;", "getHostname", "()Ljava/lang/String;", "resolutionTimestamp", "", "component1", "component2", "copy", "equals", "", "other", "getAge", "Lkotlin/time/Duration;", "getAge-UwyO8pc", "()J", "hashCode", "", "rotate", "", "toString", "dd-sdk-android_release"})
    public static final class ResolvedHost {
        @NotNull
        private final String hostname;
        @NotNull
        private final List<InetAddress> addresses;
        private final long resolutionTimestamp;

        public ResolvedHost(@NotNull String hostname, @NotNull List<InetAddress> addresses) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
            this.hostname = hostname;
            this.addresses = addresses;
            this.resolutionTimestamp = System.nanoTime();
        }

        @NotNull
        public final String getHostname() {
            return this.hostname;
        }

        @NotNull
        public final List<InetAddress> getAddresses() {
            return this.addresses;
        }

        public final long getAge-UwyO8pc() {
            return DurationKt.toDuration((long)(System.nanoTime() - this.resolutionTimestamp), (DurationUnit)DurationUnit.NANOSECONDS);
        }

        public final void rotate() {
            InetAddress first = (InetAddress)CollectionsKt.removeFirstOrNull(this.addresses);
            if (first != null) {
                this.addresses.add(first);
            }
        }

        @NotNull
        public final String component1() {
            return this.hostname;
        }

        @NotNull
        public final List<InetAddress> component2() {
            return this.addresses;
        }

        @NotNull
        public final ResolvedHost copy(@NotNull String hostname, @NotNull List<InetAddress> addresses) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
            return new ResolvedHost(hostname, addresses);
        }

        public static /* synthetic */ ResolvedHost copy$default(ResolvedHost resolvedHost, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = resolvedHost.hostname;
            }
            if ((n & 2) != 0) {
                list = resolvedHost.addresses;
            }
            return resolvedHost.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "ResolvedHost(hostname=" + this.hostname + ", addresses=" + this.addresses + ")";
        }

        public int hashCode() {
            int result = this.hostname.hashCode();
            result = result * 31 + ((Object)this.addresses).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolvedHost)) {
                return false;
            }
            ResolvedHost resolvedHost = (ResolvedHost)other;
            if (!Intrinsics.areEqual((Object)this.hostname, (Object)resolvedHost.hostname)) {
                return false;
            }
            return Intrinsics.areEqual(this.addresses, resolvedHost.addresses);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/net/RotatingDnsResolver$Companion;", "", "()V", "TTL_30_MIN", "Lkotlin/time/Duration;", "getTTL_30_MIN-UwyO8pc", "()J", "J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getTTL_30_MIN-UwyO8pc() {
            return TTL_30_MIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

