/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.data.upload.Flusher;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.persistence.PayloadDecoration;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReader;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataFlusher;", "Lcom/datadog/android/core/internal/data/upload/Flusher;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "decoration", "Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "fileReader", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/PayloadDecoration;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;Lcom/datadog/android/core/internal/persistence/file/FileMover;)V", "getDecoration$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "getFileMover$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileMover;", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getFileReader$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;", "flush", "", "uploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "dd-sdk-android_release"})
public final class DataFlusher
implements Flusher {
    @NotNull
    private final FileOrchestrator fileOrchestrator;
    @NotNull
    private final PayloadDecoration decoration;
    @NotNull
    private final BatchFileReader fileReader;
    @NotNull
    private final FileMover fileMover;

    public DataFlusher(@NotNull FileOrchestrator fileOrchestrator, @NotNull PayloadDecoration decoration, @NotNull BatchFileReader fileReader, @NotNull FileMover fileMover) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        this.fileOrchestrator = fileOrchestrator;
        this.decoration = decoration;
        this.fileReader = fileReader;
        this.fileMover = fileMover;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    @NotNull
    public final PayloadDecoration getDecoration$dd_sdk_android_release() {
        return this.decoration;
    }

    @NotNull
    public final BatchFileReader getFileReader$dd_sdk_android_release() {
        return this.fileReader;
    }

    @NotNull
    public final FileMover getFileMover$dd_sdk_android_release() {
        return this.fileMover;
    }

    @Override
    @WorkerThread
    public void flush(@NotNull DataUploader uploader) {
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        List<File> toUploadFiles = this.fileOrchestrator.getFlushableFiles();
        Iterable $this$forEach$iv = toUploadFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            byte[] batch = ByteArrayExtKt.join((Collection<byte[]>)this.getFileReader$dd_sdk_android_release().readData(it), this.getDecoration$dd_sdk_android_release().getSeparatorBytes(), this.getDecoration$dd_sdk_android_release().getPrefixBytes(), this.getDecoration$dd_sdk_android_release().getSuffixBytes());
            uploader.upload(batch);
            File metaFile = this.getFileOrchestrator$dd_sdk_android_release().getMetadataFile(it);
            this.getFileMover$dd_sdk_android_release().delete(it);
            File file = metaFile;
            if (!(file == null ? false : FileExtKt.existsSafe(file))) continue;
            this.getFileMover$dd_sdk_android_release().delete(metaFile);
        }
    }
}

