/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import androidx.annotation.RequiresApi;
import com.datadog.android.DatadogSite;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.Credentials;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.net.GzipRequestInterceptor;
import com.datadog.android.core.internal.net.RotatingDnsResolver;
import com.datadog.android.core.internal.net.info.BroadcastReceiverNetworkInfoProvider;
import com.datadog.android.core.internal.net.info.CallbackNetworkInfoProvider;
import com.datadog.android.core.internal.net.info.NetworkInfoDeserializer;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.net.info.NoOpNetworkInfoProvider;
import com.datadog.android.core.internal.persistence.JsonObjectDeserializer;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.advanced.ScheduledWriter;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.core.internal.privacy.NoOpConsentProvider;
import com.datadog.android.core.internal.privacy.TrackingConsentProvider;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import com.datadog.android.core.internal.system.AppVersionProvider;
import com.datadog.android.core.internal.system.BroadcastReceiverSystemInfoProvider;
import com.datadog.android.core.internal.system.DefaultAndroidInfoProvider;
import com.datadog.android.core.internal.system.DefaultAppVersionProvider;
import com.datadog.android.core.internal.system.NoOpAndroidInfoProvider;
import com.datadog.android.core.internal.system.NoOpAppVersionProvider;
import com.datadog.android.core.internal.system.NoOpSystemInfoProvider;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.thread.LoggingScheduledThreadPoolExecutor;
import com.datadog.android.core.internal.thread.LoggingThreadPoolExecutor;
import com.datadog.android.core.internal.time.KronosTimeProvider;
import com.datadog.android.core.internal.time.LoggingSyncListener;
import com.datadog.android.core.internal.time.NoOpTimeProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.user.DatadogUserInfoProvider;
import com.datadog.android.core.internal.user.MutableUserInfoProvider;
import com.datadog.android.core.internal.user.NoOpMutableUserInfoProvider;
import com.datadog.android.core.internal.user.UserInfoDeserializer;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.rum.internal.ndk.DatadogNdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashLogDeserializer;
import com.datadog.android.rum.internal.ndk.NdkNetworkInfoDataWriter;
import com.datadog.android.rum.internal.ndk.NdkUserInfoDataWriter;
import com.datadog.android.rum.internal.ndk.NoOpNdkCrashHandler;
import com.datadog.android.security.Encryption;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.DatadogContextProvider;
import com.datadog.android.v2.core.internal.NoOpContextProvider;
import com.lyft.kronos.AndroidClockFactory;
import com.lyft.kronos.Clock;
import com.lyft.kronos.KronosClock;
import com.lyft.kronos.SyncListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.TlsVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 \u00cd\u00012\u00020\u0001:\u0002\u00cd\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001J\n\u0010\u00b1\u0001\u001a\u00030\u00b2\u0001H\u0002J\n\u0010\u00b3\u0001\u001a\u00030\u00b2\u0001H\u0002J\b\u0010\u00b4\u0001\u001a\u00030\u00b2\u0001J\u0015\u0010\u00b5\u0001\u001a\u0005\u0018\u00010\u00b6\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001dH\u0002J\u0012\u0010\u00b8\u0001\u001a\u00020\u001d2\u0007\u0010\u00b7\u0001\u001a\u00020\u001dH\u0003J8\u0010\u00b9\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001d2\u0007\u0010\u00ba\u0001\u001a\u00020\u00102\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u00012\b\u0010\u00bd\u0001\u001a\u00030\u00be\u00012\b\u0010\u00bf\u0001\u001a\u00030\u00c0\u0001J\u0013\u0010\u00c1\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001dH\u0002J\n\u0010\u00c2\u0001\u001a\u00030\u00b2\u0001H\u0002J\u001d\u0010\u00c3\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001d2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001H\u0002J\u0014\u0010\u00c4\u0001\u001a\u00030\u00b2\u00012\b\u0010\u00bd\u0001\u001a\u00030\u00be\u0001H\u0002J\u0013\u0010\u00c5\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001dH\u0002J\n\u0010\u00c6\u0001\u001a\u00030\u00b2\u0001H\u0002J\u001d\u0010\u00c7\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001d2\b\u0010\u00bf\u0001\u001a\u00030\u00c0\u0001H\u0002J\u0013\u0010\u00c8\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u001dH\u0002J\u0014\u0010\u00c9\u0001\u001a\u00030\u00b2\u00012\b\u0010\u00bd\u0001\u001a\u00030\u00be\u0001H\u0002J\n\u0010\u00ca\u0001\u001a\u00030\u00b2\u0001H\u0002J\n\u0010\u00cb\u0001\u001a\u00030\u00b2\u0001H\u0002J\b\u0010\u00cc\u0001\u001a\u00030\u00b2\u0001R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010\u0014R.\u0010+\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010-0,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u000207X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010%\"\u0004\b<\u0010'R\u001a\u0010=\u001a\u00020>X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010DX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020JX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020PX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010U\u001a\u00020VX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0012\"\u0004\b]\u0010\u0014R\u001a\u0010^\u001a\u00020_X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001a\u0010d\u001a\u00020eX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u001c\u0010j\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\u0012\"\u0004\bl\u0010\u0014R\u001a\u0010m\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u0012\"\u0004\bo\u0010\u0014R\u001a\u0010p\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010\u0012\"\u0004\br\u0010\u0014R\u001a\u0010s\u001a\u00020tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010v\"\u0004\bw\u0010xR\u001a\u0010y\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u0012\"\u0004\b{\u0010\u0014R\u001c\u0010|\u001a\u00020}X\u0080.\u00a2\u0006\u0010\n\u0000\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R \u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\"\u0006\b\u0086\u0001\u0010\u0087\u0001R \u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001\"\u0006\b\u008c\u0001\u0010\u008d\u0001R \u0010\u008e\u0001\u001a\u00030\u008f\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\"\u0006\b\u0092\u0001\u0010\u0093\u0001R \u0010\u0094\u0001\u001a\u00030\u0095\u0001X\u0080.\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001\"\u0006\b\u0098\u0001\u0010\u0099\u0001R \u0010\u009a\u0001\u001a\u00030\u009b\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001\"\u0006\b\u009e\u0001\u0010\u009f\u0001R \u0010\u00a0\u0001\u001a\u00030\u00a1\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a2\u0001\u0010\u00a3\u0001\"\u0006\b\u00a4\u0001\u0010\u00a5\u0001R\u001d\u0010\u00a6\u0001\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a7\u0001\u0010\u0012\"\u0005\b\u00a8\u0001\u0010\u0014R&\u0010\u00a9\u0001\u001a\t\u0012\u0004\u0012\u00020\u00100\u00aa\u0001X\u0080.\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00ab\u0001\u0010\u00ac\u0001\"\u0006\b\u00ad\u0001\u0010\u00ae\u0001\u00a8\u0006\u00ce\u0001"}, d2={"Lcom/datadog/android/core/internal/CoreFeature;", "", "()V", "androidInfoProvider", "Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "getAndroidInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "setAndroidInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/system/AndroidInfoProvider;)V", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "getBatchSize$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/BatchSize;", "setBatchSize$dd_sdk_android_release", "(Lcom/datadog/android/core/configuration/BatchSize;)V", "clientToken", "", "getClientToken$dd_sdk_android_release", "()Ljava/lang/String;", "setClientToken$dd_sdk_android_release", "(Ljava/lang/String;)V", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "getContextProvider$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/ContextProvider;", "setContextProvider$dd_sdk_android_release", "(Lcom/datadog/android/v2/core/internal/ContextProvider;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "getContextRef$dd_sdk_android_release", "()Ljava/lang/ref/WeakReference;", "setContextRef$dd_sdk_android_release", "(Ljava/lang/ref/WeakReference;)V", "disableKronosBackgroundSync", "", "getDisableKronosBackgroundSync$dd_sdk_android_release", "()Z", "setDisableKronosBackgroundSync$dd_sdk_android_release", "(Z)V", "envName", "getEnvName$dd_sdk_android_release", "setEnvName$dd_sdk_android_release", "featuresContext", "", "", "getFeaturesContext$dd_sdk_android_release", "()Ljava/util/Map;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "setFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isMainProcess", "isMainProcess$dd_sdk_android_release", "setMainProcess$dd_sdk_android_release", "kronosClock", "Lcom/lyft/kronos/KronosClock;", "getKronosClock$dd_sdk_android_release", "()Lcom/lyft/kronos/KronosClock;", "setKronosClock$dd_sdk_android_release", "(Lcom/lyft/kronos/KronosClock;)V", "localDataEncryption", "Lcom/datadog/android/security/Encryption;", "getLocalDataEncryption$dd_sdk_android_release", "()Lcom/datadog/android/security/Encryption;", "setLocalDataEncryption$dd_sdk_android_release", "(Lcom/datadog/android/security/Encryption;)V", "ndkCrashHandler", "Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "getNdkCrashHandler$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "setNdkCrashHandler$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;)V", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "getNetworkInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "setNetworkInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient$dd_sdk_android_release", "()Lokhttp3/OkHttpClient;", "setOkHttpClient$dd_sdk_android_release", "(Lokhttp3/OkHttpClient;)V", "packageName", "getPackageName$dd_sdk_android_release", "setPackageName$dd_sdk_android_release", "packageVersionProvider", "Lcom/datadog/android/core/internal/system/AppVersionProvider;", "getPackageVersionProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/system/AppVersionProvider;", "setPackageVersionProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/system/AppVersionProvider;)V", "persistenceExecutorService", "Ljava/util/concurrent/ExecutorService;", "getPersistenceExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ExecutorService;", "setPersistenceExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ExecutorService;)V", "rumApplicationId", "getRumApplicationId$dd_sdk_android_release", "setRumApplicationId$dd_sdk_android_release", "sdkVersion", "getSdkVersion$dd_sdk_android_release", "setSdkVersion$dd_sdk_android_release", "serviceName", "getServiceName$dd_sdk_android_release", "setServiceName$dd_sdk_android_release", "site", "Lcom/datadog/android/DatadogSite;", "getSite$dd_sdk_android_release", "()Lcom/datadog/android/DatadogSite;", "setSite$dd_sdk_android_release", "(Lcom/datadog/android/DatadogSite;)V", "sourceName", "getSourceName$dd_sdk_android_release", "setSourceName$dd_sdk_android_release", "storageDir", "Ljava/io/File;", "getStorageDir$dd_sdk_android_release", "()Ljava/io/File;", "setStorageDir$dd_sdk_android_release", "(Ljava/io/File;)V", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "getSystemInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "setSystemInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/system/SystemInfoProvider;)V", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "getTimeProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/time/TimeProvider;", "setTimeProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/time/TimeProvider;)V", "trackingConsentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "getTrackingConsentProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "setTrackingConsentProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/privacy/ConsentProvider;)V", "uploadExecutorService", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getUploadExecutorService$dd_sdk_android_release", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "setUploadExecutorService$dd_sdk_android_release", "(Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "getUploadFrequency$dd_sdk_android_release", "()Lcom/datadog/android/core/configuration/UploadFrequency;", "setUploadFrequency$dd_sdk_android_release", "(Lcom/datadog/android/core/configuration/UploadFrequency;)V", "userInfoProvider", "Lcom/datadog/android/core/internal/user/MutableUserInfoProvider;", "getUserInfoProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/user/MutableUserInfoProvider;", "setUserInfoProvider$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/user/MutableUserInfoProvider;)V", "variant", "getVariant$dd_sdk_android_release", "setVariant$dd_sdk_android_release", "webViewTrackingHosts", "", "getWebViewTrackingHosts$dd_sdk_android_release", "()Ljava/util/List;", "setWebViewTrackingHosts$dd_sdk_android_release", "(Ljava/util/List;)V", "buildFilePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "cleanupApplicationInfo", "", "cleanupProviders", "drainAndShutdownExecutors", "getPackageInfo", "Landroid/content/pm/PackageInfo;", "appContext", "getSafeContext", "initialize", "sdkInstanceId", "credentials", "Lcom/datadog/android/core/configuration/Credentials;", "configuration", "Lcom/datadog/android/core/configuration/Configuration$Core;", "consent", "Lcom/datadog/android/privacy/TrackingConsent;", "initializeClockSync", "prepareNdkCrashData", "readApplicationInformation", "readConfigurationSettings", "resolveProcessInfo", "setupExecutors", "setupInfoProviders", "setupNetworkInfoProviders", "setupOkHttpClient", "setupUserInfoProvider", "shutDownExecutors", "stop", "Companion", "dd-sdk-android_release"})
public final class CoreFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    @NotNull
    private WeakReference<Context> contextRef = new WeakReference<Object>(null);
    @NotNull
    private FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = new FirstPartyHostHeaderTypeResolver(MapsKt.emptyMap());
    @NotNull
    private NetworkInfoProvider networkInfoProvider = new NoOpNetworkInfoProvider();
    @NotNull
    private SystemInfoProvider systemInfoProvider = new NoOpSystemInfoProvider();
    @NotNull
    private TimeProvider timeProvider = new NoOpTimeProvider();
    @NotNull
    private ConsentProvider trackingConsentProvider = new NoOpConsentProvider();
    @NotNull
    private MutableUserInfoProvider userInfoProvider = new NoOpMutableUserInfoProvider();
    @NotNull
    private ContextProvider contextProvider = new NoOpContextProvider();
    public OkHttpClient okHttpClient;
    public KronosClock kronosClock;
    @NotNull
    private String clientToken = "";
    @NotNull
    private String packageName = "";
    @NotNull
    private AppVersionProvider packageVersionProvider = new NoOpAppVersionProvider();
    @NotNull
    private String serviceName = "";
    @NotNull
    private String sourceName = "android";
    @NotNull
    private String sdkVersion = "1.19.3";
    @Nullable
    private String rumApplicationId;
    private boolean isMainProcess = true;
    @NotNull
    private String envName = "";
    @NotNull
    private String variant = "";
    @NotNull
    private BatchSize batchSize = BatchSize.MEDIUM;
    @NotNull
    private UploadFrequency uploadFrequency = UploadFrequency.AVERAGE;
    @NotNull
    private NdkCrashHandler ndkCrashHandler = new NoOpNdkCrashHandler();
    @NotNull
    private DatadogSite site = DatadogSite.US1;
    public ScheduledThreadPoolExecutor uploadExecutorService;
    public ExecutorService persistenceExecutorService;
    @Nullable
    private Encryption localDataEncryption;
    public List<String> webViewTrackingHosts;
    public File storageDir;
    public AndroidInfoProvider androidInfoProvider;
    @NotNull
    private final Map<String, Map<String, Object>> featuresContext = new ConcurrentHashMap();
    private boolean disableKronosBackgroundSync;
    private static int processImportance = 100;
    private static final long NETWORK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(45L);
    private static final long THREAD_POOL_MAX_KEEP_ALIVE_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final int CORE_DEFAULT_POOL_SIZE = 1;
    @NotNull
    public static final String DATADOG_STORAGE_DIR_NAME = "datadog-%s";
    @NotNull
    public static final String DEFAULT_SOURCE_NAME = "android";
    @NotNull
    public static final String DEFAULT_SDK_VERSION = "1.19.3";
    @NotNull
    public static final String DEFAULT_APP_VERSION = "?";
    @NotNull
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    public static final long DRAIN_WAIT_SECONDS = 10L;
    public static final long NTP_CACHE_EXPIRATION_MINUTES = 30L;
    public static final long NTP_DELAY_BETWEEN_SYNCS_MINUTES = 5L;

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    @NotNull
    public final WeakReference<Context> getContextRef$dd_sdk_android_release() {
        return this.contextRef;
    }

    public final void setContextRef$dd_sdk_android_release(@NotNull WeakReference<Context> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.contextRef = weakReference;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    public final void setFirstPartyHostHeaderTypeResolver$dd_sdk_android_release(@NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"<set-?>");
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
    }

    @NotNull
    public final NetworkInfoProvider getNetworkInfoProvider$dd_sdk_android_release() {
        return this.networkInfoProvider;
    }

    public final void setNetworkInfoProvider$dd_sdk_android_release(@NotNull NetworkInfoProvider networkInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"<set-?>");
        this.networkInfoProvider = networkInfoProvider;
    }

    @NotNull
    public final SystemInfoProvider getSystemInfoProvider$dd_sdk_android_release() {
        return this.systemInfoProvider;
    }

    public final void setSystemInfoProvider$dd_sdk_android_release(@NotNull SystemInfoProvider systemInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"<set-?>");
        this.systemInfoProvider = systemInfoProvider;
    }

    @NotNull
    public final TimeProvider getTimeProvider$dd_sdk_android_release() {
        return this.timeProvider;
    }

    public final void setTimeProvider$dd_sdk_android_release(@NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"<set-?>");
        this.timeProvider = timeProvider;
    }

    @NotNull
    public final ConsentProvider getTrackingConsentProvider$dd_sdk_android_release() {
        return this.trackingConsentProvider;
    }

    public final void setTrackingConsentProvider$dd_sdk_android_release(@NotNull ConsentProvider consentProvider) {
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"<set-?>");
        this.trackingConsentProvider = consentProvider;
    }

    @NotNull
    public final MutableUserInfoProvider getUserInfoProvider$dd_sdk_android_release() {
        return this.userInfoProvider;
    }

    public final void setUserInfoProvider$dd_sdk_android_release(@NotNull MutableUserInfoProvider mutableUserInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)mutableUserInfoProvider, (String)"<set-?>");
        this.userInfoProvider = mutableUserInfoProvider;
    }

    @NotNull
    public final ContextProvider getContextProvider$dd_sdk_android_release() {
        return this.contextProvider;
    }

    public final void setContextProvider$dd_sdk_android_release(@NotNull ContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"<set-?>");
        this.contextProvider = contextProvider;
    }

    @NotNull
    public final OkHttpClient getOkHttpClient$dd_sdk_android_release() {
        OkHttpClient okHttpClient = this.okHttpClient;
        if (okHttpClient != null) {
            return okHttpClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"okHttpClient");
        return null;
    }

    public final void setOkHttpClient$dd_sdk_android_release(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"<set-?>");
        this.okHttpClient = okHttpClient;
    }

    @NotNull
    public final KronosClock getKronosClock$dd_sdk_android_release() {
        KronosClock kronosClock = this.kronosClock;
        if (kronosClock != null) {
            return kronosClock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"kronosClock");
        return null;
    }

    public final void setKronosClock$dd_sdk_android_release(@NotNull KronosClock kronosClock) {
        Intrinsics.checkNotNullParameter((Object)kronosClock, (String)"<set-?>");
        this.kronosClock = kronosClock;
    }

    @NotNull
    public final String getClientToken$dd_sdk_android_release() {
        return this.clientToken;
    }

    public final void setClientToken$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clientToken = string;
    }

    @NotNull
    public final String getPackageName$dd_sdk_android_release() {
        return this.packageName;
    }

    public final void setPackageName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final AppVersionProvider getPackageVersionProvider$dd_sdk_android_release() {
        return this.packageVersionProvider;
    }

    public final void setPackageVersionProvider$dd_sdk_android_release(@NotNull AppVersionProvider appVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)appVersionProvider, (String)"<set-?>");
        this.packageVersionProvider = appVersionProvider;
    }

    @NotNull
    public final String getServiceName$dd_sdk_android_release() {
        return this.serviceName;
    }

    public final void setServiceName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serviceName = string;
    }

    @NotNull
    public final String getSourceName$dd_sdk_android_release() {
        return this.sourceName;
    }

    public final void setSourceName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sourceName = string;
    }

    @NotNull
    public final String getSdkVersion$dd_sdk_android_release() {
        return this.sdkVersion;
    }

    public final void setSdkVersion$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sdkVersion = string;
    }

    @Nullable
    public final String getRumApplicationId$dd_sdk_android_release() {
        return this.rumApplicationId;
    }

    public final void setRumApplicationId$dd_sdk_android_release(@Nullable String string) {
        this.rumApplicationId = string;
    }

    public final boolean isMainProcess$dd_sdk_android_release() {
        return this.isMainProcess;
    }

    public final void setMainProcess$dd_sdk_android_release(boolean bl) {
        this.isMainProcess = bl;
    }

    @NotNull
    public final String getEnvName$dd_sdk_android_release() {
        return this.envName;
    }

    public final void setEnvName$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.envName = string;
    }

    @NotNull
    public final String getVariant$dd_sdk_android_release() {
        return this.variant;
    }

    public final void setVariant$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variant = string;
    }

    @NotNull
    public final BatchSize getBatchSize$dd_sdk_android_release() {
        return this.batchSize;
    }

    public final void setBatchSize$dd_sdk_android_release(@NotNull BatchSize batchSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"<set-?>");
        this.batchSize = batchSize;
    }

    @NotNull
    public final UploadFrequency getUploadFrequency$dd_sdk_android_release() {
        return this.uploadFrequency;
    }

    public final void setUploadFrequency$dd_sdk_android_release(@NotNull UploadFrequency uploadFrequency) {
        Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"<set-?>");
        this.uploadFrequency = uploadFrequency;
    }

    @NotNull
    public final NdkCrashHandler getNdkCrashHandler$dd_sdk_android_release() {
        return this.ndkCrashHandler;
    }

    public final void setNdkCrashHandler$dd_sdk_android_release(@NotNull NdkCrashHandler ndkCrashHandler) {
        Intrinsics.checkNotNullParameter((Object)ndkCrashHandler, (String)"<set-?>");
        this.ndkCrashHandler = ndkCrashHandler;
    }

    @NotNull
    public final DatadogSite getSite$dd_sdk_android_release() {
        return this.site;
    }

    public final void setSite$dd_sdk_android_release(@NotNull DatadogSite datadogSite) {
        Intrinsics.checkNotNullParameter((Object)((Object)datadogSite), (String)"<set-?>");
        this.site = datadogSite;
    }

    @NotNull
    public final ScheduledThreadPoolExecutor getUploadExecutorService$dd_sdk_android_release() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.uploadExecutorService;
        if (scheduledThreadPoolExecutor != null) {
            return scheduledThreadPoolExecutor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uploadExecutorService");
        return null;
    }

    public final void setUploadExecutorService$dd_sdk_android_release(@NotNull ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)scheduledThreadPoolExecutor, (String)"<set-?>");
        this.uploadExecutorService = scheduledThreadPoolExecutor;
    }

    @NotNull
    public final ExecutorService getPersistenceExecutorService$dd_sdk_android_release() {
        ExecutorService executorService = this.persistenceExecutorService;
        if (executorService != null) {
            return executorService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"persistenceExecutorService");
        return null;
    }

    public final void setPersistenceExecutorService$dd_sdk_android_release(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"<set-?>");
        this.persistenceExecutorService = executorService;
    }

    @Nullable
    public final Encryption getLocalDataEncryption$dd_sdk_android_release() {
        return this.localDataEncryption;
    }

    public final void setLocalDataEncryption$dd_sdk_android_release(@Nullable Encryption encryption) {
        this.localDataEncryption = encryption;
    }

    @NotNull
    public final List<String> getWebViewTrackingHosts$dd_sdk_android_release() {
        List<String> list = this.webViewTrackingHosts;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"webViewTrackingHosts");
        return null;
    }

    public final void setWebViewTrackingHosts$dd_sdk_android_release(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.webViewTrackingHosts = list;
    }

    @NotNull
    public final File getStorageDir$dd_sdk_android_release() {
        File file = this.storageDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storageDir");
        return null;
    }

    public final void setStorageDir$dd_sdk_android_release(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.storageDir = file;
    }

    @NotNull
    public final AndroidInfoProvider getAndroidInfoProvider$dd_sdk_android_release() {
        AndroidInfoProvider androidInfoProvider = this.androidInfoProvider;
        if (androidInfoProvider != null) {
            return androidInfoProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"androidInfoProvider");
        return null;
    }

    public final void setAndroidInfoProvider$dd_sdk_android_release(@NotNull AndroidInfoProvider androidInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)androidInfoProvider, (String)"<set-?>");
        this.androidInfoProvider = androidInfoProvider;
    }

    @NotNull
    public final Map<String, Map<String, Object>> getFeaturesContext$dd_sdk_android_release() {
        return this.featuresContext;
    }

    public final boolean getDisableKronosBackgroundSync$dd_sdk_android_release() {
        return this.disableKronosBackgroundSync;
    }

    public final void setDisableKronosBackgroundSync$dd_sdk_android_release(boolean bl) {
        this.disableKronosBackgroundSync = bl;
    }

    public final void initialize(@NotNull Context appContext, @NotNull String sdkInstanceId, @NotNull Credentials credentials, @NotNull Configuration.Core configuration, @NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)sdkInstanceId, (String)"sdkInstanceId");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        if (this.initialized.get()) {
            return;
        }
        this.readConfigurationSettings(configuration);
        this.readApplicationInformation(appContext, credentials);
        this.resolveProcessInfo(appContext);
        this.initializeClockSync(appContext);
        this.setupOkHttpClient(configuration);
        this.firstPartyHostHeaderTypeResolver.addKnownHostsWithHeaderTypes(configuration.getFirstPartyHostsWithHeaderTypes());
        this.setWebViewTrackingHosts$dd_sdk_android_release(configuration.getWebViewTrackingHosts());
        this.setAndroidInfoProvider$dd_sdk_android_release(new DefaultAndroidInfoProvider(appContext, null, 2, null));
        this.setupExecutors();
        File file = appContext.getCacheDir();
        String string = DATADOG_STORAGE_DIR_NAME;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{sdkInstanceId};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        this.setStorageDir$dd_sdk_android_release(new File(file, string2));
        this.timeProvider = new KronosTimeProvider((Clock)this.getKronosClock$dd_sdk_android_release());
        this.prepareNdkCrashData();
        this.setupInfoProviders(appContext, consent);
        this.initialized.set(true);
        this.contextProvider = new DatadogContextProvider(this);
    }

    public final void stop() {
        if (this.initialized.get()) {
            Context context = (Context)this.contextRef.get();
            if (context != null) {
                Context it = context;
                boolean bl = false;
                this.getNetworkInfoProvider$dd_sdk_android_release().unregister(it);
                this.getSystemInfoProvider$dd_sdk_android_release().unregister(it);
            }
            this.contextRef.clear();
            this.trackingConsentProvider.unregisterAllCallbacks();
            this.cleanupApplicationInfo();
            this.cleanupProviders();
            this.shutDownExecutors();
            try {
                this.getKronosClock$dd_sdk_android_release().shutdown();
            }
            catch (IllegalStateException ise) {
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Trying to shut down Kronos when it is already not running", (Throwable)ise);
            }
            this.featuresContext.clear();
            this.initialized.set(false);
            this.ndkCrashHandler = new NoOpNdkCrashHandler();
            this.trackingConsentProvider = new NoOpConsentProvider();
            this.contextProvider = new NoOpContextProvider();
        }
    }

    @NotNull
    public final FilePersistenceConfig buildFilePersistenceConfig() {
        return new FilePersistenceConfig(this.batchSize.getWindowDurationMs$dd_sdk_android_release(), 0L, 0L, 0, 0L, 0L, 0L, 126, null);
    }

    public final void drainAndShutdownExecutors() throws UnsupportedOperationException, InterruptedException {
        ThreadPoolExecutor threadPoolExecutor;
        ArrayList tasks = new ArrayList();
        Object object = this.getPersistenceExecutorService$dd_sdk_android_release();
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = object instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object : null;
        if (threadPoolExecutor != null && (object = threadPoolExecutor.getQueue()) != null) {
            object.drainTo(tasks);
        }
        this.getUploadExecutorService$dd_sdk_android_release().getQueue().drainTo(tasks);
        this.getPersistenceExecutorService$dd_sdk_android_release().shutdown();
        this.getUploadExecutorService$dd_sdk_android_release().shutdown();
        this.getPersistenceExecutorService$dd_sdk_android_release().awaitTermination(10L, TimeUnit.SECONDS);
        this.getUploadExecutorService$dd_sdk_android_release().awaitTermination(10L, TimeUnit.SECONDS);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    private final void prepareNdkCrashData() {
        if (this.isMainProcess) {
            this.ndkCrashHandler = new DatadogNdkCrashHandler(this.getStorageDir$dd_sdk_android_release(), this.getPersistenceExecutorService$dd_sdk_android_release(), new NdkCrashLogDeserializer(RuntimeUtilsKt.getInternalLogger()), new JsonObjectDeserializer(), new NetworkInfoDeserializer(RuntimeUtilsKt.getInternalLogger()), new UserInfoDeserializer(RuntimeUtilsKt.getInternalLogger()), RuntimeUtilsKt.getInternalLogger(), BatchFileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.localDataEncryption), FileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.localDataEncryption));
            this.ndkCrashHandler.prepareData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeClockSync(Context appContext) {
        Context safeContext = Build.VERSION.SDK_INT >= 24 ? this.getSafeContext(appContext) : appContext;
        Object[] objectArray = new String[]{"0.datadog.pool.ntp.org", "1.datadog.pool.ntp.org", "2.datadog.pool.ntp.org", "3.datadog.pool.ntp.org"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        long l = TimeUnit.MINUTES.toMillis(30L);
        long l2 = TimeUnit.MINUTES.toMillis(5L);
        LoggingSyncListener loggingSyncListener = new LoggingSyncListener();
        KronosClock kronosClock = AndroidClockFactory.createKronosClock$default((Context)safeContext, (SyncListener)loggingSyncListener, (List)list, (long)0L, (long)l2, (long)l, (long)0L, (int)72, null);
        list = kronosClock;
        CoreFeature coreFeature = this;
        boolean bl = false;
        if (!this.getDisableKronosBackgroundSync$dd_sdk_android_release()) {
            try {
                void $this$initializeClockSync_u24lambda_u2d2;
                $this$initializeClockSync_u24lambda_u2d2.syncInBackground();
            }
            catch (IllegalStateException ise) {
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Cannot launch time sync", (Throwable)ise);
            }
        }
        coreFeature.setKronosClock$dd_sdk_android_release(kronosClock);
    }

    @RequiresApi(value=24)
    private final Context getSafeContext(Context appContext) {
        Context context = appContext.createDeviceProtectedStorageContext();
        if (context == null) {
            context = appContext;
        }
        return context;
    }

    /*
     * WARNING - void declaration
     */
    private final void readApplicationInformation(Context appContext, Credentials credentials) {
        String string;
        String string2;
        String string3 = appContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"appContext.packageName");
        this.packageName = string3;
        CoreFeature coreFeature = this;
        string3 = this.getPackageInfo(appContext);
        if (string3 == null) {
            string2 = DEFAULT_APP_VERSION;
        } else {
            void it;
            String string4 = string3;
            CoreFeature coreFeature2 = coreFeature;
            boolean bl = false;
            String string5 = it.versionName;
            if (string5 == null) {
                string5 = String.valueOf(it.versionCode);
            }
            coreFeature = coreFeature2;
            string = string5;
            string2 = string == null ? DEFAULT_APP_VERSION : string;
        }
        String string6 = string2;
        coreFeature.packageVersionProvider = new DefaultAppVersionProvider(string6);
        this.clientToken = credentials.getClientToken();
        String string7 = credentials.getServiceName();
        if (string7 == null) {
            string = appContext.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appContext.packageName");
            string7 = string;
        }
        this.serviceName = string7;
        this.rumApplicationId = credentials.getRumApplicationId();
        this.envName = credentials.getEnvName();
        this.variant = credentials.getVariant();
        this.contextRef = new WeakReference<Context>(appContext);
    }

    private final PackageInfo getPackageInfo(Context appContext) {
        PackageInfo packageInfo;
        try {
            PackageManager $this$getPackageInfo_u24lambda_u2d4 = appContext.getPackageManager();
            boolean bl = false;
            packageInfo = Build.VERSION.SDK_INT >= 33 ? $this$getPackageInfo_u24lambda_u2d4.getPackageInfo(this.getPackageName$dd_sdk_android_release(), PackageManager.PackageInfoFlags.of((long)0L)) : $this$getPackageInfo_u24lambda_u2d4.getPackageInfo(this.getPackageName$dd_sdk_android_release(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, "Unable to read your application's version name", (Throwable)e);
            packageInfo = null;
        }
        return packageInfo;
    }

    private final void readConfigurationSettings(Configuration.Core configuration) {
        this.batchSize = configuration.getBatchSize();
        this.uploadFrequency = configuration.getUploadFrequency();
        this.localDataEncryption = configuration.getEncryption();
        this.site = configuration.getSite();
    }

    private final void setupInfoProviders(Context appContext, TrackingConsent consent) {
        this.trackingConsentProvider = new TrackingConsentProvider(consent);
        this.systemInfoProvider = new BroadcastReceiverSystemInfoProvider(null, 1, null);
        this.systemInfoProvider.register(appContext);
        this.setupNetworkInfoProviders(appContext);
        this.setupUserInfoProvider();
    }

    private final void setupUserInfoProvider() {
        ScheduledWriter userInfoWriter = new ScheduledWriter(new NdkUserInfoDataWriter(this.getStorageDir$dd_sdk_android_release(), this.trackingConsentProvider, this.getPersistenceExecutorService$dd_sdk_android_release(), FileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.localDataEncryption), new FileMover(RuntimeUtilsKt.getInternalLogger()), RuntimeUtilsKt.getInternalLogger(), this.buildFilePersistenceConfig()), this.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getInternalLogger());
        this.userInfoProvider = new DatadogUserInfoProvider(userInfoWriter);
    }

    private final void setupNetworkInfoProviders(Context appContext) {
        ScheduledWriter networkInfoWriter = new ScheduledWriter(new NdkNetworkInfoDataWriter(this.getStorageDir$dd_sdk_android_release(), this.trackingConsentProvider, this.getPersistenceExecutorService$dd_sdk_android_release(), FileReaderWriter.Companion.create(RuntimeUtilsKt.getInternalLogger(), this.localDataEncryption), new FileMover(RuntimeUtilsKt.getInternalLogger()), RuntimeUtilsKt.getInternalLogger(), this.buildFilePersistenceConfig()), this.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getInternalLogger());
        this.networkInfoProvider = Build.VERSION.SDK_INT >= 24 ? (NetworkInfoProvider)new CallbackNetworkInfoProvider(networkInfoWriter, null, 2, null) : (NetworkInfoProvider)new BroadcastReceiverNetworkInfoProvider(networkInfoWriter, null, 2, null);
        this.networkInfoProvider.register(appContext);
    }

    private final void setupOkHttpClient(Configuration.Core configuration) {
        ConnectionSpec connectionSpec;
        if (configuration.getNeedsClearTextHttp()) {
            connectionSpec = ConnectionSpec.CLEARTEXT;
        } else {
            TlsVersion[] tlsVersionArray = new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_3};
            ConnectionSpec.Builder builder = new ConnectionSpec.Builder(ConnectionSpec.RESTRICTED_TLS).tlsVersions(tlsVersionArray).supportsTlsExtensions(true);
            tlsVersionArray = RESTRICTED_CIPHER_SUITES;
            connectionSpec = builder.cipherSuites((CipherSuite[])Arrays.copyOf(tlsVersionArray, tlsVersionArray.length)).build();
        }
        ConnectionSpec connectionSpec2 = connectionSpec;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Protocol[] protocolArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        builder.callTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).writeTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).protocols(CollectionsKt.listOf((Object[])protocolArray)).connectionSpecs(CollectionsKt.listOf((Object)connectionSpec2));
        builder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        if (configuration.getProxy() != null) {
            builder.proxy(configuration.getProxy());
            builder.proxyAuthenticator(configuration.getProxyAuth());
        }
        builder.dns((Dns)new RotatingDnsResolver(null, 0L, 3, null));
        protocolArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)protocolArray, (String)"builder.build()");
        this.setOkHttpClient$dd_sdk_android_release((OkHttpClient)protocolArray);
    }

    private final void setupExecutors() {
        this.setUploadExecutorService$dd_sdk_android_release(new LoggingScheduledThreadPoolExecutor(1, RuntimeUtilsKt.getInternalLogger()));
        this.setPersistenceExecutorService$dd_sdk_android_release(new LoggingThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), THREAD_POOL_MAX_KEEP_ALIVE_MS, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingDeque(), RuntimeUtilsKt.getInternalLogger()));
    }

    private final void resolveProcessInfo(Context appContext) {
        ActivityManager.RunningAppProcessInfo currentProcess;
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
        ActivityManager manager;
        int currentProcessId = Process.myPid();
        Object object = appContext.getSystemService("activity");
        ActivityManager activityManager = manager = object instanceof ActivityManager ? (ActivityManager)object : null;
        if (activityManager == null) {
            runningAppProcessInfo = null;
        } else {
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                runningAppProcessInfo = null;
            } else {
                Object v3;
                block7: {
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ActivityManager.RunningAppProcessInfo it = (ActivityManager.RunningAppProcessInfo)element$iv;
                        boolean bl = false;
                        if (!(it.pid == currentProcessId)) continue;
                        v3 = element$iv;
                        break block7;
                    }
                    v3 = null;
                }
                runningAppProcessInfo = currentProcess = (ActivityManager.RunningAppProcessInfo)v3;
            }
        }
        if (currentProcess == null) {
            this.isMainProcess = true;
            processImportance = 100;
        } else {
            this.isMainProcess = Intrinsics.areEqual((Object)appContext.getPackageName(), (Object)currentProcess.processName);
            processImportance = currentProcess.importance;
        }
    }

    private final void shutDownExecutors() {
        this.getUploadExecutorService$dd_sdk_android_release().shutdownNow();
        this.getPersistenceExecutorService$dd_sdk_android_release().shutdownNow();
        try {
            this.getUploadExecutorService$dd_sdk_android_release().awaitTermination(1L, TimeUnit.SECONDS);
            this.getPersistenceExecutorService$dd_sdk_android_release().awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Thread was unable to set its own interrupted state", (Throwable)se);
            }
        }
    }

    private final void cleanupApplicationInfo() {
        this.clientToken = "";
        this.packageName = "";
        this.packageVersionProvider = new NoOpAppVersionProvider();
        this.serviceName = "";
        this.sourceName = DEFAULT_SOURCE_NAME;
        this.sdkVersion = DEFAULT_SDK_VERSION;
        this.rumApplicationId = null;
        this.isMainProcess = true;
        this.envName = "";
        this.variant = "";
    }

    private final void cleanupProviders() {
        this.firstPartyHostHeaderTypeResolver = new FirstPartyHostHeaderTypeResolver(MapsKt.emptyMap());
        this.networkInfoProvider = new NoOpNetworkInfoProvider();
        this.systemInfoProvider = new NoOpSystemInfoProvider();
        this.timeProvider = new NoOpTimeProvider();
        this.trackingConsentProvider = new NoOpConsentProvider();
        this.userInfoProvider = new NoOpMutableUserInfoProvider();
        this.setAndroidInfoProvider$dd_sdk_android_release(new NoOpAndroidInfoProvider());
    }

    static {
        CipherSuite[] cipherSuiteArray = new CipherSuite[]{CipherSuite.TLS_AES_128_GCM_SHA256, CipherSuite.TLS_AES_256_GCM_SHA384, CipherSuite.TLS_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA256};
        RESTRICTED_CIPHER_SUITES = cipherSuiteArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/core/internal/CoreFeature$Companion;", "", "()V", "CORE_DEFAULT_POOL_SIZE", "", "DATADOG_STORAGE_DIR_NAME", "", "DEFAULT_APP_VERSION", "DEFAULT_SDK_VERSION", "DEFAULT_SOURCE_NAME", "DRAIN_WAIT_SECONDS", "", "NETWORK_TIMEOUT_MS", "getNETWORK_TIMEOUT_MS$dd_sdk_android_release", "()J", "NTP_CACHE_EXPIRATION_MINUTES", "NTP_DELAY_BETWEEN_SYNCS_MINUTES", "RESTRICTED_CIPHER_SUITES", "", "Lokhttp3/CipherSuite;", "kotlin.jvm.PlatformType", "getRESTRICTED_CIPHER_SUITES$dd_sdk_android_release", "()[Lokhttp3/CipherSuite;", "[Lokhttp3/CipherSuite;", "THREAD_POOL_MAX_KEEP_ALIVE_MS", "processImportance", "getProcessImportance$dd_sdk_android_release", "()I", "setProcessImportance$dd_sdk_android_release", "(I)V", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getProcessImportance$dd_sdk_android_release() {
            return processImportance;
        }

        public final void setProcessImportance$dd_sdk_android_release(int n) {
            processImportance = n;
        }

        public final long getNETWORK_TIMEOUT_MS$dd_sdk_android_release() {
            return NETWORK_TIMEOUT_MS;
        }

        @NotNull
        public final CipherSuite[] getRESTRICTED_CIPHER_SUITES$dd_sdk_android_release() {
            return RESTRICTED_CIPHER_SUITES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

