/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.opentracing.DDSpan;
import com.datadog.trace.common.sampling.DeterministicSampler;
import com.datadog.trace.common.sampling.PrioritySampler;
import com.datadog.trace.common.sampling.RateSampler;
import com.datadog.trace.common.sampling.Sampler;
import java.util.Collections;
import java.util.Map;

public class RateByServiceSampler
implements Sampler,
PrioritySampler {
    public static final String SAMPLING_AGENT_RATE = "_dd.agent_psr";
    private static final String DEFAULT_KEY = "service:,env:";
    private static final double DEFAULT_RATE = 1.0;
    private volatile Map<String, RateSampler> serviceRates = Collections.unmodifiableMap(Collections.singletonMap("service:,env:", this.createRateSampler(1.0)));

    @Override
    public boolean sample(DDSpan span) {
        return true;
    }

    @Override
    public void setSamplingPriority(DDSpan span) {
        boolean priorityWasSet;
        String serviceName = span.getServiceName();
        String env = RateByServiceSampler.getSpanEnv(span);
        String key = "service:" + serviceName + ",env:" + env;
        Map<String, RateSampler> rates = this.serviceRates;
        RateSampler sampler = this.serviceRates.get(key);
        if (sampler == null) {
            sampler = rates.get(DEFAULT_KEY);
        }
        if (priorityWasSet = sampler.sample(span) ? span.context().setSamplingPriority(1) : span.context().setSamplingPriority(0)) {
            span.context().setMetric(SAMPLING_AGENT_RATE, sampler.getSampleRate());
        }
    }

    private static String getSpanEnv(DDSpan span) {
        return null == span.getTags().get("env") ? "" : String.valueOf(span.getTags().get("env"));
    }

    private RateSampler createRateSampler(double sampleRate) {
        double sanitizedRate = sampleRate < 0.0 ? 1.0 : (sampleRate > 1.0 ? 1.0 : sampleRate);
        return new DeterministicSampler(sanitizedRate);
    }
}

