/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class B3HttpCodec {
    private static final String TRACE_ID_KEY = "X-B3-TraceId";
    private static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;

    private B3HttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> tags2 = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        int length = value.length();
                        if (length > 32) {
                            traceId = BigInteger.ZERO;
                            continue;
                        }
                        String trimmedValue = length > 16 ? value.substring(length - 16) : value;
                        traceId = HttpCodec.validateUInt64BitsID(trimmedValue, 16);
                    } else if (B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 16);
                    } else if (B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = this.convertSamplingPriority(value);
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags2.isEmpty()) {
                        tags2 = new HashMap<String, String>();
                    }
                    tags2.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, null, Collections.emptyMap(), tags2);
                    context.lockSamplingPriority();
                    return context;
                }
                if (!tags2.isEmpty()) {
                    return new TagContext(null, tags2);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            try {
                carrier.put(B3HttpCodec.TRACE_ID_KEY, context.getTraceId().toString(16).toLowerCase(Locale.US));
                carrier.put(B3HttpCodec.SPAN_ID_KEY, context.getSpanId().toString(16).toLowerCase(Locale.US));
                if (context.lockSamplingPriority()) {
                    carrier.put(B3HttpCodec.SAMPLING_PRIORITY_KEY, this.convertSamplingPriority(context.getSamplingPriority()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

