/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.decorators;

import com.datadog.opentracing.decorators.AbstractDecorator;
import com.datadog.opentracing.decorators.DBTypeDecorator;
import com.datadog.opentracing.decorators.ForceManualDropDecorator;
import com.datadog.opentracing.decorators.ForceManualKeepDecorator;
import com.datadog.opentracing.decorators.PeerServiceDecorator;
import com.datadog.opentracing.decorators.ServiceNameDecorator;
import com.datadog.opentracing.decorators.ServletContextDecorator;
import com.datadog.trace.api.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DDDecoratorsFactory {
    public static List<AbstractDecorator> createBuiltinDecorators() {
        ArrayList<AbstractDecorator> decorators = new ArrayList<AbstractDecorator>();
        for (AbstractDecorator decorator : Arrays.asList(new DBTypeDecorator(), new ForceManualDropDecorator(), new ForceManualKeepDecorator(), new PeerServiceDecorator(), new ServiceNameDecorator(), new ServiceNameDecorator("service", false), new ServletContextDecorator())) {
            if (!Config.get().isRuleEnabled(decorator.getClass().getSimpleName())) continue;
            decorators.add(decorator);
        }
        for (String splitByTag : Config.get().getSplitByTags()) {
            decorators.add(new ServiceNameDecorator(splitByTag, true));
        }
        return decorators;
    }
}

