/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.domain.event;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.SpanEventMapper;
import com.datadog.android.log.Logger;
import com.datadog.android.tracing.model.SpanEvent;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/SpanEventMapperWrapper;", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/tracing/model/SpanEvent;", "wrappedEventMapper", "Lcom/datadog/android/event/SpanEventMapper;", "(Lcom/datadog/android/event/SpanEventMapper;)V", "map", "event", "Companion", "dd-sdk-android_release"})
public final class SpanEventMapperWrapper
implements EventMapper<SpanEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpanEventMapper wrappedEventMapper;
    @NotNull
    public static final String NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE = "SpanEventMapper: the returned mapped object was not the same instance as the original object. This event will be dropped: %s";

    public SpanEventMapperWrapper(@NotNull SpanEventMapper wrappedEventMapper) {
        Intrinsics.checkNotNullParameter((Object)wrappedEventMapper, (String)"wrappedEventMapper");
        this.wrappedEventMapper = wrappedEventMapper;
    }

    @Override
    @Nullable
    public SpanEvent map(@NotNull SpanEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SpanEvent mappedEvent = this.wrappedEventMapper.map(event);
        if (mappedEvent != event) {
            Logger logger = RuntimeUtilsKt.getDevLogger();
            String string = NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(logger, string2, null, null, 6, null);
            return null;
        }
        return mappedEvent;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/SpanEventMapperWrapper$Companion;", "", "()V", "NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

