/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.log.Logger;
import com.datadog.android.tracing.NoOpTracedRequestListener;
import com.datadog.android.tracing.TracedRequestListener;
import com.datadog.android.tracing.internal.TracesFeature;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.DDTracer;
import com.datadog.trace.api.interceptor.MutableSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u001f\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB=\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\r\u0010\"\u001a\u00020#H\u0010\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010,\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020!H\u0002J \u00102\u001a\u00020*2\u0006\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0010\u00103\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J.\u00104\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\u001e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010-\u001a\u0004\u0018\u00010.H\u0014J\b\u00105\u001a\u00020\u000eH\u0002J\n\u00106\u001a\u0004\u0018\u00010\u000eH\u0002J \u00107\u001a\u0002082\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001eH\u0002R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006:"}, d2={"Lcom/datadog/android/tracing/TracingInterceptor;", "Lokhttp3/Interceptor;", "tracedHosts", "", "", "tracedRequestListener", "Lcom/datadog/android/tracing/TracedRequestListener;", "(Ljava/util/List;Lcom/datadog/android/tracing/TracedRequestListener;)V", "(Lcom/datadog/android/tracing/TracedRequestListener;)V", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "traceOrigin", "localTracerFactory", "Lkotlin/Function0;", "Lio/opentracing/Tracer;", "(Ljava/util/List;Lcom/datadog/android/tracing/TracedRequestListener;Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getFirstPartyHostDetector$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "localFirstPartyHostDetector", "getLocalTracerFactory$dd_sdk_android_release", "()Lkotlin/jvm/functions/Function0;", "localTracerReference", "Ljava/util/concurrent/atomic/AtomicReference;", "getTraceOrigin$dd_sdk_android_release", "()Ljava/lang/String;", "getTracedHosts$dd_sdk_android_release", "()Ljava/util/List;", "getTracedRequestListener$dd_sdk_android_release", "()Lcom/datadog/android/tracing/TracedRequestListener;", "buildSpan", "Lio/opentracing/Span;", "tracer", "request", "Lokhttp3/Request;", "canSendSpan", "", "canSendSpan$dd_sdk_android_release", "extractParentContext", "Lio/opentracing/SpanContext;", "handleResponse", "", "response", "Lokhttp3/Response;", "span", "handleThrowable", "throwable", "", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "interceptAndTrace", "isRequestTraceable", "onRequestIntercepted", "resolveLocalTracer", "resolveTracer", "updateRequest", "Lokhttp3/Request$Builder;", "Companion", "dd-sdk-android_release"})
public class TracingInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> tracedHosts;
    @NotNull
    private final TracedRequestListener tracedRequestListener;
    @NotNull
    private final FirstPartyHostDetector firstPartyHostDetector;
    @Nullable
    private final String traceOrigin;
    @NotNull
    private final Function0<Tracer> localTracerFactory;
    @NotNull
    private final AtomicReference<Tracer> localTracerReference;
    @NotNull
    private final FirstPartyHostDetector localFirstPartyHostDetector;
    @NotNull
    public static final String SPAN_NAME = "okhttp.request";
    @NotNull
    public static final String RESOURCE_NAME_404 = "404";
    @NotNull
    public static final String HEADER_CT = "Content-Type";
    @NotNull
    public static final String WARNING_TRACING_NO_HOSTS = "You added a TracingInterceptor to your OkHttpClient, but you did not specify any first party hosts. Your requests won't be traced.\nTo set a list of known hosts, you can use the Configuration.Builder::setFirstPartyHosts() method.";
    @NotNull
    public static final String WARNING_TRACING_DISABLED = "You added a TracingInterceptor to your OkHttpClient, but you did not enable the TracingFeature. Your requests won't be traced.";
    @NotNull
    public static final String WARNING_DEFAULT_TRACER = "You added a TracingInterceptor to your OkHttpClient, but you didn't register any Tracer. We automatically created a local tracer for you.";

    public TracingInterceptor(@NotNull List<String> tracedHosts, @NotNull TracedRequestListener tracedRequestListener, @NotNull FirstPartyHostDetector firstPartyHostDetector, @Nullable String traceOrigin, @NotNull Function0<? extends Tracer> localTracerFactory) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        Intrinsics.checkNotNullParameter(localTracerFactory, (String)"localTracerFactory");
        this.tracedHosts = tracedHosts;
        this.tracedRequestListener = tracedRequestListener;
        this.firstPartyHostDetector = firstPartyHostDetector;
        this.traceOrigin = traceOrigin;
        this.localTracerFactory = localTracerFactory;
        this.localTracerReference = new AtomicReference();
        this.localFirstPartyHostDetector = new FirstPartyHostDetector(this.tracedHosts);
        if (this.localFirstPartyHostDetector.isEmpty() && this.firstPartyHostDetector.isEmpty()) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), WARNING_TRACING_NO_HOSTS, null, null, 6, null);
        }
    }

    @NotNull
    public final List<String> getTracedHosts$dd_sdk_android_release() {
        return this.tracedHosts;
    }

    @NotNull
    public final TracedRequestListener getTracedRequestListener$dd_sdk_android_release() {
        return this.tracedRequestListener;
    }

    @NotNull
    public final FirstPartyHostDetector getFirstPartyHostDetector$dd_sdk_android_release() {
        return this.firstPartyHostDetector;
    }

    @Nullable
    public final String getTraceOrigin$dd_sdk_android_release() {
        return this.traceOrigin;
    }

    @NotNull
    public final Function0<Tracer> getLocalTracerFactory$dd_sdk_android_release() {
        return this.localTracerFactory;
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull List<String> tracedHosts, @NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedHosts, tracedRequestListener, CoreFeature.INSTANCE.getFirstPartyHostDetector$dd_sdk_android_release(), null, (Function0<? extends Tracer>)((Function0)1.INSTANCE));
    }

    public /* synthetic */ TracingInterceptor(List list, TracedRequestListener tracedRequestListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        this(list, tracedRequestListener);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(CollectionsKt.emptyList(), tracedRequestListener, CoreFeature.INSTANCE.getFirstPartyHostDetector$dd_sdk_android_release(), null, (Function0<? extends Tracer>)((Function0)2.INSTANCE));
    }

    public /* synthetic */ TracingInterceptor(TracedRequestListener tracedRequestListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        this(tracedRequestListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Tracer tracer = this.resolveTracer();
        Request request = chain.request();
        if (tracer != null) {
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
            if (this.isRequestTraceable(request)) {
                response = this.interceptAndTrace(chain, request, tracer);
                return response;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
        response = this.intercept(chain, request);
        return response;
    }

    protected void onRequestIntercepted(@NotNull Request request, @Nullable Span span, @Nullable Response response, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (span != null) {
            this.tracedRequestListener.onRequestIntercepted(request, span, response, throwable);
        }
    }

    public boolean canSendSpan$dd_sdk_android_release() {
        return true;
    }

    private final boolean isRequestTraceable(Request request) {
        HttpUrl url = request.url();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        return this.firstPartyHostDetector.isFirstPartyUrl(url) || this.localFirstPartyHostDetector.isFirstPartyUrl(url);
    }

    private final Response interceptAndTrace(Interceptor.Chain chain, Request request, Tracer tracer) {
        Span span = this.buildSpan(tracer, request);
        Request updatedRequest = this.updateRequest(request, tracer, span).build();
        try {
            Response response = chain.proceed(updatedRequest);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            this.handleResponse(request, response, span);
            return response;
        }
        catch (Throwable e) {
            this.handleThrowable(request, e, span);
            throw e;
        }
    }

    private final Response intercept(Interceptor.Chain chain, Request request) {
        try {
            Response response = chain.proceed(request);
            this.onRequestIntercepted(request, null, response, null);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (Throwable e) {
            this.onRequestIntercepted(request, null, null, e);
            throw e;
        }
    }

    private final synchronized Tracer resolveTracer() {
        Tracer tracer;
        if (!TracesFeature.INSTANCE.getInitialized$dd_sdk_android_release().get()) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), WARNING_TRACING_DISABLED, null, null, 6, null);
            tracer = null;
        } else if (GlobalTracer.isRegistered()) {
            this.localTracerReference.set(null);
            tracer = GlobalTracer.get();
        } else {
            tracer = this.resolveLocalTracer();
        }
        return tracer;
    }

    private final Tracer resolveLocalTracer() {
        if (this.localTracerReference.get() == null) {
            this.localTracerReference.compareAndSet(null, (Tracer)this.localTracerFactory.invoke());
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), WARNING_DEFAULT_TRACER, null, null, 6, null);
        }
        Tracer tracer = this.localTracerReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)tracer, (String)"localTracerReference.get()");
        return tracer;
    }

    private final Span buildSpan(Tracer tracer, Request request) {
        MutableSpan mutableSpan;
        DDTracer.DDSpanBuilder dDSpanBuilder;
        SpanContext parentContext = this.extractParentContext(tracer, request);
        String string = request.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
        String url = string;
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(SPAN_NAME);
        DDTracer.DDSpanBuilder dDSpanBuilder2 = dDSpanBuilder = spanBuilder instanceof DDTracer.DDSpanBuilder ? (DDTracer.DDSpanBuilder)spanBuilder : null;
        if (dDSpanBuilder != null) {
            dDSpanBuilder.withOrigin(this.traceOrigin);
        }
        Span span = spanBuilder.asChildOf(parentContext).start();
        MutableSpan mutableSpan2 = mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
        if (mutableSpan != null) {
            mutableSpan.setResourceName(url);
        }
        span.setTag(Tags.HTTP_URL.getKey(), url);
        span.setTag(Tags.HTTP_METHOD.getKey(), request.method());
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"span");
        return span;
    }

    /*
     * WARNING - void declaration
     */
    private final SpanContext extractParentContext(Tracer tracer, Request request) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Span span = (Span)request.tag(Span.class);
        SpanContext tagContext = span == null ? null : span.context();
        Map map = request.headers().toMultimap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"request.headers().toMultimap()");
        Format format = Format.Builtin.TEXT_MAP_EXTRACT;
        Tracer tracer2 = tracer;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_12 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var10_12.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            Pair pair = TuplesKt.to(k, (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)v), (CharSequence)";", null, null, (int)0, null, null, (int)62, null));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map map2 = MapsKt.toMap((Iterable)collection);
        SpanContext headerContext = tracer2.extract(format, (Object)new TextMapExtractAdapter(map2));
        map = headerContext;
        return map == null ? tagContext : map;
    }

    private final Request.Builder updateRequest(Request request, Tracer tracer, Span span) {
        Request.Builder tracedRequestBuilder = request.newBuilder();
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (arg_0, arg_1) -> TracingInterceptor.updateRequest$lambda-1(tracedRequestBuilder, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)tracedRequestBuilder, (String)"tracedRequestBuilder");
        return tracedRequestBuilder;
    }

    private final void handleResponse(Request request, Response response, Span span) {
        int statusCode = response.code();
        Object object = span;
        if (object != null) {
            object.setTag(Tags.HTTP_STATUS.getKey(), (Number)statusCode);
        }
        boolean bl = 400 <= statusCode ? statusCode <= 499 : false;
        if (bl) {
            MutableSpan mutableSpan = object = span instanceof MutableSpan ? (MutableSpan)span : null;
            if (object != null) {
                object.setError(true);
            }
        }
        if (statusCode == 404) {
            MutableSpan mutableSpan = object = span instanceof MutableSpan ? (MutableSpan)span : null;
            if (object != null) {
                object.setResourceName(RESOURCE_NAME_404);
            }
        }
        this.onRequestIntercepted(request, span, response, null);
        if (this.canSendSpan$dd_sdk_android_release()) {
            object = span;
            if (object != null) {
                object.finish();
            }
        } else {
            MutableSpan mutableSpan = object = span instanceof DDSpan ? (DDSpan)span : null;
            if (object != null) {
                ((DDSpan)object).drop();
            }
        }
    }

    private final void handleThrowable(Request request, Throwable throwable, Span span) {
        MutableSpan mutableSpan;
        MutableSpan mutableSpan2 = mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
        if (mutableSpan != null) {
            mutableSpan.setError(true);
        }
        span.setTag("error.msg", throwable.getMessage());
        span.setTag("error.type", throwable.getClass().getName());
        span.setTag("error.stack", ThrowableExtKt.loggableStackTrace(throwable));
        this.onRequestIntercepted(request, span, null, throwable);
        if (this.canSendSpan$dd_sdk_android_release()) {
            span.finish();
        } else {
            MutableSpan mutableSpan3 = mutableSpan = span instanceof DDSpan ? (DDSpan)span : null;
            if (mutableSpan != null) {
                ((DDSpan)mutableSpan).drop();
            }
        }
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull List<String> tracedHosts) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        this(tracedHosts, null, 2, null);
    }

    @JvmOverloads
    public TracingInterceptor() {
        this(null, 1, null);
    }

    private static final void updateRequest$lambda-1(Request.Builder $tracedRequestBuilder, String key, String value) {
        $tracedRequestBuilder.removeHeader(key);
        $tracedRequestBuilder.addHeader(key, value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/tracing/TracingInterceptor$Companion;", "", "()V", "HEADER_CT", "", "RESOURCE_NAME_404", "SPAN_NAME", "WARNING_DEFAULT_TRACER", "WARNING_TRACING_DISABLED", "WARNING_TRACING_NO_HOSTS", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

