/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.tracing.internal.TracesFeature;
import com.datadog.android.tracing.internal.data.TraceWriter;
import com.datadog.android.tracing.internal.handlers.AndroidSpanLogsHandler;
import com.datadog.opentracing.DDTracer;
import com.datadog.opentracing.LogHandler;
import com.datadog.trace.api.Config;
import io.opentracing.Span;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\u00060\u000eR\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00060\u000eR\u00020\u0001*\u00060\u000eR\u00020\u0001H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/tracing/AndroidTracer;", "Lcom/datadog/opentracing/DDTracer;", "config", "Lcom/datadog/trace/api/Config;", "writer", "Lcom/datadog/android/tracing/internal/data/TraceWriter;", "random", "Ljava/util/Random;", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "bundleWithRum", "", "(Lcom/datadog/trace/api/Config;Lcom/datadog/android/tracing/internal/data/TraceWriter;Ljava/util/Random;Lcom/datadog/opentracing/LogHandler;Z)V", "buildSpan", "Lcom/datadog/opentracing/DDTracer$DDSpanBuilder;", "operationName", "", "withRumContext", "Builder", "Companion", "dd-sdk-android_release"})
public final class AndroidTracer
extends DDTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogHandler logsHandler;
    private final boolean bundleWithRum;
    @NotNull
    public static final String TRACING_NOT_ENABLED_ERROR_MESSAGE = "You're trying to create an AndroidTracer instance, but the Tracing feature was disabled in your Configuration. No tracing data will be sent.";
    @NotNull
    public static final String RUM_NOT_ENABLED_ERROR_MESSAGE = "You're trying to bundle the traces with a RUM context, but the RUM feature was disabled in your Configuration. No RUM context will be attached to your traces in this case.";
    public static final int DEFAULT_PARTIAL_MIN_FLUSH = 5;
    @NotNull
    public static final String TRACE_LOGGER_NAME = "trace";
    public static final int TRACE_ID_BIT_SIZE = 63;

    public AndroidTracer(@NotNull Config config, @NotNull TraceWriter writer, @NotNull Random random2, @NotNull LogHandler logsHandler, boolean bundleWithRum) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
        Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
        super(config, writer, random2);
        this.logsHandler = logsHandler;
        this.bundleWithRum = bundleWithRum;
    }

    @Override
    @NotNull
    public DDTracer.DDSpanBuilder buildSpan(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        DDTracer.DDSpanBuilder dDSpanBuilder = new DDTracer.DDSpanBuilder(operationName, this.scopeManager()).withLogHandler(this.logsHandler);
        Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder, (String)"DDSpanBuilder(operationName, scopeManager())\n            .withLogHandler(logsHandler)");
        return this.withRumContext(dDSpanBuilder);
    }

    private final DDTracer.DDSpanBuilder withRumContext(DDTracer.DDSpanBuilder $this$withRumContext) {
        DDTracer.DDSpanBuilder dDSpanBuilder;
        if (this.bundleWithRum) {
            RumContext rumContext = GlobalRum.INSTANCE.getRumContext$dd_sdk_android_release();
            DDTracer.DDSpanBuilder dDSpanBuilder2 = $this$withRumContext.withTag("application_id", rumContext.getApplicationId()).withTag("session_id", rumContext.getSessionId()).withTag("view.id", rumContext.getViewId()).withTag("user_action.id", rumContext.getActionId());
            Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder2, (String)"{\n            val rumContext = GlobalRum.getRumContext()\n            withTag(LogAttributes.RUM_APPLICATION_ID, rumContext.applicationId)\n                .withTag(LogAttributes.RUM_SESSION_ID, rumContext.sessionId)\n                .withTag(LogAttributes.RUM_VIEW_ID, rumContext.viewId)\n                .withTag(LogAttributes.RUM_ACTION_ID, rumContext.actionId)\n        }");
            dDSpanBuilder = dDSpanBuilder2;
        } else {
            dDSpanBuilder = $this$withRumContext;
        }
        return dDSpanBuilder;
    }

    @JvmStatic
    public static final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
        Companion.logThrowable(span, throwable);
    }

    @JvmStatic
    public static final void logErrorMessage(@NotNull Span span, @NotNull String message) {
        Companion.logErrorMessage(span, message);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007J\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/tracing/AndroidTracer$Builder;", "", "()V", "bundleWithRumEnabled", "", "globalTags", "", "", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "partialFlushThreshold", "", "random", "Ljava/util/Random;", "serviceName", "addGlobalTag", "key", "value", "build", "Lcom/datadog/android/tracing/AndroidTracer;", "config", "Lcom/datadog/trace/api/Config;", "properties", "Ljava/util/Properties;", "properties$dd_sdk_android_release", "setBundleWithRumEnabled", "enabled", "setPartialFlushThreshold", "threshold", "setServiceName", "withRandom", "withRandom$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Builder {
        private boolean bundleWithRumEnabled = true;
        @NotNull
        private String serviceName = CoreFeature.INSTANCE.getServiceName$dd_sdk_android_release();
        private int partialFlushThreshold = 5;
        @NotNull
        private Random random = new SecureRandom();
        @NotNull
        private final LogHandler logsHandler;
        @NotNull
        private final Map<String, String> globalTags;

        public Builder() {
            boolean bl = false;
            this.globalTags = new LinkedHashMap();
            Logger logger = new Logger.Builder().setLoggerName(AndroidTracer.TRACE_LOGGER_NAME).build();
            this.logsHandler = new AndroidSpanLogsHandler(logger);
        }

        @NotNull
        public final AndroidTracer build() {
            if (!TracesFeature.INSTANCE.isInitialized()) {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), AndroidTracer.TRACING_NOT_ENABLED_ERROR_MESSAGE, null, null, 6, null);
            }
            if (this.bundleWithRumEnabled && !RumFeature.INSTANCE.isInitialized()) {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), AndroidTracer.RUM_NOT_ENABLED_ERROR_MESSAGE, null, null, 6, null);
                this.bundleWithRumEnabled = false;
            }
            return new AndroidTracer(this.config(), new TraceWriter(TracesFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getWriter()), this.random, this.logsHandler, this.bundleWithRumEnabled);
        }

        @NotNull
        public final Builder setServiceName(@NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @NotNull
        public final Builder setPartialFlushThreshold(int threshold) {
            this.partialFlushThreshold = threshold;
            return this;
        }

        @NotNull
        public final Builder addGlobalTag(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Map<String, String> map = this.globalTags;
            boolean bl = false;
            map.put(key, value);
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder withRandom$dd_sdk_android_release(@NotNull Random random2) {
            Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
            this.random = random2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Properties properties$dd_sdk_android_release() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Properties properties = new Properties();
            properties.setProperty("service.name", this.serviceName);
            properties.setProperty("trace.partial.flush.min.spans", String.valueOf(this.partialFlushThreshold));
            Map<String, String> map = this.globalTags;
            String string = "tags";
            Properties properties2 = properties;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_9 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_9.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = (String)it.getKey() + ':' + (String)it.getValue();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            properties2.setProperty(string, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            return properties;
        }

        private final Config config() {
            Config config = Config.get(this.properties$dd_sdk_android_release());
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"get(properties())");
            return config;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/tracing/AndroidTracer$Companion;", "", "()V", "DEFAULT_PARTIAL_MIN_FLUSH", "", "RUM_NOT_ENABLED_ERROR_MESSAGE", "", "TRACE_ID_BIT_SIZE", "TRACE_LOGGER_NAME", "TRACING_NOT_ENABLED_ERROR_MESSAGE", "logErrorMessage", "", "span", "Lio/opentracing/Span;", "message", "logThrowable", "throwable", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.object", (Object)throwable));
            span.log(fieldsMap);
        }

        @JvmStatic
        public final void logErrorMessage(@NotNull Span span, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
            span.log(fieldsMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

