/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.content.ComponentName;
import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.navigation.ActivityKt;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.fragment.DialogFragmentNavigator;
import androidx.navigation.fragment.FragmentNavigator;
import androidx.navigation.fragment.NavHostFragment;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.NoOpRumMonitor;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.EventType;
import com.datadog.android.rum.internal.monitor.NoOpAdvancedRumMonitor;
import com.datadog.android.rum.internal.tracking.AndroidXFragmentLifecycleCallbacks;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.AcceptAllNavDestinations;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003!\"#B'\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\"\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u0019*\u00020\u000e2\b\b\u0001\u0010\u001e\u001a\u00020\u0005H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "navigationViewId", "", "trackArguments", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "Landroidx/navigation/NavDestination;", "(IZLcom/datadog/android/rum/tracking/ComponentPredicate;)V", "lifecycleCallbackRefs", "Ljava/util/WeakHashMap;", "Landroid/app/Activity;", "Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "predicate", "Landroidx/fragment/app/Fragment;", "onActivityPaused", "", "activity", "onActivityStarted", "onActivityStopped", "onDestinationChanged", "controller", "Landroidx/navigation/NavController;", "destination", "arguments", "Landroid/os/Bundle;", "findNavControllerOrNull", "viewId", "getRumViewName", "", "AdvancedMonitorDecorator", "Companion", "NavControllerFragmentLifecycleCallbacks", "dd-sdk-android_release"})
public final class NavigationViewTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements ViewTrackingStrategy,
NavController.OnDestinationChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int navigationViewId;
    private final boolean trackArguments;
    @NotNull
    private final ComponentPredicate<NavDestination> componentPredicate;
    @NotNull
    private WeakHashMap<Activity, NavControllerFragmentLifecycleCallbacks> lifecycleCallbackRefs;
    @NotNull
    private final ComponentPredicate<Fragment> predicate;
    @NotNull
    public static final String UNKNOWN_DESTINATION_NAME = "Unknown";

    public NavigationViewTrackingStrategy(@IdRes int navigationViewId, boolean trackArguments, @NotNull ComponentPredicate<NavDestination> componentPredicate) {
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        this.navigationViewId = navigationViewId;
        this.trackArguments = trackArguments;
        this.componentPredicate = componentPredicate;
        this.lifecycleCallbackRefs = new WeakHashMap();
        this.predicate = new ComponentPredicate<Fragment>(){

            public boolean accept(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return !NavHostFragment.class.isAssignableFrom(component.getClass());
            }

            @Nullable
            public String getViewName(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return null;
            }
        };
    }

    public /* synthetic */ NavigationViewTrackingStrategy(int n, boolean bl, ComponentPredicate componentPredicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            componentPredicate = new AcceptAllNavDestinations();
        }
        this(n, bl, componentPredicate);
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        NavController navController = this.findNavControllerOrNull(activity, this.navigationViewId);
        if (navController != null) {
            NavController navController2 = navController;
            boolean bl = false;
            boolean bl2 = false;
            NavController it = navController2;
            boolean bl3 = false;
            if (FragmentActivity.class.isAssignableFrom(activity.getClass())) {
                NavControllerFragmentLifecycleCallbacks navControllerFragmentCallbacks2 = new NavControllerFragmentLifecycleCallbacks(it, (Function1<? super Fragment, ? extends Map<String, ? extends Object>>)((Function1)onActivityStarted.1.navControllerFragmentCallbacks.1.INSTANCE), this.predicate);
                navControllerFragmentCallbacks2.register((FragmentActivity)activity);
                Map map = this.lifecycleCallbackRefs;
                boolean bl4 = false;
                map.put(activity, navControllerFragmentCallbacks2);
            }
            it.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
        }
    }

    @Override
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStopped(activity);
        NavController navController = this.findNavControllerOrNull(activity, this.navigationViewId);
        if (navController != null) {
            NavControllerFragmentLifecycleCallbacks navControllerFragmentLifecycleCallbacks;
            NavController navController2 = navController;
            boolean bl = false;
            boolean bl2 = false;
            NavController it = navController2;
            boolean bl3 = false;
            it.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            if (FragmentActivity.class.isAssignableFrom(activity.getClass()) && (navControllerFragmentLifecycleCallbacks = this.lifecycleCallbackRefs.remove(activity)) != null) {
                navControllerFragmentLifecycleCallbacks.unregister((FragmentActivity)activity);
            }
        }
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        NavDestination navDestination;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityPaused(activity);
        NavController navController = this.findNavControllerOrNull(activity, this.navigationViewId);
        if (navController != null && (navDestination = navController.getCurrentDestination()) != null) {
            NavDestination navDestination2 = navDestination;
            boolean bl = false;
            boolean bl2 = false;
            NavDestination it = navDestination2;
            boolean bl3 = false;
            RumMonitor.DefaultImpls.stopView$default(GlobalRum.get(), it, null, 2, null);
        }
    }

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ComponentPredicate<NavDestination> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(destination)) {
            NavDestination it = destination;
            boolean bl = false;
            Map<String, Object> attributes = this.trackArguments ? this.convertToRumAttributes(arguments) : MapsKt.emptyMap();
            ComponentPredicate<NavDestination> $this$resolveViewName$iv = this.componentPredicate;
            boolean $i$f$resolveViewName = false;
            String customName$iv = $this$resolveViewName$iv.getViewName(destination);
            CharSequence charSequence = customName$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(destination) : customName$iv;
            GlobalRum.get().startView(destination, viewName, attributes);
        }
    }

    private final NavController findNavControllerOrNull(Activity $this$findNavControllerOrNull, @IdRes int viewId) {
        NavController navController;
        try {
            navController = ActivityKt.findNavController((Activity)$this$findNavControllerOrNull, (int)viewId);
        }
        catch (IllegalArgumentException e) {
            navController = null;
        }
        catch (IllegalStateException e) {
            navController = null;
        }
        return navController;
    }

    private final String getRumViewName(NavDestination $this$getRumViewName) {
        String string;
        NavDestination navDestination = $this$getRumViewName;
        if (navDestination instanceof FragmentNavigator.Destination) {
            String string2 = ((FragmentNavigator.Destination)$this$getRumViewName).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className");
            string = string2;
        } else if (navDestination instanceof DialogFragmentNavigator.Destination) {
            String string3 = ((DialogFragmentNavigator.Destination)$this$getRumViewName).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"className");
            string = string3;
        } else {
            String string4;
            ComponentName componentName;
            String string5;
            string = navDestination instanceof ActivityNavigator.Destination ? (string5 = (componentName = ((ActivityNavigator.Destination)$this$getRumViewName).getComponent()) == null ? UNKNOWN_DESTINATION_NAME : ((string4 = componentName.getClassName()) == null ? UNKNOWN_DESTINATION_NAME : string4)) : UNKNOWN_DESTINATION_NAME;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "navController", "Landroidx/navigation/NavController;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "(Landroidx/navigation/NavController;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;)V", "resolveKey", "fragment", "Companion", "dd-sdk-android_release"})
    public static final class NavControllerFragmentLifecycleCallbacks
    extends AndroidXFragmentLifecycleCallbacks {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NavController navController;
        @NotNull
        private static final Object NO_DESTINATION_FOUND = new Object();

        public NavControllerFragmentLifecycleCallbacks(@NotNull NavController navController, @NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate) {
            Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
            Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
            Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
            RumMonitor rumMonitor = GlobalRum.get();
            AdvancedRumMonitor advancedRumMonitor = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
            super(argumentsProvider, componentPredicate, null, new NoOpRumMonitor(), new AdvancedMonitorDecorator(advancedRumMonitor == null ? (AdvancedRumMonitor)new NoOpAdvancedRumMonitor() : advancedRumMonitor), 4, null);
            this.navController = navController;
        }

        @Override
        @NotNull
        public Object resolveKey(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            NavDestination navDestination = this.navController.getCurrentDestination();
            return navDestination == null ? NO_DESTINATION_FOUND : navDestination;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks$Companion;", "", "()V", "NO_DESTINATION_FOUND", "getNO_DESTINATION_FOUND", "()Ljava/lang/Object;", "dd-sdk-android_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Object getNO_DESTINATION_FOUND() {
                return NO_DESTINATION_FOUND;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J9\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J9\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J\u0019\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0096\u0001J/\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J\u0019\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020!H\u0096\u0001J\u0019\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020!H\u0096\u0001J\t\u0010#\u001a\u00020\u0005H\u0096\u0001J7\u0010$\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J/\u0010'\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J/\u0010(\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001JH\u0010)\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001\u00a2\u0006\u0002\u0010/JN\u00100\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001\u00a2\u0006\u0002\u00101J/\u00102\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00072\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J\u001f\u00102\u001a\u00020\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0097\u0001J'\u00103\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0096\u0001J \u00104\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u000206H\u0016J\u0011\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209H\u0096\u0001J\u0011\u0010:\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$AdvancedMonitorDecorator;", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "advancedRumMonitor", "(Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "addCrash", "", "message", "", "source", "Lcom/datadog/android/rum/RumErrorSource;", "throwable", "", "addError", "attributes", "", "", "addErrorWithStacktrace", "stacktrace", "addLongTask", "durationNs", "", "target", "addResourceTiming", "key", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "addTiming", "name", "addUserAction", "type", "Lcom/datadog/android/rum/RumActionType;", "eventDropped", "viewId", "Lcom/datadog/android/rum/internal/monitor/EventType;", "eventSent", "resetSession", "startResource", "method", "url", "startUserAction", "startView", "stopResource", "statusCode", "", "size", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "stopResourceWithError", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "stopUserAction", "stopView", "updateViewLoadingTime", "loadingTimeInNs", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "viewTreeChanged", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "waitForResourceTiming", "dd-sdk-android_release"})
    public static final class AdvancedMonitorDecorator
    implements AdvancedRumMonitor {
        @NotNull
        private final AdvancedRumMonitor advancedRumMonitor;

        public AdvancedMonitorDecorator(@NotNull AdvancedRumMonitor advancedRumMonitor) {
            Intrinsics.checkNotNullParameter((Object)advancedRumMonitor, (String)"advancedRumMonitor");
            this.advancedRumMonitor = advancedRumMonitor;
        }

        @Override
        @Deprecated(message="This method is deprecated. Please use RumMonitor#stopUserAction(type, name, attributes) instead")
        public void stopUserAction(@NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopUserAction(attributes);
        }

        @Override
        public void addCrash(@NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            this.advancedRumMonitor.addCrash(message, source, throwable);
        }

        @Override
        public void addError(@NotNull String message, @NotNull RumErrorSource source, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addError(message, source, throwable, attributes);
        }

        @Override
        public void addErrorWithStacktrace(@NotNull String message, @NotNull RumErrorSource source, @Nullable String stacktrace, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addErrorWithStacktrace(message, source, stacktrace, attributes);
        }

        @Override
        public void addLongTask(long durationNs, @NotNull String target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.advancedRumMonitor.addLongTask(durationNs, target);
        }

        @Override
        public void addResourceTiming(@NotNull String key, @NotNull ResourceTiming timing) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)timing, (String)"timing");
            this.advancedRumMonitor.addResourceTiming(key, timing);
        }

        @Override
        public void addTiming(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.advancedRumMonitor.addTiming(name);
        }

        @Override
        public void addUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.addUserAction(type, name, attributes);
        }

        @Override
        public void eventDropped(@NotNull String viewId, @NotNull EventType type) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.advancedRumMonitor.eventDropped(viewId, type);
        }

        @Override
        public void eventSent(@NotNull String viewId, @NotNull EventType type) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.advancedRumMonitor.eventSent(viewId, type);
        }

        @Override
        public void resetSession() {
            this.advancedRumMonitor.resetSession();
        }

        @Override
        public void startResource(@NotNull String key, @NotNull String method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startResource(key, method, url, attributes);
        }

        @Override
        public void startUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startUserAction(type, name, attributes);
        }

        @Override
        public void startView(@NotNull Object key, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.startView(key, name, attributes);
        }

        @Override
        public void stopResource(@NotNull String key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopResource(key, statusCode, size, kind, attributes);
        }

        @Override
        public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopResourceWithError(key, statusCode, message, source, throwable, attributes);
        }

        @Override
        public void stopUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopUserAction(type, name, attributes);
        }

        @Override
        public void stopView(@NotNull Object key, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.advancedRumMonitor.stopView(key, attributes);
        }

        @Override
        public void viewTreeChanged(@NotNull Time eventTime) {
            Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
            this.advancedRumMonitor.viewTreeChanged(eventTime);
        }

        @Override
        public void waitForResourceTiming(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.advancedRumMonitor.waitForResourceTiming(key);
        }

        @Override
        public void updateViewLoadingTime(@NotNull Object key, long loadingTimeInNs, @NotNull ViewEvent.LoadingType type) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (!Intrinsics.areEqual((Object)key, (Object)NavControllerFragmentLifecycleCallbacks.Companion.getNO_DESTINATION_FOUND())) {
                this.advancedRumMonitor.updateViewLoadingTime(key, loadingTimeInNs, type);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$Companion;", "", "()V", "UNKNOWN_DESTINATION_NAME", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

