/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import android.view.Choreographer;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/vitals/VitalFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "observer", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "keepRunning", "Lkotlin/Function0;", "", "(Lcom/datadog/android/rum/internal/vitals/VitalObserver;Lkotlin/jvm/functions/Function0;)V", "lastFrameTimestampNs", "", "doFrame", "", "frameTimeNanos", "Companion", "dd-sdk-android_release"})
public final class VitalFrameCallback
implements Choreographer.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VitalObserver observer;
    @NotNull
    private final Function0<Boolean> keepRunning;
    private long lastFrameTimestampNs;
    private static final double ONE_SECOND_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final double MIN_FPS = 1.0;
    private static final double MAX_FPS = 240.0;
    @NotNull
    private static final ClosedFloatingPointRange<Double> VALID_FPS_RANGE = RangesKt.rangeTo((double)1.0, (double)240.0);

    public VitalFrameCallback(@NotNull VitalObserver observer, @NotNull Function0<Boolean> keepRunning) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter(keepRunning, (String)"keepRunning");
        this.observer = observer;
        this.keepRunning = keepRunning;
    }

    public void doFrame(long frameTimeNanos) {
        double frameRate;
        double durationNs;
        if (this.lastFrameTimestampNs != 0L && (durationNs = (double)(frameTimeNanos - this.lastFrameTimestampNs)) > 0.0 && VALID_FPS_RANGE.contains((Comparable)Double.valueOf(frameRate = ONE_SECOND_NS / durationNs))) {
            this.observer.onNewSample(frameRate);
        }
        this.lastFrameTimestampNs = frameTimeNanos;
        if (((Boolean)this.keepRunning.invoke()).booleanValue()) {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/vitals/VitalFrameCallback$Companion;", "", "()V", "MAX_FPS", "", "MIN_FPS", "ONE_SECOND_NS", "getONE_SECOND_NS", "()D", "VALID_FPS_RANGE", "Lkotlin/ranges/ClosedFloatingPointRange;", "getVALID_FPS_RANGE", "()Lkotlin/ranges/ClosedFloatingPointRange;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final double getONE_SECOND_NS() {
            return ONE_SECOND_NS;
        }

        @NotNull
        public final ClosedFloatingPointRange<Double> getVALID_FPS_RANGE() {
            return VALID_FPS_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

