/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.app.Activity;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.TrackingStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/tracking/ViewTreeChangeTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "()V", "getViewTreeObserver", "Landroid/view/ViewTreeObserver;", "activity", "Landroid/app/Activity;", "onActivityStarted", "", "onActivityStopped", "onGlobalLayout", "dd-sdk-android_release"})
public final class ViewTreeChangeTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements TrackingStrategy,
ViewTreeObserver.OnGlobalLayoutListener {
    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        ViewTreeObserver viewTreeObserver;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        ViewTreeObserver viewTreeObserver2 = viewTreeObserver = this.getViewTreeObserver(activity);
        if (viewTreeObserver2 != null) {
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    @Override
    public void onActivityStopped(@NotNull Activity activity) {
        ViewTreeObserver viewTreeObserver;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStopped(activity);
        ViewTreeObserver viewTreeObserver2 = viewTreeObserver = this.getViewTreeObserver(activity);
        if (viewTreeObserver2 != null) {
            viewTreeObserver2.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void onGlobalLayout() {
        AdvancedRumMonitor advancedRumMonitor;
        Time now = new Time(0L, 0L, 3, null);
        RumMonitor rumMonitor = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = advancedRumMonitor = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
        if (advancedRumMonitor != null) {
            advancedRumMonitor.viewTreeChanged(now);
        }
    }

    private final ViewTreeObserver getViewTreeObserver(Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return null;
        }
        Window window2 = window;
        return window2.getDecorView().getViewTreeObserver();
    }
}

