/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesTracker;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.tracking.FragmentLifecycleCallbacks;
import com.datadog.android.rum.internal.tracking.ViewLoadingTimer;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.ComponentPredicate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BO\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0002H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/FragmentLifecycleCallbacks;", "Landroidx/fragment/app/FragmentActivity;", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "viewLoadingTimer", "Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "rumMonitor", "Lcom/datadog/android/rum/RumMonitor;", "advancedRumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "(Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;Lcom/datadog/android/rum/RumMonitor;Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "getArgumentsProvider$dd_sdk_android_release", "()Lkotlin/jvm/functions/Function1;", "onFragmentActivityCreated", "", "fm", "Landroidx/fragment/app/FragmentManager;", "f", "savedInstanceState", "Landroid/os/Bundle;", "onFragmentAttached", "context", "Landroid/content/Context;", "onFragmentDestroyed", "onFragmentPaused", "onFragmentResumed", "onFragmentStarted", "register", "activity", "resolveKey", "fragment", "resolveLoadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "firstTimeLoading", "", "unregister", "dd-sdk-android_release"})
public class AndroidXFragmentLifecycleCallbacks
extends FragmentManager.FragmentLifecycleCallbacks
implements FragmentLifecycleCallbacks<FragmentActivity> {
    @NotNull
    private final Function1<Fragment, Map<String, Object>> argumentsProvider;
    @NotNull
    private final ComponentPredicate<Fragment> componentPredicate;
    @NotNull
    private final ViewLoadingTimer viewLoadingTimer;
    @NotNull
    private final RumMonitor rumMonitor;
    @NotNull
    private final AdvancedRumMonitor advancedRumMonitor;

    public AndroidXFragmentLifecycleCallbacks(@NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull ViewLoadingTimer viewLoadingTimer, @NotNull RumMonitor rumMonitor, @NotNull AdvancedRumMonitor advancedRumMonitor) {
        Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        Intrinsics.checkNotNullParameter((Object)viewLoadingTimer, (String)"viewLoadingTimer");
        Intrinsics.checkNotNullParameter((Object)rumMonitor, (String)"rumMonitor");
        Intrinsics.checkNotNullParameter((Object)advancedRumMonitor, (String)"advancedRumMonitor");
        this.argumentsProvider = argumentsProvider;
        this.componentPredicate = componentPredicate;
        this.viewLoadingTimer = viewLoadingTimer;
        this.rumMonitor = rumMonitor;
        this.advancedRumMonitor = advancedRumMonitor;
    }

    public /* synthetic */ AndroidXFragmentLifecycleCallbacks(Function1 function1, ComponentPredicate componentPredicate, ViewLoadingTimer viewLoadingTimer, RumMonitor rumMonitor, AdvancedRumMonitor advancedRumMonitor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            viewLoadingTimer = new ViewLoadingTimer();
        }
        this((Function1<? super Fragment, ? extends Map<String, ? extends Object>>)function1, componentPredicate, viewLoadingTimer, rumMonitor, advancedRumMonitor);
    }

    @NotNull
    public final Function1<Fragment, Map<String, Object>> getArgumentsProvider$dd_sdk_android_release() {
        return this.argumentsProvider;
    }

    @Override
    public void register(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this, true);
    }

    @Override
    public void unregister(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getSupportFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
    }

    public void onFragmentAttached(@NotNull FragmentManager fm, @NotNull Fragment f, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onFragmentAttached(fm, f, context);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            Fragment it = f;
            boolean bl = false;
            this.viewLoadingTimer.onCreated(this.resolveKey(it));
        }
    }

    public void onFragmentStarted(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentStarted(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            Fragment it = f;
            boolean bl = false;
            this.viewLoadingTimer.onStartLoading(this.resolveKey(it));
        }
    }

    public void onFragmentActivityCreated(@NotNull FragmentManager fm, @NotNull Fragment f, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentActivityCreated(fm, f, savedInstanceState);
        Context context = f.getContext();
        if (f instanceof DialogFragment && context != null) {
            Dialog dialog = ((DialogFragment)f).getDialog();
            Window window = dialog == null ? null : dialog.getWindow();
            GesturesTracker gesturesTracker = RumFeature.INSTANCE.getActionTrackingStrategy$dd_sdk_android_release().getGesturesTracker();
            gesturesTracker.startTracking(window, context);
        }
    }

    public void onFragmentResumed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentResumed(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            Fragment it = f;
            boolean bl = false;
            Object key = this.resolveKey(it);
            this.viewLoadingTimer.onFinishedLoading(key);
            ComponentPredicate<Fragment> $this$resolveViewName$iv = this.componentPredicate;
            boolean $i$f$resolveViewName = false;
            String customName$iv = $this$resolveViewName$iv.getViewName(f);
            CharSequence charSequence = customName$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(f) : customName$iv;
            this.rumMonitor.startView(key, viewName, (Map)this.getArgumentsProvider$dd_sdk_android_release().invoke((Object)it));
            Long loadingTime = this.viewLoadingTimer.getLoadingTime(key);
            if (loadingTime != null) {
                this.advancedRumMonitor.updateViewLoadingTime(key, loadingTime, this.resolveLoadingType(this.viewLoadingTimer.isFirstTimeLoading(key)));
            }
        }
    }

    public void onFragmentPaused(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentPaused(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            Fragment it = f;
            boolean bl = false;
            Object key = this.resolveKey(it);
            RumMonitor.DefaultImpls.stopView$default(this.rumMonitor, key, null, 2, null);
            this.viewLoadingTimer.onPaused(key);
        }
    }

    public void onFragmentDestroyed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentDestroyed(fm, f);
        ComponentPredicate<Fragment> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            Fragment it = f;
            boolean bl = false;
            this.viewLoadingTimer.onDestroyed(this.resolveKey(it));
        }
    }

    @NotNull
    public Object resolveKey(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return fragment;
    }

    private final ViewEvent.LoadingType resolveLoadingType(boolean firstTimeLoading) {
        return firstTimeLoading ? ViewEvent.LoadingType.FRAGMENT_DISPLAY : ViewEvent.LoadingType.FRAGMENT_REDISPLAY;
    }
}

