/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.ndk;

import android.content.Context;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.rum.internal.ndk.NdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashLog;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ViewEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J$\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0,H\u0002J\b\u0010/\u001a\u00020*H\u0002J\b\u00100\u001a\u00020*H\u0002J$\u00101\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0,H\u0016JL\u00102\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0,2\b\u00103\u001a\u0004\u0018\u00010\n2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u00010\u00102\b\u00107\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u00108\u001a\u00020*H\u0016J\b\u00109\u001a\u00020*H\u0002J \u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00172\u0006\u00103\u001a\u00020\n2\u0006\u0010=\u001a\u000205H\u0002JN\u0010>\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010<\u001a\u00020\u00172\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170@2\u0006\u00103\u001a\u00020\n2\b\u00107\u001a\u0004\u0018\u00010\u000e2\b\u00106\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010A\u001a\u0002052\u0006\u00104\u001a\u000205H\u0002J.\u0010B\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0,2\u0006\u0010<\u001a\u00020\u00172\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001c\u0010\"\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashHandler;", "Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "appContext", "Landroid/content/Context;", "dataPersistenceExecutorService", "Ljava/util/concurrent/ExecutorService;", "logGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "ndkCrashLogDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "Lcom/datadog/android/rum/internal/ndk/NdkCrashLog;", "rumEventDeserializer", "", "networkInfoDeserializer", "Lcom/datadog/android/core/model/NetworkInfo;", "userInfoDeserializer", "Lcom/datadog/android/core/model/UserInfo;", "internalLogger", "Lcom/datadog/android/log/Logger;", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "(Landroid/content/Context;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/log/internal/domain/LogGenerator;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/log/Logger;Lcom/datadog/android/core/internal/time/TimeProvider;)V", "lastSerializedNdkCrashLog", "", "getLastSerializedNdkCrashLog$dd_sdk_android_release", "()Ljava/lang/String;", "setLastSerializedNdkCrashLog$dd_sdk_android_release", "(Ljava/lang/String;)V", "lastSerializedNetworkInformation", "getLastSerializedNetworkInformation$dd_sdk_android_release", "setLastSerializedNetworkInformation$dd_sdk_android_release", "lastSerializedRumViewEvent", "getLastSerializedRumViewEvent$dd_sdk_android_release", "setLastSerializedRumViewEvent$dd_sdk_android_release", "lastSerializedUserInformation", "getLastSerializedUserInformation$dd_sdk_android_release", "setLastSerializedUserInformation$dd_sdk_android_release", "getLogGenerator$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/domain/LogGenerator;", "ndkCrashDataDirectory", "Ljava/io/File;", "checkAndHandleNdkCrashReport", "", "logWriter", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "rumWriter", "clearAllReferences", "clearCrashLog", "handleNdkCrash", "handleNdkCrashLog", "ndkCrashLog", "lastViewEvent", "Lcom/datadog/android/rum/model/ViewEvent;", "lastUserInfo", "lastNetworkInfo", "prepareData", "readCrashData", "resolveErrorEventFromViewEvent", "Lcom/datadog/android/rum/model/ErrorEvent;", "errorLogMessage", "viewEvent", "sendCrashLogEvent", "logAttributes", "", "updateViewEvent", "updateViewEventAndSendError", "Companion", "dd-sdk-android_release"})
public final class DatadogNdkCrashHandler
implements NdkCrashHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService dataPersistenceExecutorService;
    @NotNull
    private final LogGenerator logGenerator;
    @NotNull
    private final Deserializer<NdkCrashLog> ndkCrashLogDeserializer;
    @NotNull
    private final Deserializer<Object> rumEventDeserializer;
    @NotNull
    private final Deserializer<NetworkInfo> networkInfoDeserializer;
    @NotNull
    private final Deserializer<UserInfo> userInfoDeserializer;
    @NotNull
    private final Logger internalLogger;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final File ndkCrashDataDirectory;
    @Nullable
    private String lastSerializedRumViewEvent;
    @Nullable
    private String lastSerializedUserInformation;
    @Nullable
    private String lastSerializedNdkCrashLog;
    @Nullable
    private String lastSerializedNetworkInformation;
    private static final long VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD = TimeUnit.HOURS.toMillis(4L);
    @NotNull
    public static final String RUM_VIEW_EVENT_FILE_NAME = "last_view_event";
    @NotNull
    public static final String CRASH_DATA_FILE_NAME = "crash_log";
    @NotNull
    public static final String USER_INFO_FILE_NAME = "user_information";
    @NotNull
    public static final String NETWORK_INFO_FILE_NAME = "network_information";
    @NotNull
    public static final String LOGGER_NAME = "ndk_crash";
    @NotNull
    public static final String LOG_CRASH_MSG = "NDK crash detected with signal: %s";
    @NotNull
    public static final String ERROR_READ_NDK_DIR = "Error while trying to read the NDK crash directory";
    @NotNull
    public static final String NDK_CRASH_REPORTS_FOLDER_NAME = "ndk_crash_reports";
    @NotNull
    private static final String NDK_CRASH_REPORTS_PENDING_FOLDER_NAME = "ndk_crash_reports_intermediary";
    @NotNull
    public static final String DESERIALIZE_CRASH_EVENT_ERROR_MESSAGE = "Error while trying to deserialize the ndk crash log event";

    public DatadogNdkCrashHandler(@NotNull Context appContext, @NotNull ExecutorService dataPersistenceExecutorService, @NotNull LogGenerator logGenerator, @NotNull Deserializer<NdkCrashLog> ndkCrashLogDeserializer, @NotNull Deserializer<Object> rumEventDeserializer, @NotNull Deserializer<NetworkInfo> networkInfoDeserializer, @NotNull Deserializer<UserInfo> userInfoDeserializer, @NotNull Logger internalLogger, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)dataPersistenceExecutorService, (String)"dataPersistenceExecutorService");
        Intrinsics.checkNotNullParameter((Object)logGenerator, (String)"logGenerator");
        Intrinsics.checkNotNullParameter(ndkCrashLogDeserializer, (String)"ndkCrashLogDeserializer");
        Intrinsics.checkNotNullParameter(rumEventDeserializer, (String)"rumEventDeserializer");
        Intrinsics.checkNotNullParameter(networkInfoDeserializer, (String)"networkInfoDeserializer");
        Intrinsics.checkNotNullParameter(userInfoDeserializer, (String)"userInfoDeserializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.dataPersistenceExecutorService = dataPersistenceExecutorService;
        this.logGenerator = logGenerator;
        this.ndkCrashLogDeserializer = ndkCrashLogDeserializer;
        this.rumEventDeserializer = rumEventDeserializer;
        this.networkInfoDeserializer = networkInfoDeserializer;
        this.userInfoDeserializer = userInfoDeserializer;
        this.internalLogger = internalLogger;
        this.timeProvider = timeProvider;
        this.ndkCrashDataDirectory = Companion.getNdkGrantedDir$dd_sdk_android_release(appContext);
    }

    @NotNull
    public final LogGenerator getLogGenerator$dd_sdk_android_release() {
        return this.logGenerator;
    }

    @Nullable
    public final String getLastSerializedRumViewEvent$dd_sdk_android_release() {
        return this.lastSerializedRumViewEvent;
    }

    public final void setLastSerializedRumViewEvent$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedRumViewEvent = string;
    }

    @Nullable
    public final String getLastSerializedUserInformation$dd_sdk_android_release() {
        return this.lastSerializedUserInformation;
    }

    public final void setLastSerializedUserInformation$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedUserInformation = string;
    }

    @Nullable
    public final String getLastSerializedNdkCrashLog$dd_sdk_android_release() {
        return this.lastSerializedNdkCrashLog;
    }

    public final void setLastSerializedNdkCrashLog$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedNdkCrashLog = string;
    }

    @Nullable
    public final String getLastSerializedNetworkInformation$dd_sdk_android_release() {
        return this.lastSerializedNetworkInformation;
    }

    public final void setLastSerializedNetworkInformation$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedNetworkInformation = string;
    }

    @Override
    public void prepareData() {
        this.dataPersistenceExecutorService.submit(() -> DatadogNdkCrashHandler.prepareData$lambda-0(this));
    }

    @Override
    public void handleNdkCrash(@NotNull DataWriter<LogEvent> logWriter, @NotNull DataWriter<Object> rumWriter) {
        Intrinsics.checkNotNullParameter(logWriter, (String)"logWriter");
        Intrinsics.checkNotNullParameter(rumWriter, (String)"rumWriter");
        this.dataPersistenceExecutorService.submit(() -> DatadogNdkCrashHandler.handleNdkCrash$lambda-1(this, logWriter, rumWriter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readCrashData() {
        block24: {
            if (!this.ndkCrashDataDirectory.exists()) {
                return;
            }
            try {
                File[] fileArray = this.ndkCrashDataDirectory.listFiles();
                if (fileArray == null) {
                    break block24;
                }
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    String string = it.getName();
                    if (string == null) continue;
                    int n2 = -1;
                    switch (string.hashCode()) {
                        case 1847397036: {
                            if (string.equals(CRASH_DATA_FILE_NAME)) {
                                n2 = 1;
                            }
                            break;
                        }
                        case -528983909: {
                            if (string.equals(NETWORK_INFO_FILE_NAME)) {
                                n2 = 2;
                            }
                            break;
                        }
                        case 75377097: {
                            if (string.equals(RUM_VIEW_EVENT_FILE_NAME)) {
                                n2 = 3;
                            }
                            break;
                        }
                        case 408381112: {
                            if (string.equals(USER_INFO_FILE_NAME)) {
                                n2 = 4;
                            }
                            break;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            this.setLastSerializedNdkCrashLog$dd_sdk_android_release(FilesKt.readText$default((File)it, null, (int)1, null));
                            break;
                        }
                        case 3: {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            this.setLastSerializedRumViewEvent$dd_sdk_android_release(FilesKt.readText$default((File)it, null, (int)1, null));
                            break;
                        }
                        case 4: {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            this.setLastSerializedUserInformation$dd_sdk_android_release(FilesKt.readText$default((File)it, null, (int)1, null));
                            break;
                        }
                        case 2: {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            this.setLastSerializedNetworkInformation$dd_sdk_android_release(FilesKt.readText$default((File)it, null, (int)1, null));
                        }
                    }
                }
            }
            catch (SecurityException e) {
                Logger.e$default(this.internalLogger, ERROR_READ_NDK_DIR, e, null, 4, null);
            }
            finally {
                this.clearCrashLog();
            }
        }
    }

    private final void checkAndHandleNdkCrashReport(DataWriter<LogEvent> logWriter, DataWriter<Object> rumWriter) {
        String lastSerializedRumViewEvent = this.lastSerializedRumViewEvent;
        String lastSerializedUserInformation = this.lastSerializedUserInformation;
        String lastSerializedNdkCrashLog = this.lastSerializedNdkCrashLog;
        String lastSerializedNetworkInformation = this.lastSerializedNetworkInformation;
        if (lastSerializedNdkCrashLog != null) {
            NetworkInfo networkInfo;
            UserInfo userInfo;
            boolean bl;
            String string;
            ViewEvent viewEvent;
            NdkCrashLog lastNdkCrashLog = this.ndkCrashLogDeserializer.deserialize(lastSerializedNdkCrashLog);
            String string2 = lastSerializedRumViewEvent;
            if (string2 == null) {
                viewEvent = null;
            } else {
                string = string2;
                boolean bl2 = false;
                bl = false;
                String it = string;
                boolean bl3 = false;
                Object object = this.rumEventDeserializer.deserialize(it);
                viewEvent = object instanceof ViewEvent ? (ViewEvent)object : null;
            }
            ViewEvent lastRumViewEvent = viewEvent;
            string = lastSerializedUserInformation;
            if (string == null) {
                userInfo = null;
            } else {
                String string3 = string;
                bl = false;
                boolean bl4 = false;
                String it = string3;
                boolean bl5 = false;
                userInfo = this.userInfoDeserializer.deserialize(it);
            }
            UserInfo lastUserInfo = userInfo;
            String string4 = lastSerializedNetworkInformation;
            if (string4 == null) {
                networkInfo = null;
            } else {
                String string5 = string4;
                boolean bl6 = false;
                boolean bl7 = false;
                String it = string5;
                boolean bl8 = false;
                networkInfo = this.networkInfoDeserializer.deserialize(it);
            }
            NetworkInfo lastNetworkInfo = networkInfo;
            this.handleNdkCrashLog(logWriter, rumWriter, lastNdkCrashLog, lastRumViewEvent, lastUserInfo, lastNetworkInfo);
        }
        this.clearAllReferences();
    }

    private final void clearAllReferences() {
        this.lastSerializedNdkCrashLog = null;
        this.lastSerializedNetworkInformation = null;
        this.lastSerializedRumViewEvent = null;
        this.lastSerializedUserInformation = null;
    }

    private final void handleNdkCrashLog(DataWriter<LogEvent> logWriter, DataWriter<Object> rumWriter, NdkCrashLog ndkCrashLog, ViewEvent lastViewEvent, UserInfo lastUserInfo, NetworkInfo lastNetworkInfo) {
        if (ndkCrashLog == null) {
            return;
        }
        String string = LOG_CRASH_MSG;
        Pair[] pairArray = Locale.US;
        Object[] objectArray = new Object[]{ndkCrashLog.getSignalName()};
        boolean bl = false;
        String string2 = String.format((Locale)pairArray, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
        String errorLogMessage = string2;
        Map logAttributes = null;
        if (lastViewEvent != null) {
            pairArray = new Pair[]{TuplesKt.to((Object)"session_id", (Object)lastViewEvent.getSession().getId()), TuplesKt.to((Object)"application_id", (Object)lastViewEvent.getApplication().getId()), TuplesKt.to((Object)"view.id", (Object)lastViewEvent.getView().getId()), TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace())};
            logAttributes = MapsKt.mapOf((Pair[])pairArray);
            this.updateViewEventAndSendError(rumWriter, errorLogMessage, ndkCrashLog, lastViewEvent);
        } else {
            logAttributes = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()));
        }
        this.sendCrashLogEvent(logWriter, errorLogMessage, logAttributes, ndkCrashLog, lastNetworkInfo, lastUserInfo);
    }

    private final void updateViewEventAndSendError(DataWriter<Object> rumWriter, String errorLogMessage, NdkCrashLog ndkCrashLog, ViewEvent lastViewEvent) {
        ErrorEvent toSendErrorEvent = this.resolveErrorEventFromViewEvent(errorLogMessage, ndkCrashLog, lastViewEvent);
        rumWriter.write(toSendErrorEvent);
        long sessionsTimeDifference = System.currentTimeMillis() - lastViewEvent.getDate();
        if (sessionsTimeDifference < VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD) {
            ViewEvent updatedViewEvent = this.updateViewEvent(lastViewEvent);
            rumWriter.write(updatedViewEvent);
        }
    }

    private final void sendCrashLogEvent(DataWriter<LogEvent> logWriter, String errorLogMessage, Map<String, String> logAttributes, NdkCrashLog ndkCrashLog, NetworkInfo lastNetworkInfo, UserInfo lastUserInfo) {
        Set set = SetsKt.emptySet();
        long l = ndkCrashLog.getTimestamp();
        LogEvent log = LogGenerator.generateLog$default(this.logGenerator, 9, errorLogMessage, null, logAttributes, set, l, null, false, false, lastUserInfo, lastNetworkInfo, 64, null);
        logWriter.write(log);
    }

    private final ViewEvent updateViewEvent(ViewEvent lastViewEvent) {
        ViewEvent.Crash currentCrash = lastViewEvent.getView().getCrash();
        ViewEvent.Crash crash = currentCrash;
        ViewEvent.Crash crash2 = crash == null ? null : crash.copy(currentCrash.getCount() + 1L);
        ViewEvent.Crash newCrash = crash2 == null ? new ViewEvent.Crash(1L) : crash2;
        return ViewEvent.copy$default(lastViewEvent, 0L, null, null, null, ViewEvent.View.copy$default(lastViewEvent.getView(), null, null, null, null, null, null, 0L, null, null, null, null, null, null, null, null, null, null, false, null, null, null, newCrash, null, null, null, null, null, null, null, null, null, null, -2228225, null), null, null, null, ViewEvent.Dd.copy$default(lastViewEvent.getDd(), null, lastViewEvent.getDd().getDocumentVersion() + 1L, 1, null), null, 751, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ErrorEvent resolveErrorEventFromViewEvent(String errorLogMessage, NdkCrashLog ndkCrashLog, ViewEvent viewEvent) {
        Object object;
        ErrorEvent.Connectivity connectivity;
        ViewEvent.Connectivity connectivity2 = viewEvent.getConnectivity();
        if (connectivity2 == null) {
            connectivity = null;
        } else {
            void $this$mapTo$iv$iv;
            object = connectivity2;
            boolean bl = false;
            boolean bl2 = false;
            ViewEvent.Connectivity it = object;
            boolean bl3 = false;
            ErrorEvent.Status connectivityStatus = ErrorEvent.Status.valueOf(it.getStatus().name());
            Iterable $this$map$iv = it.getInterfaces();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ViewEvent.Interface interface_ = (ViewEvent.Interface)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ErrorEvent.Interface interface_2 = ErrorEvent.Interface.valueOf(it2.name());
                collection.add(interface_2);
            }
            List connectivityInterfaces = (List)destination$iv$iv;
            ViewEvent.Cellular cellular = it.getCellular();
            String string = cellular == null ? null : cellular.getTechnology();
            cellular = it.getCellular();
            ErrorEvent.Cellular cellular2 = new ErrorEvent.Cellular(string, cellular == null ? null : cellular.getCarrierName());
            connectivity = new ErrorEvent.Connectivity(connectivityStatus, connectivityInterfaces, cellular2);
        }
        ErrorEvent.Connectivity connectivity3 = connectivity;
        Object object2 = viewEvent.getContext();
        object = object2 == null ? null : ((ViewEvent.Context)object2).getAdditionalProperties();
        Object additionalProperties = object == null ? MapsKt.emptyMap() : object;
        Object object3 = viewEvent.getUsr();
        object2 = object3 == null ? null : ((ViewEvent.Usr)object3).getAdditionalProperties();
        Object additionalUserProperties = object2 == null ? MapsKt.emptyMap() : object2;
        object2 = viewEvent.getView().getId();
        object3 = viewEvent.getView().getName();
        String string = viewEvent.getView().getReferrer();
        String string2 = viewEvent.getView().getUrl();
        ErrorEvent.View view = new ErrorEvent.View((String)object2, string, string2, (String)object3, null, 16, null);
        object2 = viewEvent.getUsr();
        String string3 = object2 == null ? null : ((ViewEvent.Usr)object2).getId();
        object2 = viewEvent.getUsr();
        String string4 = object2 == null ? null : ((ViewEvent.Usr)object2).getName();
        object2 = viewEvent.getUsr();
        return new ErrorEvent(ndkCrashLog.getTimestamp() + this.timeProvider.getServerOffsetMillis(), new ErrorEvent.Application(viewEvent.getApplication().getId()), viewEvent.getService(), new ErrorEvent.ErrorEventSession(viewEvent.getSession().getId(), ErrorEvent.ErrorEventSessionType.USER, null, 4, null), view, new ErrorEvent.Usr(string3, string4, object2 == null ? null : ((ViewEvent.Usr)object2).getEmail(), (Map<String, ? extends Object>)additionalUserProperties), connectivity3, null, new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1)), new ErrorEvent.Context((Map<String, ? extends Object>)additionalProperties), new ErrorEvent.Error(null, errorLogMessage, ErrorEvent.Source.SOURCE, ndkCrashLog.getStacktrace(), true, ndkCrashLog.getSignalName(), null, null, ErrorEvent.SourceType.ANDROID, null, 705, null), null, 2176, null);
    }

    private final void clearCrashLog() {
        if (this.ndkCrashDataDirectory.exists()) {
            try {
                File[] fileArray = this.ndkCrashDataDirectory.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    File[] fileArray2 = $this$forEach$iv;
                    int n = fileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = fileArray2[i];
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        FilesKt.deleteRecursively((File)it);
                    }
                }
            }
            catch (Throwable e) {
                Logger.e$default(this.internalLogger, Intrinsics.stringPlus((String)"Unable to clear the NDK crash report file: ", (Object)this.ndkCrashDataDirectory.getAbsolutePath()), e, null, 4, null);
            }
        }
    }

    private static final void prepareData$lambda-0(DatadogNdkCrashHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.readCrashData();
    }

    private static final void handleNdkCrash$lambda-1(DatadogNdkCrashHandler this$0, DataWriter $logWriter, DataWriter $rumWriter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$logWriter, (String)"$logWriter");
        Intrinsics.checkNotNullParameter((Object)$rumWriter, (String)"$rumWriter");
        this$0.checkAndHandleNdkCrashReport($logWriter, $rumWriter);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashHandler$Companion;", "", "()V", "CRASH_DATA_FILE_NAME", "", "DESERIALIZE_CRASH_EVENT_ERROR_MESSAGE", "ERROR_READ_NDK_DIR", "LOGGER_NAME", "LOG_CRASH_MSG", "NDK_CRASH_REPORTS_FOLDER_NAME", "NDK_CRASH_REPORTS_PENDING_FOLDER_NAME", "NETWORK_INFO_FILE_NAME", "RUM_VIEW_EVENT_FILE_NAME", "USER_INFO_FILE_NAME", "VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD", "", "getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_release", "()J", "getCrashDataFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "getCrashDataFile$dd_sdk_android_release", "getGrantedNetworkInfoFile", "getGrantedNetworkInfoFile$dd_sdk_android_release", "getGrantedUserInfoFile", "getGrantedUserInfoFile$dd_sdk_android_release", "getLastViewEventFile", "getLastViewEventFile$dd_sdk_android_release", "getNdkGrantedDir", "getNdkGrantedDir$dd_sdk_android_release", "getNdkPendingDir", "getNdkPendingDir$dd_sdk_android_release", "getPendingNetworkInfoFile", "getPendingNetworkInfoFile$dd_sdk_android_release", "getPendingUserInfoFile", "getPendingUserInfoFile$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_release() {
            return VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD;
        }

        @NotNull
        public final File getNdkGrantedDir$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(context.getFilesDir(), DatadogNdkCrashHandler.NDK_CRASH_REPORTS_FOLDER_NAME);
        }

        @NotNull
        public final File getNdkPendingDir$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(context.getFilesDir(), DatadogNdkCrashHandler.NDK_CRASH_REPORTS_PENDING_FOLDER_NAME);
        }

        @NotNull
        public final File getLastViewEventFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkGrantedDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.RUM_VIEW_EVENT_FILE_NAME);
        }

        @NotNull
        public final File getPendingNetworkInfoFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkPendingDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedNetworkInfoFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkGrantedDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getPendingUserInfoFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkPendingDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedUserInfoFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkGrantedDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        @NotNull
        public final File getCrashDataFile$dd_sdk_android_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new File(this.getNdkGrantedDir$dd_sdk_android_release(context), DatadogNdkCrashHandler.CRASH_DATA_FILE_NAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

