/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.monitor;

import android.os.Handler;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.TimeKt;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.RumApplicationScope;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.EventType;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.model.ViewEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 j2\u00020\u00012\u00020\u0002:\u0001jBo\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J8\u00100\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J8\u00103\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J\u0018\u00105\u001a\u00020*2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0004H\u0016J\u0018\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020\u0004H\u0016J.\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J\r\u0010B\u001a\u00020*H\u0000\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020\u00042\u0006\u0010@\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020*2\u0006\u0010E\u001a\u00020\u00042\u0006\u0010@\u001a\u00020FH\u0016J \u0010H\u001a\u0004\u0018\u00010I2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0002J \u0010J\u001a\u0004\u0018\u00010\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0002J\u001e\u0010K\u001a\u00020L2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0002J\u0015\u0010M\u001a\u00020*2\u0006\u0010N\u001a\u00020OH\u0000\u00a2\u0006\u0002\bPJ\b\u0010Q\u001a\u00020*H\u0016J6\u0010R\u001a\u00020*2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J.\u0010U\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J.\u0010V\u001a\u00020*2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J\r\u0010W\u001a\u00020*H\u0000\u00a2\u0006\u0002\bXJG\u0010Y\u001a\u00020*2\u0006\u0010:\u001a\u00020\u00042\b\u0010Z\u001a\u0004\u0018\u00010[2\b\u0010\\\u001a\u0004\u0018\u0001072\u0006\u0010]\u001a\u00020^2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016\u00a2\u0006\u0002\u0010_JM\u0010`\u001a\u00020*2\u0006\u0010:\u001a\u00020\u00042\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016\u00a2\u0006\u0002\u0010aJ.\u0010b\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020\u00042\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J\u001e\u0010b\u001a\u00020*2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J&\u0010c\u001a\u00020*2\u0006\u0010:\u001a\u00020\u000b2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b02H\u0016J \u0010d\u001a\u00020*2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010e\u001a\u0002072\u0006\u0010@\u001a\u00020fH\u0016J\u0010\u0010g\u001a\u00020*2\u0006\u0010h\u001a\u00020LH\u0016J\u0010\u0010i\u001a\u00020*2\u0006\u0010:\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor;", "Lcom/datadog/android/rum/RumMonitor;", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "applicationId", "", "samplingRate", "", "backgroundTrackingEnabled", "", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "", "handler", "Landroid/os/Handler;", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Ljava/lang/String;FZLcom/datadog/android/core/internal/persistence/DataWriter;Landroid/os/Handler;Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/core/internal/time/TimeProvider;Lcom/datadog/android/rum/RumSessionListener;Ljava/util/concurrent/ExecutorService;)V", "getBackgroundTrackingEnabled$dd_sdk_android_release", "()Z", "getHandler$dd_sdk_android_release", "()Landroid/os/Handler;", "keepAliveRunnable", "Ljava/lang/Runnable;", "getKeepAliveRunnable$dd_sdk_android_release", "()Ljava/lang/Runnable;", "rootScope", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getRootScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getSamplingRate$dd_sdk_android_release", "()F", "addCrash", "", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "throwable", "", "addError", "attributes", "", "addErrorWithStacktrace", "stacktrace", "addLongTask", "durationNs", "", "target", "addResourceTiming", "key", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "addTiming", "name", "addUserAction", "type", "Lcom/datadog/android/rum/RumActionType;", "drainExecutorService", "drainExecutorService$dd_sdk_android_release", "eventDropped", "viewId", "Lcom/datadog/android/rum/internal/monitor/EventType;", "eventSent", "getErrorSourceType", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "getErrorType", "getEventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "handleEvent$dd_sdk_android_release", "resetSession", "startResource", "method", "url", "startUserAction", "startView", "stopKeepAliveCallback", "stopKeepAliveCallback$dd_sdk_android_release", "stopResource", "statusCode", "", "size", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "stopResourceWithError", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "stopUserAction", "stopView", "updateViewLoadingTime", "loadingTimeInNs", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "viewTreeChanged", "eventTime", "waitForResourceTiming", "Companion", "dd-sdk-android_release"})
public final class DatadogRumMonitor
implements RumMonitor,
AdvancedRumMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float samplingRate;
    private final boolean backgroundTrackingEnabled;
    @NotNull
    private final DataWriter<Object> writer;
    @NotNull
    private final Handler handler;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final RumScope rootScope;
    @NotNull
    private final Runnable keepAliveRunnable;
    private static final long KEEP_ALIVE_MS = TimeUnit.MINUTES.toMillis(5L);

    public DatadogRumMonitor(@NotNull String applicationId, float samplingRate, boolean backgroundTrackingEnabled, @NotNull DataWriter<Object> writer, @NotNull Handler handler, @NotNull FirstPartyHostDetector firstPartyHostDetector, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull TimeProvider timeProvider, @Nullable RumSessionListener sessionListener, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.samplingRate = samplingRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.writer = writer;
        this.handler = handler;
        this.executorService = executorService;
        this.rootScope = new RumApplicationScope(applicationId, this.samplingRate, this.backgroundTrackingEnabled, firstPartyHostDetector, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, timeProvider, sessionListener);
        this.keepAliveRunnable = () -> DatadogRumMonitor.keepAliveRunnable$lambda-0(this);
        this.handler.postDelayed(this.keepAliveRunnable, KEEP_ALIVE_MS);
    }

    public /* synthetic */ DatadogRumMonitor(String string, float f, boolean bl, DataWriter dataWriter, Handler handler, FirstPartyHostDetector firstPartyHostDetector, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, TimeProvider timeProvider, RumSessionListener rumSessionListener, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(string, f, bl, dataWriter, handler, firstPartyHostDetector, vitalMonitor, vitalMonitor2, vitalMonitor3, timeProvider, rumSessionListener, executorService);
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_release() {
        return this.backgroundTrackingEnabled;
    }

    @NotNull
    public final Handler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    @NotNull
    public final RumScope getRootScope$dd_sdk_android_release() {
        return this.rootScope;
    }

    @NotNull
    public final Runnable getKeepAliveRunnable$dd_sdk_android_release() {
        return this.keepAliveRunnable;
    }

    @Override
    public void startView(@NotNull Object key, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartView(key, name, attributes, eventTime));
    }

    @Override
    public void stopView(@NotNull Object key, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopView(key, attributes, eventTime));
    }

    @Override
    public void addUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartAction(type, name, false, attributes, eventTime));
    }

    @Override
    public void startUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartAction(type, name, true, attributes, eventTime));
    }

    @Override
    public void stopUserAction(@NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopAction(null, null, attributes, null, 8, null));
    }

    @Override
    public void stopUserAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopAction(type, name, attributes, eventTime));
    }

    @Override
    public void startResource(@NotNull String key, @NotNull String method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StartResource(key, url, method, attributes, eventTime));
    }

    @Override
    public void stopResource(@NotNull String key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopResource(key, n == null ? null : Long.valueOf(n.intValue()), size, kind, attributes, eventTime));
    }

    @Override
    public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.StopResourceWithError(key, n == null ? null : Long.valueOf(n.intValue()), message, source, throwable, attributes, null, 64, null));
    }

    @Override
    public void addError(@NotNull String message, @NotNull RumErrorSource source, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, throwable, null, false, attributes, eventTime, errorType, null, 256, null));
    }

    @Override
    public void addErrorWithStacktrace(@NotNull String message, @NotNull RumErrorSource source, @Nullable String stacktrace, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        RumErrorSourceType rumErrorSourceType = this.getErrorSourceType(attributes);
        RumErrorSourceType errorSourceType = rumErrorSourceType == null ? RumErrorSourceType.ANDROID : rumErrorSourceType;
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, null, stacktrace, false, attributes, eventTime, errorType, errorSourceType));
    }

    @Override
    public void resetSession() {
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResetSession(null, 1, null));
    }

    @Override
    public void viewTreeChanged(@NotNull Time eventTime) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.ViewTreeChanged(eventTime));
    }

    @Override
    public void waitForResourceTiming(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.WaitForResourceTiming(key, null, 2, null));
    }

    @Override
    public void addResourceTiming(@NotNull String key, @NotNull ResourceTiming timing) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)timing, (String)"timing");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddResourceTiming(key, timing, null, 4, null));
    }

    @Override
    public void addCrash(@NotNull String message, @NotNull RumErrorSource source, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddError(message, source, throwable, null, true, MapsKt.emptyMap(), null, null, null, 448, null));
    }

    @Override
    public void updateViewLoadingTime(@NotNull Object key, long loadingTimeInNs, @NotNull ViewEvent.LoadingType type) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.UpdateViewLoadingTime(key, loadingTimeInNs, type, null, 8, null));
    }

    @Override
    public void addTiming(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddCustomTiming(name, null, 2, null));
    }

    @Override
    public void addLongTask(long durationNs, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.handleEvent$dd_sdk_android_release(new RumRawEvent.AddLongTask(durationNs, target, null, 4, null));
    }

    @Override
    public void eventSent(@NotNull String viewId, @NotNull EventType type) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        EventType eventType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()];
        switch (n) {
            case 1: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ActionSent(viewId, null, 2, null));
                break;
            }
            case 2: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResourceSent(viewId, null, 2, null));
                break;
            }
            case 3: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ErrorSent(viewId, null, 2, null));
                break;
            }
            case 4: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskSent(viewId, false, null, 4, null));
                break;
            }
            case 5: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskSent(viewId, true, null, 4, null));
            }
        }
    }

    @Override
    public void eventDropped(@NotNull String viewId, @NotNull EventType type) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        EventType eventType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()];
        switch (n) {
            case 1: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ActionDropped(viewId, null, 2, null));
                break;
            }
            case 2: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ResourceDropped(viewId, null, 2, null));
                break;
            }
            case 3: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.ErrorDropped(viewId, null, 2, null));
                break;
            }
            case 4: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskDropped(viewId, false, null, 4, null));
                break;
            }
            case 5: {
                this.handleEvent$dd_sdk_android_release(new RumRawEvent.LongTaskDropped(viewId, true, null, 4, null));
            }
        }
    }

    public final void drainExecutorService$dd_sdk_android_release() {
        ThreadPoolExecutor threadPoolExecutor;
        boolean bl = false;
        ArrayList tasks = new ArrayList();
        Object object = this.executorService;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = object instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object : null;
        if (threadPoolExecutor != null && (object = threadPoolExecutor.getQueue()) != null) {
            object.drainTo(tasks);
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl2 = false;
            it.run();
        }
    }

    public final void handleEvent$dd_sdk_android_release(@NotNull RumRawEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).isFatal()) {
            this.rootScope.handleEvent(event, this.writer);
        } else {
            this.handler.removeCallbacks(this.keepAliveRunnable);
            if (!this.executorService.isShutdown()) {
                this.executorService.submit(() -> DatadogRumMonitor.handleEvent$lambda-3(this, event));
            }
        }
    }

    public final void stopKeepAliveCallback$dd_sdk_android_release() {
        this.handler.removeCallbacks(this.keepAliveRunnable);
    }

    private final Time getEventTime(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.timestamp");
        Long l = object instanceof Long ? (Long)object : null;
        Time time = l == null ? null : TimeKt.asTime(l);
        return time == null ? new Time(0L, 0L, 3, null) : time;
    }

    private final String getErrorType(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.error_type");
        return object instanceof String ? (String)object : null;
    }

    private final RumErrorSourceType getErrorSourceType(Map<String, ? extends Object> attributes) {
        RumErrorSourceType rumErrorSourceType;
        String sourceType;
        Object object = attributes.get("_dd.error.source_type");
        String string = sourceType = object instanceof String ? (String)object : null;
        if (sourceType == null) {
            return null;
        }
        String string2 = sourceType;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        boolean bl = false;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        switch (string3) {
            case "android": {
                rumErrorSourceType = RumErrorSourceType.ANDROID;
                break;
            }
            case "react-native": {
                rumErrorSourceType = RumErrorSourceType.REACT_NATIVE;
                break;
            }
            case "browser": {
                rumErrorSourceType = RumErrorSourceType.BROWSER;
                break;
            }
            default: {
                rumErrorSourceType = RumErrorSourceType.ANDROID;
            }
        }
        return rumErrorSourceType;
    }

    private static final void keepAliveRunnable$lambda-0(DatadogRumMonitor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleEvent$dd_sdk_android_release(new RumRawEvent.KeepAlive(null, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleEvent$lambda-3(DatadogRumMonitor this$0, RumRawEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        RumScope rumScope = this$0.getRootScope$dd_sdk_android_release();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (rumScope) {
            boolean bl3 = false;
            RumScope rumScope2 = this$0.getRootScope$dd_sdk_android_release().handleEvent($event, this$0.writer);
        }
        this$0.getHandler$dd_sdk_android_release().postDelayed(this$0.getKeepAliveRunnable$dd_sdk_android_release(), KEEP_ALIVE_MS);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor$Companion;", "", "()V", "KEEP_ALIVE_MS", "", "getKEEP_ALIVE_MS$dd_sdk_android_release", "()J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getKEEP_ALIVE_MS$dd_sdk_android_release() {
            return KEEP_ALIVE_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventType.values().length];
            nArray[EventType.ACTION.ordinal()] = 1;
            nArray[EventType.RESOURCE.ordinal()] = 2;
            nArray[EventType.ERROR.ordinal()] = 3;
            nArray[EventType.LONG_TASK.ordinal()] = 4;
            nArray[EventType.FROZEN_FRAME.ordinal()] = 5;
            nArray[EventType.VIEW.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

