/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.content.res.Resources;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.rum.tracking.InteractionPredicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\n"}, d2={"idAsStringHexa", "", "id", "", "resolveTargetName", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "target", "", "resourceIdName", "dd-sdk-android_release"})
public final class GesturesUtilsKt {
    @NotNull
    public static final String resolveTargetName(@NotNull InteractionPredicate interactionPredicate, @NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String customTargetName = interactionPredicate.getTargetName(target);
        CharSequence charSequence = customTargetName;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0) ? customTargetName : "";
    }

    @NotNull
    public static final String resourceIdName(int id) {
        String string;
        try {
            Resources resources;
            Context context = (Context)CoreFeature.INSTANCE.getContextRef$dd_sdk_android_release().get();
            string = context == null ? null : ((resources = context.getResources()) == null ? null : resources.getResourceEntryName(id));
            string = string == null ? GesturesUtilsKt.idAsStringHexa(id) : string;
        }
        catch (Resources.NotFoundException e) {
            string = GesturesUtilsKt.idAsStringHexa(id);
        }
        return string;
    }

    private static final String idAsStringHexa(int id) {
        int n = id;
        int n2 = 16;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return Intrinsics.stringPlus((String)"0x", (Object)string);
    }
}

